/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.web.bindery.event.shared.HandlerRegistration;
import java.util.HashMap;
import java.util.Map;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.client.resources.i18n.DisplayerTypeConstants;
import org.dashbuilder.displayer.client.resources.images.DisplayerImagesResources;
import org.dashbuilder.displayer.client.widgets.DisplayerSubtypeSelector;
import org.gwtbootstrap3.client.ui.Image;
import org.gwtbootstrap3.client.ui.constants.ImageType;

public class DisplayerSubtypeSelectorView
extends Composite
implements DisplayerSubtypeSelector.View {
    DisplayerSubtypeSelector presenter;
    Map<DisplayerSubType, DisplayerSubTypeImageWidget> imageWidgets = new HashMap<DisplayerSubType, DisplayerSubTypeImageWidget>(5);
    FlexTable subtypes = new FlexTable();
    VerticalPanel subtypePanel = new VerticalPanel();
    DisplayerSubTypeImageWidget selectedWidget = null;

    public void init(DisplayerSubtypeSelector presenter) {
        this.presenter = presenter;
        this.subtypePanel.add((Widget)this.subtypes);
        this.initWidget((Widget)this.subtypePanel);
    }

    @Override
    public void clear() {
        this.subtypes.removeAllRows();
        this.imageWidgets.clear();
    }

    @Override
    public void show(DisplayerType type, final DisplayerSubType subtype) {
        String resourcePrefix = type.toString() + "_" + subtype.toString();
        ImageResource selectedIR = (ImageResource)DisplayerImagesResources.INSTANCE.getResource(resourcePrefix + "_selected");
        ImageResource unselectedIR = (ImageResource)DisplayerImagesResources.INSTANCE.getResource(resourcePrefix + "_unselected");
        String tooltip = DisplayerTypeConstants.INSTANCE.getString(resourcePrefix + "_tt");
        final DisplayerSubTypeImageWidget dstiw = new DisplayerSubTypeImageWidget(selectedIR, unselectedIR, tooltip, false);
        this.imageWidgets.put(subtype, dstiw);
        this.subtypes.setWidget(this.subtypes.getRowCount(), 0, (Widget)dstiw);
        dstiw.setSelectClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!dstiw.isSelected) {
                    DisplayerSubtypeSelectorView.this.select(subtype);
                    DisplayerSubtypeSelectorView.this.presenter.onSelect(subtype);
                }
            }
        });
    }

    @Override
    public void select(DisplayerSubType subtype) {
        if (this.selectedWidget != null) {
            this.selectedWidget.unselect();
        }
        this.selectedWidget = this.imageWidgets.get(subtype);
        this.selectedWidget.select();
    }

    @Override
    public void showDefault(DisplayerType type) {
        ImageResource selectedIR = (ImageResource)DisplayerImagesResources.INSTANCE.getResource(type.toString() + "_default");
        String tooltip = DisplayerTypeConstants.INSTANCE.getString(type.toString() + "_default" + "_tt");
        DisplayerSubTypeImageWidget dstiw = new DisplayerSubTypeImageWidget(selectedIR, null, tooltip, true);
        this.subtypes.clear();
        this.subtypes.setWidget(0, 0, (Widget)dstiw);
    }

    public class DisplayerSubTypeImageWidget
    extends Composite {
        private FlexTable container = new FlexTable();
        private boolean isSelected = false;
        private Image selected;
        private Image unselected;

        public DisplayerSubTypeImageWidget(ImageResource selectedImage, ImageResource unselectedImage, String tooltip, boolean initiallySelected) {
            this.initWidget((Widget)this.container);
            this.isSelected = initiallySelected;
            if (selectedImage != null) {
                this.selected = new Image(selectedImage);
                this.selected.setType(ImageType.THUMBNAIL);
                this.selected.setTitle(tooltip);
                this.selected.setVisible(this.isSelected);
                this.selected.addStyleName("selDispSubtype");
                this.container.setWidget(0, 0, (Widget)this.selected);
            }
            if (unselectedImage != null) {
                this.unselected = new Image(unselectedImage);
                this.unselected.setType(ImageType.THUMBNAIL);
                this.unselected.setTitle(tooltip);
                this.unselected.setVisible(!this.isSelected);
                this.container.setWidget(0, 1, (Widget)this.unselected);
            }
        }

        public HandlerRegistration setSelectClickHandler(ClickHandler selectedClickHandler) {
            return this.unselected != null ? this.unselected.addClickHandler(selectedClickHandler) : null;
        }

        public void select() {
            this.isSelected = true;
            this.selected.setVisible(true);
            this.unselected.setVisible(false);
        }

        public void unselect() {
            this.isSelected = false;
            this.selected.setVisible(false);
            this.unselected.setVisible(true);
        }
    }
}

