/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.client.RendererLibrary;
import org.dashbuilder.displayer.client.RendererManager;
import org.dashbuilder.displayer.client.events.DisplayerSubtypeSelectedEvent;
import org.uberfire.client.mvp.UberView;

@Dependent
public class DisplayerSubtypeSelector
implements IsWidget {
    View view = null;
    RendererManager rendererManager;
    DisplayerSubType selectedSubtype;
    Event<DisplayerSubtypeSelectedEvent> selectEvent;

    @Inject
    public DisplayerSubtypeSelector(View view, RendererManager rendererManager, Event<DisplayerSubtypeSelectedEvent> selectEvent) {
        this.view = view;
        this.rendererManager = rendererManager;
        this.selectEvent = selectEvent;
        view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public DisplayerSubType getSelectedSubtype() {
        return this.selectedSubtype;
    }

    public void init(DisplayerType type, DisplayerSubType selectedSubType) {
        this.view.clear();
        RendererLibrary rendererLibrary = this.rendererManager.getRendererForType(type);
        if (rendererLibrary != null) {
            List<DisplayerSubType> supportedSubTypes = rendererLibrary.getSupportedSubtypes(type);
            if (supportedSubTypes != null && supportedSubTypes.size() > 0) {
                for (int i = 0; i < supportedSubTypes.size(); ++i) {
                    DisplayerSubType subtype = supportedSubTypes.get(i);
                    if (!type.getSubTypes().contains(subtype)) {
                        throw new RuntimeException("Wrong subtype (" + subtype + ") indicated for type " + type + " by renderer library " + rendererLibrary.getUUID());
                    }
                    boolean initiallySelected = selectedSubType != null ? subtype == selectedSubType : i == 0;
                    this.view.show(type, subtype);
                    if (!initiallySelected) continue;
                    this.view.select(subtype);
                }
            } else {
                this.view.showDefault(type);
            }
        }
    }

    void onSelect(DisplayerSubType subtype) {
        this.selectedSubtype = subtype;
        this.selectEvent.fire((Object)new DisplayerSubtypeSelectedEvent(this.selectedSubtype));
    }

    public static interface View
    extends UberView<DisplayerSubtypeSelector> {
        public void clear();

        public void show(DisplayerType var1, DisplayerSubType var2);

        public void select(DisplayerSubType var1);

        public void showDefault(DisplayerType var1);
    }
}

