/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.group;

import com.github.gwtbootstrap.client.ui.CheckBox;
import com.github.gwtbootstrap.client.ui.ListBox;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.dashbuilder.dataset.client.resources.i18n.DateIntervalTypeConstants;
import org.dashbuilder.dataset.client.resources.i18n.DayOfWeekConstants;
import org.dashbuilder.dataset.client.resources.i18n.MonthConstants;
import org.dashbuilder.dataset.date.DayOfWeek;
import org.dashbuilder.dataset.date.Month;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.group.GroupStrategy;

@Dependent
public class DataSetGroupDateEditor
extends Composite {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    Listener listener = null;
    ColumnGroup columnGroup = null;
    @UiField
    CheckBox fixedStrategyCheckBox;
    @UiField
    ListBox intervalTypeListBox;
    @UiField
    VerticalPanel maxIntervalsGroup;
    @UiField
    VerticalPanel firstDayPanel;
    @UiField
    VerticalPanel firstMonthPanel;
    @UiField
    TextBox maxIntervalsTextBox;
    @UiField
    CheckBox emptyIntervalsCheckBox;
    @UiField
    ListBox firstDayListBox;
    @UiField
    ListBox firstMonthListBox;

    public DataSetGroupDateEditor() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    public void init(ColumnGroup columnGroup, Listener listener) {
        this.columnGroup = columnGroup;
        this.listener = listener;
        if (columnGroup != null) {
            if (this.isFixedStrategy()) {
                this.gotoFixedMode();
            } else {
                this.gotoDynamicMode();
            }
        }
    }

    protected boolean isFixedStrategy() {
        return GroupStrategy.FIXED.equals((Object)this.columnGroup.getStrategy());
    }

    protected void initIntervalTypeListBox() {
        this.intervalTypeListBox.clear();
        DateIntervalType current = DateIntervalType.getByName((String)this.columnGroup.getIntervalSize());
        List<DateIntervalType> entries = this.getListOfIntervalTypes();
        for (int i = 0; i < entries.size(); ++i) {
            DateIntervalType entry = entries.get(i);
            this.intervalTypeListBox.addItem(DateIntervalTypeConstants.INSTANCE.getString(entry.name()));
            if (current == null || !current.equals((Object)entry)) continue;
            this.intervalTypeListBox.setSelectedIndex(i);
        }
    }

    protected List<DateIntervalType> getListOfIntervalTypes() {
        if (this.isFixedStrategy()) {
            return DateIntervalType.FIXED_INTERVALS_SUPPORTED;
        }
        return Arrays.asList(DateIntervalType.values());
    }

    protected void initFirstDayListBox() {
        this.firstDayPanel.setVisible(true);
        this.firstDayListBox.clear();
        DayOfWeek current = this.columnGroup.getFirstDayOfWeek();
        DayOfWeek[] entries = DayOfWeek.values();
        for (int i = 0; i < entries.length; ++i) {
            DayOfWeek entry = entries[i];
            this.firstDayListBox.addItem(DayOfWeekConstants.INSTANCE.getString(entry.name()));
            if (current == null || !current.equals((Object)entry)) continue;
            this.firstDayListBox.setSelectedIndex(i);
        }
    }

    protected void initFirstMonthListBox() {
        this.firstMonthPanel.setVisible(true);
        this.firstMonthListBox.clear();
        Month current = this.columnGroup.getFirstMonthOfYear();
        Month[] entries = Month.values();
        for (int i = 0; i < entries.length; ++i) {
            Month entry = entries[i];
            this.firstMonthListBox.addItem(MonthConstants.INSTANCE.getString(entry.name()));
            if (current == null || !current.equals((Object)entry)) continue;
            this.firstMonthListBox.setSelectedIndex(i);
        }
    }

    protected void initMaxIntervalsTextBox() {
        this.maxIntervalsGroup.setVisible(true);
        this.maxIntervalsTextBox.setText(Integer.toString(this.columnGroup.getMaxIntervals()));
    }

    protected void initEmptyIntervalsCheckBox() {
        this.emptyIntervalsCheckBox.setValue(Boolean.valueOf(this.columnGroup.areEmptyIntervalsAllowed()));
    }

    protected void resetCommon() {
        this.fixedStrategyCheckBox.setValue(Boolean.valueOf(this.isFixedStrategy()));
        this.maxIntervalsGroup.setVisible(false);
        this.firstDayPanel.setVisible(false);
        this.firstMonthPanel.setVisible(false);
        this.initIntervalTypeListBox();
        this.initEmptyIntervalsCheckBox();
    }

    public void gotoDynamicMode() {
        this.resetCommon();
        this.initMaxIntervalsTextBox();
    }

    public void gotoFixedMode() {
        this.resetCommon();
        DateIntervalType current = DateIntervalType.getByName((String)this.columnGroup.getIntervalSize());
        if (DateIntervalType.DAY_OF_WEEK.equals((Object)current)) {
            this.initFirstDayListBox();
        } else if (DateIntervalType.MONTH.equals((Object)current)) {
            this.initFirstMonthListBox();
        }
    }

    @UiHandler(value={"fixedStrategyCheckBox"})
    public void onFixedModeSelected(ClickEvent clickEvent) {
        this.columnGroup.setFirstMonthOfYear(null);
        this.columnGroup.setFirstDayOfWeek(null);
        if (this.fixedStrategyCheckBox.getValue().booleanValue()) {
            DateIntervalType intervalType = DateIntervalType.getByIndex((int)this.intervalTypeListBox.getSelectedIndex());
            if (!DateIntervalType.FIXED_INTERVALS_SUPPORTED.contains(intervalType)) {
                this.intervalTypeListBox.setSelectedIndex(DateIntervalType.MONTH.getIndex());
                this.columnGroup.setIntervalSize(DateIntervalType.MONTH.name());
            }
            this.columnGroup.setStrategy(GroupStrategy.FIXED);
            this.gotoFixedMode();
        } else {
            this.columnGroup.setStrategy(GroupStrategy.DYNAMIC);
            this.gotoDynamicMode();
        }
        if (this.listener != null) {
            this.listener.columnGroupChanged(this.columnGroup);
        }
    }

    @UiHandler(value={"intervalTypeListBox"})
    public void onIntervalTypeSelected(ChangeEvent changeEvent) {
        DateIntervalType intervalType = DateIntervalType.getByIndex((int)this.intervalTypeListBox.getSelectedIndex());
        if (this.isFixedStrategy()) {
            intervalType = (DateIntervalType)DateIntervalType.FIXED_INTERVALS_SUPPORTED.get(this.intervalTypeListBox.getSelectedIndex());
        }
        this.columnGroup.setIntervalSize(intervalType.name());
        this.columnGroup.setFirstMonthOfYear(null);
        this.columnGroup.setFirstDayOfWeek(null);
        this.firstMonthPanel.setVisible(false);
        this.firstDayPanel.setVisible(false);
        if (GroupStrategy.FIXED.equals((Object)this.columnGroup.getStrategy())) {
            if (DateIntervalType.MONTH.equals((Object)DateIntervalType.getByName((String)this.columnGroup.getIntervalSize()))) {
                this.firstMonthPanel.setVisible(true);
                this.initFirstMonthListBox();
            } else if (DateIntervalType.DAY_OF_WEEK.equals((Object)DateIntervalType.getByName((String)this.columnGroup.getIntervalSize()))) {
                this.firstDayPanel.setVisible(true);
                this.initFirstDayListBox();
            }
        }
        if (this.listener != null) {
            this.listener.columnGroupChanged(this.columnGroup);
        }
    }

    @UiHandler(value={"emptyIntervalsCheckBox"})
    public void onEmptyIntervalsChanged(ClickEvent clickEvent) {
        this.columnGroup.setEmptyIntervalsAllowed(this.emptyIntervalsCheckBox.getValue().booleanValue());
        if (this.listener != null) {
            this.listener.columnGroupChanged(this.columnGroup);
        }
    }

    @UiHandler(value={"maxIntervalsTextBox"})
    public void onMaxIntervalsChanged(ChangeEvent changeEvent) {
        try {
            this.columnGroup.setMaxIntervals(Integer.parseInt(this.maxIntervalsTextBox.getValue()));
            if (this.listener != null) {
                this.listener.columnGroupChanged(this.columnGroup);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @UiHandler(value={"firstDayListBox"})
    public void onFirstDaySelected(ChangeEvent changeEvent) {
        DayOfWeek dayOfWeek = DayOfWeek.getByIndex((int)(this.firstDayListBox.getSelectedIndex() + 1));
        this.columnGroup.setFirstDayOfWeek(dayOfWeek);
        if (this.listener != null) {
            this.listener.columnGroupChanged(this.columnGroup);
        }
    }

    @UiHandler(value={"firstMonthListBox"})
    public void onFirstMonthSelected(ChangeEvent changeEvent) {
        Month month = Month.getByIndex((int)(this.firstMonthListBox.getSelectedIndex() + 1));
        this.columnGroup.setFirstMonthOfYear(month);
        if (this.listener != null) {
            this.listener.columnGroupChanged(this.columnGroup);
        }
    }

    static interface Binder
    extends UiBinder<Widget, DataSetGroupDateEditor> {
    }

    public static interface Listener {
        public void columnGroupChanged(ColumnGroup var1);
    }
}

