/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.formatter;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.dashbuilder.displayer.client.formatter.ValueFormatter;

@ApplicationScoped
public class ValueFormatterRegistry {
    Map<String, Map<String, ValueFormatter>> formatterMap = new HashMap<String, Map<String, ValueFormatter>>();
    public static final String _UNASSIGNED = "_unassigned";

    public void register(String columnId, ValueFormatter formatter) {
        Map<String, ValueFormatter> m = this.formatterMap.get(_UNASSIGNED);
        if (m == null) {
            m = new HashMap<String, ValueFormatter>();
            this.formatterMap.put(_UNASSIGNED, m);
        }
        m.put(columnId, formatter);
    }

    public void register(String displayerUuid, String columnId, ValueFormatter formatter) {
        Map<String, ValueFormatter> m = this.formatterMap.get(displayerUuid);
        if (m == null) {
            m = new HashMap<String, ValueFormatter>();
            this.formatterMap.put(displayerUuid, m);
        }
        m.put(columnId, formatter);
    }

    public Map<String, ValueFormatter> get(String displayerUuid) {
        HashMap<String, ValueFormatter> results = new HashMap<String, ValueFormatter>();
        Map<String, ValueFormatter> m = this.formatterMap.get(_UNASSIGNED);
        if (m != null) {
            results.putAll(m);
        }
        if ((m = this.formatterMap.get(displayerUuid)) != null) {
            results.putAll(m);
        }
        return results;
    }
}

