/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.filter;

import com.github.gwtbootstrap.client.ui.ListBox;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.dashbuilder.dataset.client.resources.i18n.DateIntervalTypeConstants;
import org.dashbuilder.dataset.client.resources.i18n.TimeModeConstants;
import org.dashbuilder.dataset.date.TimeAmount;
import org.dashbuilder.dataset.date.TimeInstant;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;
import org.dashbuilder.displayer.client.widgets.filter.TimeAmountEditor;

@Dependent
public class TimeInstantEditor
extends Composite {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    Listener listener = null;
    TimeInstant timeInstant = null;
    boolean timeModeRequired = true;
    @UiField
    ListBox timeModeList;
    @UiField
    ListBox intervalTypeList;
    @UiField
    TimeAmountEditor timeAmountEditor;
    static List<DateIntervalType> ALLOWED_TYPES = Arrays.asList(DateIntervalType.MINUTE, DateIntervalType.HOUR, DateIntervalType.DAY, DateIntervalType.MONTH, DateIntervalType.QUARTER, DateIntervalType.YEAR, DateIntervalType.CENTURY, DateIntervalType.MILLENIUM);

    public TimeInstantEditor() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    public void init(TimeInstant instant, boolean timeModeRequired, Listener listener) {
        this.timeModeRequired = timeModeRequired;
        this.listener = listener;
        this.timeInstant = instant != null ? instant : new TimeInstant();
        this.refreshUI();
    }

    public void refreshUI() {
        this.initTimeModeListBox();
        this.initIntervalTypeListBox();
        this.intervalTypeList.setVisible(false);
        TimeInstant.TimeMode timeMode = this.timeInstant.getTimeMode();
        if (timeMode != null && !timeMode.equals((Object)TimeInstant.TimeMode.NOW)) {
            this.intervalTypeList.setVisible(true);
        }
        TimeAmount timeAmount = this.timeInstant.getTimeAmount();
        this.timeAmountEditor.init(timeAmount, new TimeAmountEditor.Listener(){

            @Override
            public void valueChanged(TimeAmount timeAmount) {
                TimeInstantEditor.this.onTimeAmountChanged(timeAmount);
            }
        });
    }

    protected void initTimeModeListBox() {
        this.timeModeList.clear();
        if (!this.timeModeRequired) {
            this.timeModeList.addItem(CommonConstants.INSTANCE.common_dropdown_select());
        }
        TimeInstant.TimeMode current = this.timeInstant.getTimeMode();
        TimeInstant.TimeMode[] modes = TimeInstant.TimeMode.values();
        for (int i = 0; i < modes.length; ++i) {
            TimeInstant.TimeMode mode = modes[i];
            this.timeModeList.addItem(TimeModeConstants.INSTANCE.getString(mode.name()));
            if (current == null || !current.equals((Object)mode)) continue;
            this.timeModeList.setSelectedIndex(this.timeModeRequired ? i : i + 1);
        }
    }

    protected void initIntervalTypeListBox() {
        this.intervalTypeList.clear();
        DateIntervalType current = this.timeInstant.getIntervalType();
        for (int i = 0; i < ALLOWED_TYPES.size(); ++i) {
            DateIntervalType type = ALLOWED_TYPES.get(i);
            this.intervalTypeList.addItem(DateIntervalTypeConstants.INSTANCE.getString(type.name()));
            if (current == null || !current.equals((Object)type)) continue;
            this.intervalTypeList.setSelectedIndex(i);
        }
    }

    @UiHandler(value={"timeModeList"})
    public void onTimeModeSelected(ChangeEvent changeEvent) {
        int selectedIdx = this.timeModeList.getSelectedIndex();
        TimeInstant.TimeMode mode = null;
        mode = this.timeModeRequired ? TimeInstant.TimeMode.getByIndex((int)selectedIdx) : (selectedIdx == 0 ? null : TimeInstant.TimeMode.getByIndex((int)(selectedIdx - 1)));
        this.timeInstant.setTimeMode(mode);
        TimeAmount timeAmount = this.timeInstant.getTimeAmount();
        if (timeAmount != null) {
            timeAmount.setQuantity(0L);
        }
        this.listener.valueChanged(this.timeInstant);
        this.refreshUI();
    }

    @UiHandler(value={"intervalTypeList"})
    public void onIntervalTypeSelected(ChangeEvent changeEvent) {
        int selectedIdx = this.intervalTypeList.getSelectedIndex();
        DateIntervalType intervalType = ALLOWED_TYPES.get(selectedIdx);
        this.timeInstant.setIntervalType(intervalType);
        this.listener.valueChanged(this.timeInstant);
        this.refreshUI();
    }

    public void onTimeAmountChanged(TimeAmount timeAmount) {
        this.timeInstant.setTimeAmount(timeAmount);
        this.listener.valueChanged(this.timeInstant);
    }

    static interface Binder
    extends UiBinder<Widget, TimeInstantEditor> {
    }

    static interface Listener {
        public void valueChanged(TimeInstant var1);
    }
}

