/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.filter;

import com.github.gwtbootstrap.client.ui.Icon;
import com.github.gwtbootstrap.client.ui.ListBox;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.client.resources.i18n.CoreFunctionTypeConstants;
import org.dashbuilder.dataset.date.TimeFrame;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.displayer.client.widgets.filter.DateParameterEditor;
import org.dashbuilder.displayer.client.widgets.filter.NumberParameterEditor;
import org.dashbuilder.displayer.client.widgets.filter.TextParameterEditor;
import org.dashbuilder.displayer.client.widgets.filter.TimeFrameEditor;

@Dependent
public class ColumnFilterEditor
extends Composite {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    private static DateTimeFormat dateTimeFormat = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_SHORT);
    private static NumberFormat numberFormat = NumberFormat.getDecimalFormat();
    Listener listener = null;
    ColumnFilter filter = null;
    DataSetMetadata metadata = null;
    @UiField
    ListBox filterListBox;
    @UiField
    Icon filterDeleteIcon;
    @UiField
    Icon filterExpandIcon;
    @UiField
    Panel filterDetailsPanel;

    public ColumnFilterEditor() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.filterExpandIcon.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                ColumnFilterEditor.this.expandOrCollapse();
            }
        }, ClickEvent.getType());
        this.filterDeleteIcon.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                ColumnFilterEditor.this.delete();
            }
        }, ClickEvent.getType());
    }

    public void init(DataSetMetadata metadata, ColumnFilter filter, Listener listener) {
        this.filter = filter;
        this.listener = listener;
        this.metadata = metadata;
        this.filterExpandIcon.setType(IconType.ARROW_DOWN);
        this.filterExpandIcon.setVisible(this.hasDetails());
        this.initFilterListBox();
    }

    public ColumnFilter getFilter() {
        return this.filter;
    }

    public CoreFunctionFilter getCoreFilter() {
        try {
            return (CoreFunctionFilter)this.filter;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean hasDetails() {
        CoreFunctionFilter coreFilter = this.getCoreFilter();
        return coreFilter != null && coreFilter.getType().getParametersCount() > 0;
    }

    public void expand() {
        if (this.hasDetails()) {
            this.filterExpandIcon.setVisible(true);
            this.filterExpandIcon.setType(IconType.ARROW_UP);
            this.filterDetailsPanel.setVisible(true);
            this.initFilterDetailsPanel();
        }
    }

    public void collapse() {
        this.filterDetailsPanel.setVisible(false);
        this.filterExpandIcon.setType(IconType.ARROW_DOWN);
        this.filterExpandIcon.setVisible(this.hasDetails());
    }

    public void expandOrCollapse() {
        if (this.filterDetailsPanel.isVisible()) {
            this.collapse();
        } else {
            this.expand();
        }
    }

    public void delete() {
        this.listener.columnFilterDeleted(this);
    }

    @UiHandler(value={"filterListBox"})
    public void onFilterSelected(ChangeEvent changeEvent) {
        int selectedIdx = this.filterListBox.getSelectedIndex();
        if (selectedIdx > 0) {
            CoreFunctionFilter coreFilter = this.getCoreFilter();
            ColumnType columnType = this.metadata.getColumnType(coreFilter.getColumnId());
            List functionTypes = CoreFunctionType.getSupportedTypes((ColumnType)columnType);
            CoreFunctionType functionType = (CoreFunctionType)functionTypes.get(selectedIdx - 1);
            List params = FilterFactory.createParameters((ColumnType)columnType, (CoreFunctionType)functionType);
            coreFilter.setType(functionType);
            coreFilter.setParameters(params);
            this.filterUpdated();
            if (this.hasDetails()) {
                this.expand();
            } else {
                this.collapse();
            }
        }
    }

    protected void initFilterListBox() {
        CoreFunctionFilter coreFilter = this.getCoreFilter();
        if (coreFilter != null) {
            this.filterListBox.clear();
            String currentFilter = this.formatFilter(coreFilter);
            this.filterListBox.addItem(currentFilter);
            this.filterListBox.setTitle(currentFilter);
            ColumnType columnType = this.metadata.getColumnType(coreFilter.getColumnId());
            List functionTypes = CoreFunctionType.getSupportedTypes((ColumnType)columnType);
            for (int i = 0; i < functionTypes.size(); ++i) {
                CoreFunctionType ft = (CoreFunctionType)functionTypes.get(i);
                String function = CoreFunctionTypeConstants.INSTANCE.getString(ft.name());
                this.filterListBox.addItem(function);
            }
        }
    }

    protected void initFilterDetailsPanel() {
        this.filterDetailsPanel.clear();
        CoreFunctionFilter coreFilter = this.getCoreFilter();
        for (int i = 0; i < coreFilter.getType().getParametersCount(); ++i) {
            Widget paramInput = this.createParamInputWidget(coreFilter, i);
            this.filterDetailsPanel.add(paramInput);
        }
    }

    protected void filterUpdated() {
        this.listener.columnFilterChanged(this);
        this.initFilterListBox();
    }

    protected Widget createParamInputWidget(CoreFunctionFilter coreFilter, int paramIndex) {
        List paramList = coreFilter.getParameters();
        ColumnType columnType = this.metadata.getColumnType(coreFilter.getColumnId());
        if (ColumnType.DATE.equals((Object)columnType)) {
            if (CoreFunctionType.TIME_FRAME.equals((Object)coreFilter.getType())) {
                return this.createTimeFrameWidget(paramList, paramIndex);
            }
            return this.createDateInputWidget(paramList, paramIndex);
        }
        if (ColumnType.NUMBER.equals((Object)columnType)) {
            return this.createNumberInputWidget(paramList, paramIndex);
        }
        return this.createTextInputWidget(paramList, paramIndex);
    }

    protected Widget createDateInputWidget(final List paramList, final int paramIndex) {
        Date param = (Date)paramList.get(paramIndex);
        DateParameterEditor input = new DateParameterEditor();
        input.init(param, new DateParameterEditor.Listener(){

            @Override
            public void valueChanged(Date d) {
                paramList.set(paramIndex, d);
                ColumnFilterEditor.this.filterUpdated();
            }
        });
        return input;
    }

    protected Widget createNumberInputWidget(final List paramList, final int paramIndex) {
        Number param = (Number)paramList.get(paramIndex);
        NumberParameterEditor input = new NumberParameterEditor();
        input.init(param, new NumberParameterEditor.Listener(){

            @Override
            public void valueChanged(Number n) {
                paramList.set(paramIndex, n);
                ColumnFilterEditor.this.filterUpdated();
            }
        });
        return input;
    }

    protected Widget createTextInputWidget(final List paramList, final int paramIndex) {
        String param = (String)paramList.get(paramIndex);
        TextParameterEditor input = new TextParameterEditor();
        input.init(param, new TextParameterEditor.Listener(){

            @Override
            public void valueChanged(String s) {
                paramList.set(paramIndex, s);
                ColumnFilterEditor.this.filterUpdated();
            }
        });
        return input;
    }

    protected Widget createTimeFrameWidget(final List paramList, final int paramIndex) {
        TimeFrame timeFrame = TimeFrame.parse((String)((String)paramList.get(paramIndex)));
        TimeFrameEditor input = new TimeFrameEditor();
        input.init(timeFrame, new TimeFrameEditor.Listener(){

            @Override
            public void valueChanged(TimeFrame tf) {
                paramList.set(paramIndex, tf.toString());
                ColumnFilterEditor.this.filterUpdated();
            }
        });
        return input;
    }

    protected String formatFilter(CoreFunctionFilter f) {
        String columnId = f.getColumnId();
        CoreFunctionType type = f.getType();
        StringBuilder out = new StringBuilder();
        if (CoreFunctionType.BETWEEN.equals((Object)type)) {
            out.append(columnId).append(" [");
            this.formatParameters(out, f.getParameters());
            out.append("]");
        } else if (CoreFunctionType.GREATER_THAN.equals((Object)type)) {
            out.append(columnId).append(" > ");
            this.formatParameters(out, f.getParameters());
        } else if (CoreFunctionType.GREATER_OR_EQUALS_TO.equals((Object)type)) {
            out.append(columnId).append(" >= ");
            this.formatParameters(out, f.getParameters());
        } else if (CoreFunctionType.LOWER_THAN.equals((Object)type)) {
            out.append(columnId).append(" < ");
            this.formatParameters(out, f.getParameters());
        } else if (CoreFunctionType.LOWER_OR_EQUALS_TO.equals((Object)type)) {
            out.append(columnId).append(" <= ");
            this.formatParameters(out, f.getParameters());
        } else if (CoreFunctionType.EQUALS_TO.equals((Object)type)) {
            out.append(columnId).append(" = ");
            this.formatParameters(out, f.getParameters());
        } else if (CoreFunctionType.NOT_EQUALS_TO.equals((Object)type)) {
            out.append(columnId).append(" != ");
            this.formatParameters(out, f.getParameters());
        } else if (CoreFunctionType.IS_NULL.equals((Object)type)) {
            out.append(columnId).append(" = null ");
            this.formatParameters(out, f.getParameters());
        } else if (CoreFunctionType.NOT_NULL.equals((Object)type)) {
            out.append(columnId).append(" != null ");
            this.formatParameters(out, f.getParameters());
        } else if (CoreFunctionType.TIME_FRAME.equals((Object)type)) {
            out.append(columnId).append(" = ");
            this.formatParameters(out, f.getParameters());
        }
        return out.toString();
    }

    protected StringBuilder formatParameters(StringBuilder out, List parameters) {
        for (int i = 0; i < parameters.size(); ++i) {
            if (i > 0) {
                out.append("  ");
            }
            out.append(this.formatParameter(parameters.get(i)));
        }
        return out;
    }

    protected String formatParameter(Object p) {
        if (p == null) {
            return "";
        }
        if (p instanceof Date) {
            Date d = (Date)p;
            return dateTimeFormat.format(d);
        }
        if (p instanceof Number) {
            Number n = (Number)p;
            return numberFormat.format(n);
        }
        return p.toString();
    }

    static interface Binder
    extends UiBinder<Widget, ColumnFilterEditor> {
    }

    public static interface Listener {
        public void columnFilterChanged(ColumnFilterEditor var1);

        public void columnFilterDeleted(ColumnFilterEditor var1);
    }
}

