/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import org.dashbuilder.dataset.client.DataSetClientServiceError;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.AbstractDisplayerListener;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerHelper;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.displayer.client.widgets.DisplayerError;
import org.dashbuilder.displayer.client.widgets.RendererSelector;
import org.uberfire.commons.validation.PortablePreconditions;

public class DisplayerView
extends Composite {
    private static final String RENDERER_SELECTOR_WIDTH = "300px";
    protected DisplayerSettings displayerSettings;
    protected Panel container = new FlowPanel();
    protected Label label = new Label();
    protected Displayer displayer;
    protected Boolean isShowRendererSelector = false;
    protected DisplayerError errorWidget = new DisplayerError();
    DisplayerListener displayerListener = new AbstractDisplayerListener(){

        @Override
        public void onError(Displayer displayer, DataSetClientServiceError error) {
            DisplayerView.this.error(error);
        }
    };

    public DisplayerView() {
        this.initWidget((Widget)this.container);
    }

    public DisplayerView(DisplayerSettings settings) {
        this();
        this.displayerSettings = settings;
    }

    public DisplayerSettings getDisplayerSettings() {
        return this.displayerSettings;
    }

    public void setDisplayerSettings(DisplayerSettings displayerSettings) {
        this.displayerSettings = displayerSettings;
    }

    public void setIsShowRendererSelector(Boolean isShowRendererSelector) {
        this.isShowRendererSelector = isShowRendererSelector;
    }

    public Displayer getDisplayer() {
        return this.displayer;
    }

    public Displayer draw() {
        try {
            PortablePreconditions.checkNotNull((String)"displayerSettings", (Object)this.displayerSettings);
            this.displayer = DisplayerHelper.lookupDisplayer(this.displayerSettings);
            this.displayer.addListener(this.displayerListener);
            DisplayerHelper.draw(this.displayer);
            this.container.clear();
            final FlowPanel displayerContainer = new FlowPanel();
            displayerContainer.add((IsWidget)this.displayer);
            if (this.isShowRendererSelector.booleanValue()) {
                RendererSelector rendererSelector = new RendererSelector(this.displayerSettings, RendererSelector.SelectorType.TAB, new RendererSelector.RendererSelectorEventHandler(){

                    @Override
                    public void onRendererSelected(RendererSelector.RendererSelectorEvent event) {
                        DisplayerView.this.displayerSettings.setRenderer(event.getRenderer());
                        DisplayerView.this.displayer = DisplayerHelper.lookupDisplayer(DisplayerView.this.displayerSettings);
                        DisplayerHelper.draw(DisplayerView.this.displayer);
                        displayerContainer.clear();
                        displayerContainer.add((IsWidget)DisplayerView.this.displayer);
                    }
                });
                rendererSelector.setWidth(RENDERER_SELECTOR_WIDTH);
                this.container.add((Widget)rendererSelector);
            }
            this.container.add((Widget)displayerContainer);
        }
        catch (Exception e) {
            this.error(e.getMessage(), e);
        }
        return this.displayer;
    }

    public Displayer redraw() {
        try {
            PortablePreconditions.checkNotNull((String)"displayerSettings", (Object)this.displayerSettings);
            PortablePreconditions.checkNotNull((String)"displayer", (Object)this.displayer);
            this.displayer.setDisplayerSettings(this.displayerSettings);
            DisplayerHelper.redraw(this.displayer);
        }
        catch (Exception e) {
            this.error(e.getMessage(), e);
        }
        return this.displayer;
    }

    public void error(String message, Throwable e) {
        String cause = e != null ? e.getMessage() : null;
        this.container.clear();
        this.container.add((Widget)this.errorWidget);
        this.errorWidget.show(message, cause);
        if (e != null) {
            GWT.log((String)message, (Throwable)e);
        } else {
            GWT.log((String)message);
        }
    }

    public void error(DataSetClientServiceError error) {
        String message = error.getThrowable() != null ? error.getThrowable().getMessage() : error.getMessage().toString();
        Throwable e = error.getThrowable();
        if (e.getCause() != null) {
            e = e.getCause();
        }
        this.error(message, e);
    }
}

