/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client;

import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.common.client.StringUtils;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.client.ClientDataSetManager;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.DataSetHandlerImpl;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.RendererLibrary;
import org.dashbuilder.displayer.client.RendererManager;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.IOCBeanDef;

@ApplicationScoped
public class DisplayerLocator {
    @Inject
    ClientDataSetManager clientDataSetManager;

    public static DisplayerLocator get() {
        Collection beans = IOC.getBeanManager().lookupBeans(DisplayerLocator.class);
        IOCBeanDef beanDef = (IOCBeanDef)beans.iterator().next();
        return (DisplayerLocator)beanDef.getInstance();
    }

    public Displayer lookupDisplayer(DisplayerSettings target) {
        RendererLibrary renderer = RendererManager.get().getRendererForDisplayer(target);
        Displayer displayer = renderer.lookupDisplayer(target);
        if (displayer == null) {
            String rendererUuid = target.getRenderer();
            if (StringUtils.isBlank((String)rendererUuid)) {
                throw new RuntimeException(CommonConstants.INSTANCE.displayerlocator_default_renderer_undeclared(target.getType().toString()));
            }
            throw new RuntimeException(CommonConstants.INSTANCE.displayerlocator_unsupported_displayer_renderer(target.getType().toString(), rendererUuid));
        }
        displayer.setDisplayerSettings(target);
        DataSetLookup dataSetLookup = target.getDataSetLookup();
        if (target.getDataSet() != null) {
            DataSet dataSet = target.getDataSet();
            this.clientDataSetManager.registerDataSet(dataSet);
            dataSetLookup = new DataSetLookup(dataSet.getUUID(), new DataSetOp[0]);
        }
        DataSetHandlerImpl handler = new DataSetHandlerImpl(dataSetLookup);
        displayer.setDataSetHandler(handler);
        return displayer;
    }
}

