/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Composite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dashbuilder.common.client.StringUtils;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.ValidationError;
import org.dashbuilder.dataset.client.DataSetClientServiceError;
import org.dashbuilder.dataset.client.resources.i18n.DayOfWeekConstants;
import org.dashbuilder.dataset.client.resources.i18n.MonthConstants;
import org.dashbuilder.dataset.date.DayOfWeek;
import org.dashbuilder.dataset.date.Month;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.DateIntervalPattern;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.group.GroupStrategy;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.DataSetHandler;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;

public abstract class AbstractDisplayer
extends Composite
implements Displayer {
    protected DataSetHandler dataSetHandler;
    protected DisplayerSettings displayerSettings;
    protected DisplayerConstraints displayerConstraints;
    protected List<DisplayerListener> listenerList = new ArrayList<DisplayerListener>();
    protected Map<String, List<Interval>> columnSelectionMap = new HashMap<String, List<Interval>>();
    protected boolean refreshEnabled = true;
    protected boolean drawn = false;
    protected Timer refreshTimer = null;
    public static final String[] _jsMalicious = new String[]{"document.", "window.", "alert(", "eval(", ".innerHTML"};
    private static Map<String, NumberFormat> numberPatternMap = new HashMap<String, NumberFormat>();
    private static Map<String, DateTimeFormat> datePatternMap = new HashMap<String, DateTimeFormat>();

    public abstract DisplayerConstraints createDisplayerConstraints();

    @Override
    public DisplayerConstraints getDisplayerConstraints() {
        if (this.displayerConstraints == null) {
            this.displayerConstraints = this.createDisplayerConstraints();
        }
        return this.displayerConstraints;
    }

    @Override
    public DisplayerSettings getDisplayerSettings() {
        return this.displayerSettings;
    }

    @Override
    public void setDisplayerSettings(DisplayerSettings displayerSettings) {
        this.checkDisplayerSettings(displayerSettings);
        this.displayerSettings = displayerSettings;
    }

    public void checkDisplayerSettings(DisplayerSettings displayerSettings) {
        ValidationError error;
        DisplayerConstraints constraints = this.getDisplayerConstraints();
        if (this.displayerConstraints != null && (error = constraints.check(displayerSettings)) != null) {
            throw error;
        }
    }

    @Override
    public DataSetHandler getDataSetHandler() {
        return this.dataSetHandler;
    }

    @Override
    public void setDataSetHandler(DataSetHandler dataSetHandler) {
        this.dataSetHandler = dataSetHandler;
    }

    @Override
    public void addListener(DisplayerListener listener) {
        this.listenerList.add(listener);
    }

    public String getDisplayerId() {
        String id = this.displayerSettings.getUUID();
        if (!StringUtils.isBlank((String)id)) {
            return id;
        }
        id = this.displayerSettings.getTitle();
        if (!StringUtils.isBlank((String)id)) {
            int hash = id.hashCode();
            return Integer.toString(hash < 0 ? hash * -1 : hash);
        }
        return null;
    }

    @Override
    public boolean isDrawn() {
        return this.drawn;
    }

    @Override
    public void setRefreshOn(boolean enabled) {
        boolean changed = enabled != this.refreshEnabled;
        this.refreshEnabled = enabled;
        if (changed) {
            this.updateRefreshTimer();
        }
    }

    @Override
    public boolean isRefreshOn() {
        return this.refreshTimer != null;
    }

    protected void updateRefreshTimer() {
        int seconds = this.displayerSettings.getRefreshInterval();
        if (this.refreshEnabled && seconds > 0) {
            if (this.refreshTimer == null) {
                this.refreshTimer = new Timer(){

                    public void run() {
                        if (AbstractDisplayer.this.isDrawn()) {
                            AbstractDisplayer.this.redraw();
                        }
                    }
                };
            }
            this.refreshTimer.schedule(seconds * 1000);
        } else if (this.refreshTimer != null) {
            this.refreshTimer.cancel();
        }
    }

    protected void afterDraw() {
        this.drawn = true;
        this.updateRefreshTimer();
        for (DisplayerListener listener : this.listenerList) {
            listener.onDraw(this);
        }
    }

    protected void afterRedraw() {
        this.updateRefreshTimer();
        for (DisplayerListener listener : this.listenerList) {
            listener.onRedraw(this);
        }
    }

    protected void afterClose() {
        this.setRefreshOn(false);
        for (DisplayerListener listener : this.listenerList) {
            listener.onClose(this);
        }
    }

    protected void afterError(Displayer displayer, DataSetClientServiceError error) {
        for (DisplayerListener listener : this.listenerList) {
            listener.onError(displayer, error);
        }
    }

    @Override
    public void onDraw(Displayer displayer) {
    }

    @Override
    public void onRedraw(Displayer displayer) {
    }

    @Override
    public void onClose(Displayer displayer) {
    }

    @Override
    public void onError(Displayer displayer, DataSetClientServiceError error) {
        this.afterError(displayer, error);
    }

    @Override
    public void onFilterEnabled(Displayer displayer, DataSetGroup groupOp) {
        if (this.displayerSettings.isFilterListeningEnabled()) {
            this.dataSetHandler.filter(groupOp);
            this.redraw();
        }
    }

    @Override
    public void onFilterReset(Displayer displayer, List<DataSetGroup> groupOps) {
        if (this.displayerSettings.isFilterListeningEnabled()) {
            for (DataSetGroup groupOp : groupOps) {
                this.dataSetHandler.unfilter(groupOp);
            }
            this.redraw();
        }
    }

    protected Set<String> filterColumns() {
        return this.columnSelectionMap.keySet();
    }

    protected List<Interval> filterIntervals(String columnId) {
        List<Interval> selected = this.columnSelectionMap.get(columnId);
        if (selected == null) {
            return new ArrayList<Interval>();
        }
        return selected;
    }

    protected List<Integer> filterIndexes(String columnId) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        List<Interval> selected = this.columnSelectionMap.get(columnId);
        if (selected == null) {
            return result;
        }
        for (Interval interval : selected) {
            result.add(interval.getIndex());
        }
        return result;
    }

    protected void filterUpdate(String columnId, int row) {
        this.filterUpdate(columnId, row, null);
    }

    protected void filterUpdate(String columnId, int row, Integer maxSelections) {
        if (!this.displayerSettings.isFilterEnabled()) {
            return;
        }
        Interval intervalSelected = this.dataSetHandler.getInterval(columnId, row);
        if (intervalSelected == null) {
            return;
        }
        List<Interval> selectedIntervals = this.columnSelectionMap.get(columnId);
        if (selectedIntervals == null) {
            selectedIntervals = new ArrayList<Interval>();
            selectedIntervals.add(intervalSelected);
            this.columnSelectionMap.put(columnId, selectedIntervals);
            this.filterApply(columnId, selectedIntervals);
        } else if (selectedIntervals.contains(intervalSelected)) {
            selectedIntervals.remove(intervalSelected);
            if (!selectedIntervals.isEmpty()) {
                this.filterApply(columnId, selectedIntervals);
            } else {
                this.filterReset(columnId);
            }
        } else {
            if (this.displayerSettings.isFilterSelfApplyEnabled()) {
                selectedIntervals = new ArrayList<Interval>();
                this.columnSelectionMap.put(columnId, selectedIntervals);
            }
            selectedIntervals.add(intervalSelected);
            if (maxSelections != null && maxSelections > 0 && selectedIntervals.size() >= maxSelections) {
                this.filterReset(columnId);
            } else {
                this.filterApply(columnId, selectedIntervals);
            }
        }
    }

    protected void filterApply(String columnId, List<Interval> intervalList) {
        if (!this.displayerSettings.isFilterEnabled()) {
            return;
        }
        DataSetGroup groupOp = this.dataSetHandler.getGroupOperation(columnId);
        groupOp.setSelectedIntervalList(intervalList);
        if (this.displayerSettings.isFilterNotificationEnabled()) {
            for (DisplayerListener listener : this.listenerList) {
                listener.onFilterEnabled(this, groupOp);
            }
        }
        if (this.displayerSettings.isFilterSelfApplyEnabled()) {
            this.dataSetHandler.drillDown(groupOp);
            this.redraw();
        }
    }

    protected void filterReset(String columnId) {
        if (!this.displayerSettings.isFilterEnabled()) {
            return;
        }
        this.columnSelectionMap.remove(columnId);
        DataSetGroup groupOp = this.dataSetHandler.getGroupOperation(columnId);
        if (this.displayerSettings.isFilterNotificationEnabled()) {
            for (DisplayerListener listener : this.listenerList) {
                listener.onFilterReset(this, Arrays.asList(groupOp));
            }
        }
        if (this.displayerSettings.isFilterSelfApplyEnabled()) {
            this.dataSetHandler.drillUp(groupOp);
            this.redraw();
        }
    }

    protected void filterReset() {
        if (!this.displayerSettings.isFilterEnabled()) {
            return;
        }
        ArrayList<DataSetGroup> groupOpList = new ArrayList<DataSetGroup>();
        for (String columnId : this.columnSelectionMap.keySet()) {
            DataSetGroup groupOp = this.dataSetHandler.getGroupOperation(columnId);
            groupOpList.add(groupOp);
        }
        this.columnSelectionMap.clear();
        if (this.displayerSettings.isFilterNotificationEnabled()) {
            for (DisplayerListener listener : this.listenerList) {
                listener.onFilterReset(this, groupOpList);
            }
        }
        if (this.displayerSettings.isFilterSelfApplyEnabled()) {
            for (DataSetGroup groupOp : groupOpList) {
                this.dataSetHandler.drillUp(groupOp);
            }
            this.redraw();
        }
    }

    protected void sortApply(String columnId, SortOrder sortOrder) {
        this.dataSetHandler.sort(columnId, sortOrder);
    }

    protected String formatInterval(Interval interval, DataColumn column) {
        DateIntervalType intervalType;
        if (column == null || column.getColumnGroup() == null) {
            return interval.getName();
        }
        String type = interval.getType();
        if (StringUtils.isBlank((String)type)) {
            type = column.getIntervalType();
        }
        if (StringUtils.isBlank((String)type)) {
            type = column.getColumnGroup().getIntervalSize();
        }
        if ((intervalType = DateIntervalType.getByName((String)type)) != null) {
            String expression;
            ColumnSettings columnSettings = this.displayerSettings.getColumnSettings(column.getId());
            String pattern = columnSettings != null ? columnSettings.getValuePattern() : ColumnSettings.getDatePattern((DateIntervalType)intervalType);
            String string = expression = columnSettings != null ? columnSettings.getValueExpression() : null;
            if (pattern == null) {
                pattern = ColumnSettings.getDatePattern((DateIntervalType)intervalType);
            }
            if (expression == null && column.getColumnGroup().getStrategy().equals((Object)GroupStrategy.FIXED)) {
                expression = ColumnSettings.getFixedExpression((DateIntervalType)intervalType);
            }
            return this.formatDate(intervalType, column.getColumnGroup().getStrategy(), interval.getName(), pattern, expression);
        }
        return interval.getName();
    }

    public String formatValue(Object value, DataColumn column) {
        ColumnSettings columnSettings = this.displayerSettings.getColumnSettings(column);
        String pattern = columnSettings.getValuePattern();
        String empty = columnSettings.getEmptyTemplate();
        String expression = columnSettings.getValueExpression();
        if (value == null) {
            return empty;
        }
        DateIntervalType intervalType = DateIntervalType.getByName((String)column.getIntervalType());
        if (intervalType != null) {
            ColumnGroup columnGroup = column.getColumnGroup();
            return this.formatDate(intervalType, columnGroup.getStrategy(), value.toString(), pattern, expression);
        }
        ColumnType columnType = column.getColumnType();
        if (ColumnType.DATE.equals((Object)columnType)) {
            Date d = (Date)value;
            return this.getDateFormat(pattern).format(d);
        }
        if (ColumnType.NUMBER.equals((Object)columnType)) {
            double d = ((Number)value).doubleValue();
            if (!StringUtils.isBlank((String)expression)) {
                d = Double.parseDouble(this.applyExpression(value.toString(), expression));
            }
            return this.getNumberFormat(pattern).format(d);
        }
        if (StringUtils.isBlank((String)expression)) {
            return value.toString();
        }
        return this.applyExpression(value.toString(), expression);
    }

    protected String applyExpression(String val, String expr) {
        if (StringUtils.isBlank((String)expr)) {
            return val;
        }
        for (String keyword : _jsMalicious) {
            if (!expr.contains(keyword)) continue;
            throw new RuntimeException(CommonConstants.INSTANCE.displayer_keyword_not_allowed(expr));
        }
        try {
            return this.evalExpression(val, expr);
        }
        catch (Exception e) {
            throw new RuntimeException(CommonConstants.INSTANCE.displayer_expr_invalid_syntax(expr));
        }
    }

    protected native String evalExpression(String var1, String var2);

    protected NumberFormat getNumberFormat(String pattern) {
        if (StringUtils.isBlank((String)pattern)) {
            return this.getNumberFormat("#,##0.00");
        }
        NumberFormat format = numberPatternMap.get(pattern);
        if (format == null) {
            format = NumberFormat.getFormat((String)pattern);
            numberPatternMap.put(pattern, format);
        }
        return format;
    }

    protected String formatDate(DateIntervalType type, GroupStrategy strategy, String date, String pattern, String expression) {
        String str;
        if (date == null) {
            return null;
        }
        String string = str = GroupStrategy.FIXED.equals((Object)strategy) ? this.formatDateFixed(type, date) : this.formatDateDynamic(type, date, pattern);
        if (StringUtils.isBlank((String)expression)) {
            return str;
        }
        return this.applyExpression(str, expression);
    }

    protected String formatDateFixed(DateIntervalType type, String date) {
        if (date == null) {
            return null;
        }
        int index = Integer.parseInt(date);
        if (DateIntervalType.DAY_OF_WEEK.equals((Object)type)) {
            DayOfWeek dayOfWeek = DayOfWeek.getByIndex((int)index);
            return DayOfWeekConstants.INSTANCE.getString(dayOfWeek.name());
        }
        if (DateIntervalType.MONTH.equals((Object)type)) {
            Month month = Month.getByIndex((int)index);
            return MonthConstants.INSTANCE.getString(month.name());
        }
        return date;
    }

    protected String formatDateDynamic(DateIntervalType type, String date, String pattern) {
        if (date == null) {
            return null;
        }
        Date d = this.parseDynamicGroupDate(type, date);
        DateTimeFormat format = this.getDateFormat(pattern);
        return format.format(d);
    }

    protected Date parseDynamicGroupDate(DateIntervalType type, String date) {
        String pattern = DateIntervalPattern.getPattern((DateIntervalType)type);
        DateTimeFormat format = this.getDateFormat(pattern);
        return format.parse(date);
    }

    protected DateTimeFormat getDateFormat(String pattern) {
        if (StringUtils.isBlank((String)pattern)) {
            return this.getDateFormat("MMM dd, yyyy HH:mm");
        }
        DateTimeFormat format = datePatternMap.get(pattern);
        if (format == null) {
            format = DateTimeFormat.getFormat((String)pattern);
            datePatternMap.put(pattern, format);
        }
        return format;
    }
}

