/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.external;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import jsinterop.base.Js;
import org.dashbuilder.displayer.external.ExternalComponentMessage;
import org.dashbuilder.displayer.external.ExternalComponentMessageType;
import org.dashbuilder.displayer.external.ExternalDataSet;
import org.dashbuilder.displayer.external.ExternalFilterRequest;
import org.dashbuilder.displayer.external.FunctionCallRequest;
import org.dashbuilder.displayer.external.FunctionResponse;
import org.dashbuilder.displayer.external.FunctionResultType;

public class ExternalComponentMessageHelper {
    public static final String FUNCTION_NOT_FOUND = "Function not found.";
    public static final String FUNCTION_CALL_SUCESS = "Function called with success";
    public static final String FUNCTION_CALL_REQUEST_NOT_FOUND = "You must provide a function request to call a function.";
    public static final String FUNCTION_EXECUTION_ERROR_FOUND = "There was an error executing the function";
    static final String COMPONENT_RUNTIME_ID_PROP = "component_id";
    static final String DATA_SET_PROP = "dataSet";
    static final String FILTER_PROP = "filter";
    static final String FUNCTION_CALL_PROP = "functionCallRequest";
    static final String FUNCTION_RESPONSE_PROP = "functionResponse";
    static final String CONFIGURATION_ISSUE_PROP = "configurationIssue";

    public Optional<ExternalFilterRequest> filterRequest(ExternalComponentMessage message) {
        Object filterProp = message.getProperty(FILTER_PROP);
        if (filterProp != null) {
            ExternalFilterRequest filterRequest = (ExternalFilterRequest)Js.cast((Object)filterProp);
            return Optional.ofNullable(filterRequest);
        }
        return Optional.empty();
    }

    public Optional<FunctionCallRequest> functionCallRequest(ExternalComponentMessage message) {
        Object functionCallObj = message.getProperty(FUNCTION_CALL_PROP);
        if (functionCallObj != null) {
            FunctionCallRequest functionCallRequest = (FunctionCallRequest)Js.cast((Object)functionCallObj);
            return Optional.ofNullable(functionCallRequest);
        }
        return Optional.empty();
    }

    public ExternalComponentMessage newDataSetMessage(ExternalDataSet ds, Map<String, Object> componentProperties) {
        ExternalComponentMessage message = ExternalComponentMessage.create(ExternalComponentMessageType.DATASET.name(), componentProperties);
        message.setProperty(DATA_SET_PROP, ds);
        return message;
    }

    public ExternalComponentMessage newInitMessage(Map<String, Object> componentProperties) {
        return ExternalComponentMessage.create(ExternalComponentMessageType.INIT.name(), componentProperties);
    }

    public ExternalComponentMessage newFunctionError(FunctionCallRequest functionCallRequest, String errorMessage) {
        Map<String, Object> props = Collections.singletonMap(FUNCTION_RESPONSE_PROP, FunctionResponse.create(functionCallRequest, FunctionResultType.ERROR.name(), FUNCTION_EXECUTION_ERROR_FOUND, errorMessage));
        return ExternalComponentMessage.create(ExternalComponentMessageType.FUNCTION_RESPONSE.name(), props);
    }

    public ExternalComponentMessage newFunctionNotFound(FunctionCallRequest functionCallRequest) {
        Map<String, Object> props = Collections.singletonMap(FUNCTION_RESPONSE_PROP, FunctionResponse.create(functionCallRequest, FunctionResultType.NOT_FOUND.name(), FUNCTION_NOT_FOUND, null));
        return ExternalComponentMessage.create(ExternalComponentMessageType.FUNCTION_RESPONSE.name(), props);
    }

    public ExternalComponentMessage newFunctionRequestNotFound() {
        Map<String, Object> props = Collections.singletonMap(FUNCTION_RESPONSE_PROP, FunctionResponse.create(null, FunctionResultType.ERROR.name(), FUNCTION_CALL_REQUEST_NOT_FOUND, null));
        return ExternalComponentMessage.create(ExternalComponentMessageType.FUNCTION_RESPONSE.name(), props);
    }

    public ExternalComponentMessage newFunctionSuccess(FunctionCallRequest functionCallRequest, Object result) {
        Map<String, Object> props = Collections.singletonMap(FUNCTION_RESPONSE_PROP, FunctionResponse.create(functionCallRequest, FunctionResultType.SUCCESS.name(), FUNCTION_CALL_SUCESS, result));
        return ExternalComponentMessage.create(ExternalComponentMessageType.FUNCTION_RESPONSE.name(), props);
    }

    public void withId(ExternalComponentMessage message, String componentId) {
        message.setProperty(COMPONENT_RUNTIME_ID_PROP, componentId);
    }

    public Optional<String> getComponentId(ExternalComponentMessage message) {
        return this.getValue(COMPONENT_RUNTIME_ID_PROP, message);
    }

    public Optional<String> getConfigurationIssue(ExternalComponentMessage message) {
        return this.getValue(CONFIGURATION_ISSUE_PROP, message);
    }

    public boolean isInit(ExternalComponentMessage message) {
        String type = this.verifyTypeNotNull(message);
        return ExternalComponentMessageType.INIT.name().equals(type);
    }

    public ExternalComponentMessageType messageType(ExternalComponentMessage message) {
        String type = this.verifyTypeNotNull(message);
        return ExternalComponentMessageType.valueOf(type);
    }

    private String verifyTypeNotNull(ExternalComponentMessage message) {
        String type = message.getType();
        if (type == null) {
            throw new IllegalArgumentException("Message type cannot be null.");
        }
        return type;
    }

    private Optional<String> getValue(String valueKey, ExternalComponentMessage message) {
        Object valueObj = message.getProperty(valueKey);
        if (valueObj != null) {
            String componentId = valueObj.toString();
            return Optional.ofNullable(componentId);
        }
        return Optional.empty();
    }
}

