/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer;

import java.util.ArrayList;
import java.util.List;
import org.dashbuilder.displayer.DisplayerSubType;

public enum DisplayerType {
    BARCHART(DisplayerSubType.BAR, DisplayerSubType.BAR_STACKED, DisplayerSubType.COLUMN, DisplayerSubType.COLUMN_STACKED),
    PIECHART(DisplayerSubType.PIE, DisplayerSubType.PIE_3D, DisplayerSubType.DONUT),
    AREACHART(DisplayerSubType.AREA, DisplayerSubType.AREA_STACKED),
    LINECHART(DisplayerSubType.LINE, DisplayerSubType.SMOOTH),
    BUBBLECHART(new DisplayerSubType[0]),
    METERCHART(new DisplayerSubType[0]),
    TABLE(new DisplayerSubType[0]),
    MAP(DisplayerSubType.MAP_REGIONS, DisplayerSubType.MAP_MARKERS),
    SELECTOR(new DisplayerSubType[0]),
    METRIC(new DisplayerSubType[0]);

    private List<DisplayerSubType> subtypes = new ArrayList<DisplayerSubType>(5);

    private DisplayerType(DisplayerSubType ... subtypes) {
        for (DisplayerSubType displayerSubType : subtypes) {
            this.subtypes.add(displayerSubType);
        }
    }

    public static DisplayerType getByName(String str) {
        try {
            return DisplayerType.valueOf(str.toUpperCase());
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<DisplayerSubType> getSubTypes() {
        return this.subtypes;
    }
}

