/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.engine.function;

import java.util.List;
import org.dashbuilder.dataset.engine.function.AbstractFunction;
import org.dashbuilder.dataset.group.AggregateFunctionType;

public class MaxFunction
extends AbstractFunction {
    public AggregateFunctionType getType() {
        return AggregateFunctionType.MAX;
    }

    public double aggregate(List values) {
        if (values == null || values.isEmpty()) {
            return 0.0;
        }
        Number max = null;
        for (Number n : values) {
            if (n == null || max != null && !(n.doubleValue() > max.doubleValue())) continue;
            max = n;
        }
        if (max == null) {
            return 0.0;
        }
        double ret = this.round(max.doubleValue(), this.precission);
        return ret;
    }

    public double aggregate(List values, List<Integer> rows) {
        if (rows == null) {
            return this.aggregate(values);
        }
        if (rows.isEmpty()) {
            return 0.0;
        }
        if (values == null || values.isEmpty()) {
            return 0.0;
        }
        Number max = null;
        for (Integer row : rows) {
            Number n = (Number)values.get(row);
            if (n == null || max != null && !(n.doubleValue() > max.doubleValue())) continue;
            max = n;
        }
        if (max == null) {
            return 0.0;
        }
        double ret = this.round(max.doubleValue(), this.precission);
        return ret;
    }
}

