/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.engine.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dashbuilder.dataset.engine.group.IntervalList;
import org.dashbuilder.dataset.engine.index.DataSetIndexNode;
import org.dashbuilder.dataset.engine.index.DataSetIntervalIndex;
import org.dashbuilder.dataset.engine.index.DataSetIntervalIndexHolder;
import org.dashbuilder.dataset.engine.index.DataSetIntervalSetIndex;
import org.dashbuilder.dataset.engine.index.visitor.DataSetIndexVisitor;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.Interval;

public class DataSetGroupIndex
extends DataSetIndexNode
implements DataSetIntervalIndexHolder {
    ColumnGroup columnGroup = null;
    List<DataSetIntervalIndex> intervalIndexList = null;
    String intervalType = null;
    Object minValue = null;
    Object maxValue = null;
    List<DataSetGroupIndex> selectIndexList = null;
    String selectKey = null;

    public DataSetGroupIndex(ColumnGroup columnGroup) {
        this.columnGroup = columnGroup;
        this.intervalIndexList = new ArrayList<DataSetIntervalIndex>();
    }

    public DataSetGroupIndex(ColumnGroup columnGroup, IntervalList intervalList) {
        this(columnGroup);
        this.intervalType = intervalList.getIntervalType();
        this.minValue = intervalList.getMinValue();
        this.maxValue = intervalList.getMaxValue();
        for (Interval interval : intervalList) {
            this.intervalIndexList.add(new DataSetIntervalIndex(this, interval));
        }
    }

    public DataSetGroupIndex(String selectKey, List<DataSetIntervalIndex> intervalIndexes) {
        this(null);
        this.selectKey = selectKey;
        for (DataSetIntervalIndex index : intervalIndexes) {
            this.addIntervalIndex(index);
        }
    }

    public void addIntervalIndex(DataSetIntervalIndex index) {
        this.intervalType = index.getIntervalType();
        Comparable min = (Comparable)index.getMinValue();
        Comparable max = (Comparable)index.getMaxValue();
        if (this.minValue == null || ((Comparable)this.minValue).compareTo(min) > 0) {
            this.minValue = min;
        }
        if (this.maxValue == null || ((Comparable)this.maxValue).compareTo(max) < 0) {
            this.maxValue = max;
        }
        this.intervalIndexList.add(index);
    }

    public String getIntervalType() {
        return this.intervalType;
    }

    public Object getMinValue() {
        return this.minValue;
    }

    public Object getMaxValue() {
        return this.maxValue;
    }

    public void setIntervalType(String intervalType) {
        this.intervalType = intervalType;
    }

    public void setMinValue(Object minValue) {
        this.minValue = minValue;
    }

    public void setMaxValue(Object maxValue) {
        this.maxValue = maxValue;
    }

    @Override
    public List<DataSetIntervalIndex> getIntervalIndexes() {
        return this.intervalIndexList;
    }

    public List<DataSetIntervalIndex> getIntervalIndexes(List<Interval> intervalList) {
        ArrayList<DataSetIntervalIndex> result = new ArrayList<DataSetIntervalIndex>();
        for (Interval interval : intervalList) {
            DataSetIntervalIndex idx = this.getIntervalIndex(interval.getName());
            if (idx == null) continue;
            result.add(idx);
        }
        return result;
    }

    public DataSetIntervalIndex getIntervalIndex(String name) {
        for (DataSetIntervalIndex idx : this.intervalIndexList) {
            if (!idx.getName().equals(name)) continue;
            return idx;
        }
        return null;
    }

    public int indexOfIntervalIndex(DataSetIntervalIndex target) {
        for (int i = 0; i < this.intervalIndexList.size(); ++i) {
            DataSetIntervalIndex idx = this.intervalIndexList.get(i);
            if (!idx.getName().equals(target.getName())) continue;
            return i;
        }
        return -1;
    }

    public DataSetGroupIndex getSelectionIndex(List<Interval> intervalList) {
        if (this.selectIndexList == null) {
            return null;
        }
        String targetKey = this.buildSelectKey(intervalList);
        for (DataSetGroupIndex idx : this.selectIndexList) {
            if (!idx.selectKey.equals(targetKey)) continue;
            idx.reuseHit();
            return idx;
        }
        return null;
    }

    public DataSetGroupIndex indexSelection(List<Interval> intervalList, List<DataSetIntervalIndex> intervalIndexes) {
        if (this.selectIndexList == null) {
            this.selectIndexList = new ArrayList<DataSetGroupIndex>();
        }
        String key = this.buildSelectKey(intervalList);
        DataSetGroupIndex index = new DataSetGroupIndex(key, intervalIndexes);
        index.setParent(this);
        index.setBuildTime(this.buildTime);
        this.selectIndexList.add(index);
        return index;
    }

    protected String buildSelectKey(List<Interval> intervalList) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < intervalList.size(); ++i) {
            if (i > 0) {
                out.append(", ");
            }
            out.append(intervalList.get(i).getName());
        }
        return out.toString();
    }

    @Override
    public List<Integer> getRows() {
        if (this.intervalIndexList == null || this.intervalIndexList.isEmpty()) {
            return null;
        }
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (DataSetIntervalIndex intervalIndex : this.intervalIndexList) {
            results.addAll(intervalIndex.getRows());
        }
        return results;
    }

    public void indexIntervals(Collection<DataSetIntervalIndex> intervalsIdxs) {
        for (DataSetIntervalIndex idx : intervalsIdxs) {
            this.indexInterval(idx);
        }
    }

    public void indexInterval(DataSetIntervalIndex intervalIdx) {
        String intervalName = intervalIdx.getName();
        DataSetIntervalIndex existing = this.getIntervalIndex(intervalName);
        if (existing == null) {
            this.addIntervalIndex(intervalIdx);
        } else if (existing instanceof DataSetIntervalSetIndex) {
            ((DataSetIntervalSetIndex)existing).addIntervalIndex(intervalIdx);
        } else if (existing != intervalIdx) {
            int i = this.indexOfIntervalIndex(existing);
            DataSetIntervalSetIndex indexSet = new DataSetIntervalSetIndex(this, intervalName);
            indexSet.addIntervalIndex(existing);
            indexSet.addIntervalIndex(intervalIdx);
            this.intervalIndexList.set(i, indexSet);
        }
    }

    @Override
    public void acceptVisitor(DataSetIndexVisitor visitor) {
        super.acceptVisitor(visitor);
        for (DataSetIntervalIndex index : this.intervalIndexList) {
            index.acceptVisitor(visitor);
        }
    }

    @Override
    public String toString() {
        StringBuilder out = new StringBuilder(super.toString());
        if (this.columnGroup != null) {
            out.append(" column=").append(this.columnGroup.getColumnId());
        }
        if (this.selectKey != null) {
            out.append(" select=").append(this.selectKey);
        }
        return out.toString();
    }
}

