/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.engine.group;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.dashbuilder.dataset.date.Month;
import org.dashbuilder.dataset.date.Quarter;
import org.dashbuilder.dataset.engine.group.IntervalList;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.Interval;

public class IntervalListQuarter
extends IntervalList {
    protected Map<Integer, Interval> intervalMap = new HashMap<Integer, Interval>();

    public IntervalListQuarter(ColumnGroup columnGroup) {
        super(columnGroup);
        Month firstMonth = columnGroup.getFirstMonthOfYear();
        int monthIndex = firstMonth.getIndex();
        for (int i = 0; i < 4; ++i) {
            Quarter quarter = Quarter.getByIndex((int)(i + 1));
            Interval interval = new Interval(Integer.toString(quarter.getIndex()), i);
            this.add(interval);
            for (int j = 0; j < 3; ++j) {
                this.intervalMap.put(monthIndex - 1, interval);
                monthIndex = Month.nextIndex((int)monthIndex);
            }
        }
    }

    @Override
    public Interval locateInterval(Object value) {
        Date d = (Date)value;
        return this.intervalMap.get(d.getMonth());
    }
}

