/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.engine.filter;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.dashbuilder.dataset.date.TimeFrame;
import org.dashbuilder.dataset.engine.filter.DataSetFilterContext;
import org.dashbuilder.dataset.engine.filter.DataSetFunction;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;

public class CoreFunction
extends DataSetFunction {
    private CoreFunctionFilter coreFunctionFilter = null;
    Map<String, TimeFrameLimits> _timeFrameExprCache = new HashMap<String, TimeFrameLimits>();

    public CoreFunction(DataSetFilterContext ctx, CoreFunctionFilter coreFunctionFilter) {
        super(ctx, (ColumnFilter)coreFunctionFilter);
        this.coreFunctionFilter = coreFunctionFilter;
    }

    public Comparable getCurrentValue() {
        return (Comparable)this.getDataColumn().getValues().get(this.getContext().getCurrentRow());
    }

    public Comparable getParameter(int index) {
        if (index >= this.coreFunctionFilter.getParameters().size()) {
            return null;
        }
        return (Comparable)this.coreFunctionFilter.getParameters().get(index);
    }

    @Override
    public boolean pass() {
        CoreFunctionType type = this.coreFunctionFilter.getType();
        if (CoreFunctionType.IS_NULL.equals((Object)type)) {
            return this.isNull(this.getCurrentValue());
        }
        if (CoreFunctionType.NOT_NULL.equals((Object)type)) {
            return this.isNotNull(this.getCurrentValue());
        }
        if (CoreFunctionType.EQUALS_TO.equals((Object)type)) {
            return this.isEqualsTo(this.getCurrentValue());
        }
        if (CoreFunctionType.NOT_EQUALS_TO.equals((Object)type)) {
            return this.isNotEqualsTo(this.getCurrentValue());
        }
        if (CoreFunctionType.LIKE_TO.equals((Object)type)) {
            return this.isLikeTo(this.getCurrentValue());
        }
        if (CoreFunctionType.LOWER_THAN.equals((Object)type)) {
            return this.isLowerThan(this.getCurrentValue());
        }
        if (CoreFunctionType.LOWER_OR_EQUALS_TO.equals((Object)type)) {
            return this.isLowerThanOrEqualsTo(this.getCurrentValue());
        }
        if (CoreFunctionType.GREATER_THAN.equals((Object)type)) {
            return this.isGreaterThan(this.getCurrentValue());
        }
        if (CoreFunctionType.GREATER_OR_EQUALS_TO.equals((Object)type)) {
            return this.isGreaterThanOrEqualsTo(this.getCurrentValue());
        }
        if (CoreFunctionType.BETWEEN.equals((Object)type)) {
            return this.isBetween(this.getCurrentValue());
        }
        if (CoreFunctionType.TIME_FRAME.equals((Object)type)) {
            return this.timeFrame(this.getCurrentValue());
        }
        throw new IllegalArgumentException("Core function type not supported: " + type);
    }

    public boolean isNull(Comparable value) {
        return value == null;
    }

    public boolean isNotNull(Comparable value) {
        return !this.isNull(value);
    }

    public boolean isEqualsTo(Comparable value) {
        if (this.isNull(value)) {
            return false;
        }
        Comparable ref = this.getParameter(0);
        return ref.equals(value);
    }

    public boolean isNotEqualsTo(Comparable value) {
        return !this.isEqualsTo(value);
    }

    public boolean isLikeTo(Comparable value) {
        if (value == null) {
            return false;
        }
        Comparable param0 = this.getParameter(0);
        if (param0 == null) {
            return false;
        }
        Boolean caseSensitive = this.getParameter(1) != null ? Boolean.parseBoolean(this.getParameter(1).toString()) : true;
        String pattern = caseSensitive != false ? param0.toString() : param0.toString().toLowerCase();
        String strValue = caseSensitive != false ? value.toString() : value.toString().toLowerCase();
        pattern = pattern.replace(".", "\\.");
        pattern = pattern.replace("%", ".*");
        pattern = pattern.replace("_", ".");
        return strValue.matches(pattern);
    }

    public boolean isLowerThan(Comparable value) {
        if (this.isNull(value)) {
            return false;
        }
        Comparable ref = this.getParameter(0);
        return value.compareTo(ref) == -1;
    }

    public boolean isLowerThanOrEqualsTo(Comparable value) {
        if (this.isNull(value)) {
            return false;
        }
        Comparable ref = this.getParameter(0);
        return value.compareTo(ref) != 1;
    }

    public boolean isGreaterThan(Comparable value) {
        if (this.isNull(value)) {
            return false;
        }
        Comparable ref = this.getParameter(0);
        return value.compareTo(ref) == 1;
    }

    public boolean isGreaterThanOrEqualsTo(Comparable value) {
        if (this.isNull(value)) {
            return false;
        }
        Comparable ref = this.getParameter(0);
        return value.compareTo(ref) != -1;
    }

    public boolean isBetween(Comparable value) {
        if (this.isNull(value)) {
            return false;
        }
        Comparable low = this.getParameter(0);
        Comparable high = this.getParameter(1);
        if (value.compareTo(low) == -1) {
            return false;
        }
        return value.compareTo(high) != 1;
    }

    public boolean timeFrame(Comparable value) {
        if (this.isNull(value)) {
            return false;
        }
        if (!(value instanceof Date)) {
            return false;
        }
        Date target = (Date)value;
        String timeFrameExpr = this.getParameter(0).toString();
        TimeFrameLimits timeFrameLimits = this._timeFrameExprCache.get(timeFrameExpr);
        if (timeFrameLimits == null) {
            TimeFrame timeFrame = TimeFrame.parse((String)this.getParameter(0).toString());
            timeFrameLimits = new TimeFrameLimits(timeFrame);
            this._timeFrameExprCache.put(timeFrameExpr, timeFrameLimits);
        }
        if (target.before(timeFrameLimits.from)) {
            return false;
        }
        return !target.after(timeFrameLimits.to);
    }

    public class TimeFrameLimits {
        Date from = null;
        Date to = null;

        public TimeFrameLimits(TimeFrame timeFrame) {
            this.from = timeFrame.getFrom().getTimeInstant();
            this.to = timeFrame.getTo().getTimeInstant();
        }
    }
}

