/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.dashbuilder.common.client.StringUtils;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetManager;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.client.ClientDataSetCore;
import org.dashbuilder.dataset.def.DataSetPreprocessor;
import org.dashbuilder.dataset.engine.SharedDataSetOpEngine;
import org.dashbuilder.dataset.engine.index.DataSetIndex;

@ApplicationScoped
public class ClientDataSetManager
implements DataSetManager {
    SharedDataSetOpEngine dataSetOpEngine;
    Map<String, List<DataSetPreprocessor>> preprocessorMap = new HashMap<String, List<DataSetPreprocessor>>();

    public ClientDataSetManager() {
        this.dataSetOpEngine = ClientDataSetCore.get().getSharedDataSetOpEngine();
    }

    public DataSet createDataSet(String uuid) {
        DataSet dataSet = DataSetFactory.newEmptyDataSet();
        dataSet.setUUID(uuid);
        return dataSet;
    }

    public DataSet getDataSet(String uuid) {
        DataSetIndex index = this.dataSetOpEngine.getIndexRegistry().get(uuid);
        if (index == null) {
            return null;
        }
        return index.getDataSet();
    }

    public void registerDataSet(DataSet dataSet) {
        if (dataSet != null) {
            this.dataSetOpEngine.getIndexRegistry().put(dataSet);
        }
    }

    public void registerDataSet(DataSet dataSet, List<DataSetPreprocessor> preprocessors) {
        if (dataSet != null) {
            this.dataSetOpEngine.getIndexRegistry().put(dataSet);
            for (DataSetPreprocessor preprocessor : preprocessors) {
                this.registerDataSetPreprocessor(dataSet.getUUID(), preprocessor);
            }
        }
    }

    public DataSet removeDataSet(String uuid) {
        DataSetIndex index = this.dataSetOpEngine.getIndexRegistry().remove(uuid);
        if (index == null) {
            return null;
        }
        return index.getDataSet();
    }

    public DataSet lookupDataSet(DataSetLookup lookup) {
        String uuid = lookup.getDataSetUUID();
        if (StringUtils.isEmpty((String)uuid)) {
            return null;
        }
        DataSetIndex dataSetIndex = this.dataSetOpEngine.getIndexRegistry().get(uuid);
        if (dataSetIndex == null) {
            return null;
        }
        List<DataSetPreprocessor> dataSetDefPreProcessors = this.getDataSetPreprocessors(uuid);
        if (dataSetDefPreProcessors != null) {
            for (DataSetPreprocessor p : dataSetDefPreProcessors) {
                p.preprocess(lookup);
            }
        }
        DataSet dataSet = dataSetIndex.getDataSet();
        if (!lookup.getOperationList().isEmpty()) {
            dataSet = this.dataSetOpEngine.execute(uuid, lookup.getOperationList());
        }
        dataSet = dataSet.trim(lookup.getRowOffset(), lookup.getNumberOfRows());
        return dataSet;
    }

    public DataSet[] lookupDataSets(DataSetLookup[] lookup) {
        DataSet[] result = new DataSet[lookup.length];
        for (int i = 0; i < lookup.length; ++i) {
            result[i] = this.lookupDataSet(lookup[i]);
        }
        return result;
    }

    public DataSetMetadata getDataSetMetadata(String uuid) {
        DataSetLookup lookup = new DataSetLookup(uuid, new DataSetOp[0]);
        DataSet dataSet = this.lookupDataSet(lookup);
        if (dataSet == null) {
            return null;
        }
        return dataSet.getMetadata();
    }

    public void registerDataSetPreprocessor(String uuid, DataSetPreprocessor preprocessor) {
        List<DataSetPreprocessor> preprocessors = this.preprocessorMap.get(uuid);
        if (preprocessors == null) {
            preprocessors = new ArrayList<DataSetPreprocessor>();
            this.preprocessorMap.put(uuid, preprocessors);
        }
        preprocessors.add(preprocessor);
    }

    public List<DataSetPreprocessor> getDataSetPreprocessors(String uuid) {
        return this.preprocessorMap.get(uuid);
    }
}

