/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.common.client.backend.PathUrlFactory;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.client.ClientDataSetManager;
import org.dashbuilder.dataset.client.DataSetExportReadyCallback;
import org.dashbuilder.dataset.client.DataSetMetadataCallback;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.client.resources.i18n.CommonConstants;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.engine.group.IntervalBuilderLocator;
import org.dashbuilder.dataset.events.DataSetDefRemovedEvent;
import org.dashbuilder.dataset.events.DataSetModifiedEvent;
import org.dashbuilder.dataset.events.DataSetPushOkEvent;
import org.dashbuilder.dataset.events.DataSetPushingEvent;
import org.dashbuilder.dataset.events.DataSetStaleEvent;
import org.dashbuilder.dataset.group.AggregateFunctionManager;
import org.dashbuilder.dataset.service.DataSetDefServices;
import org.dashbuilder.dataset.service.DataSetExportServices;
import org.dashbuilder.dataset.service.DataSetLookupServices;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class DataSetClientServices {
    private ClientDataSetManager clientDataSetManager;
    private PathUrlFactory pathUrlFactory;
    private AggregateFunctionManager aggregateFunctionManager;
    private IntervalBuilderLocator intervalBuilderLocator;
    private Event<DataSetPushingEvent> dataSetPushingEvent;
    private Event<DataSetPushOkEvent> dataSetPushOkEvent;
    private Event<DataSetModifiedEvent> dataSetModifiedEvent;
    private Caller<DataSetLookupServices> dataSetLookupServices;
    private Caller<DataSetDefServices> dataSetDefServices;
    private Caller<DataSetExportServices> dataSetExportServices;
    private Map<String, DataSetMetadata> remoteMetadataMap = new HashMap<String, DataSetMetadata>();
    private boolean pushRemoteDataSetEnabled = true;
    private Map<String, DataSetPushHandler> pushRequestMap = new HashMap<String, DataSetPushHandler>();

    public DataSetClientServices() {
    }

    @Inject
    public DataSetClientServices(ClientDataSetManager clientDataSetManager, PathUrlFactory pathUrlFactory, AggregateFunctionManager aggregateFunctionManager, IntervalBuilderLocator intervalBuilderLocator, Event<DataSetPushingEvent> dataSetPushingEvent, Event<DataSetPushOkEvent> dataSetPushOkEvent, Event<DataSetModifiedEvent> dataSetModifiedEvent, Caller<DataSetLookupServices> dataSetLookupServices, Caller<DataSetDefServices> dataSetDefServices, Caller<DataSetExportServices> dataSetExportServices) {
        this.clientDataSetManager = clientDataSetManager;
        this.pathUrlFactory = pathUrlFactory;
        this.aggregateFunctionManager = aggregateFunctionManager;
        this.intervalBuilderLocator = intervalBuilderLocator;
        this.dataSetPushingEvent = dataSetPushingEvent;
        this.dataSetPushOkEvent = dataSetPushOkEvent;
        this.dataSetModifiedEvent = dataSetModifiedEvent;
        this.dataSetLookupServices = dataSetLookupServices;
        this.dataSetDefServices = dataSetDefServices;
        this.dataSetExportServices = dataSetExportServices;
    }

    public boolean isPushRemoteDataSetEnabled() {
        return this.pushRemoteDataSetEnabled;
    }

    public void setPushRemoteDataSetEnabled(boolean pushRemoteDataSetEnabled) {
        this.pushRemoteDataSetEnabled = pushRemoteDataSetEnabled;
    }

    public void fetchMetadata(String uuid, DataSetMetadataCallback listener) throws Exception {
        DataSetMetadata metadata = this.clientDataSetManager.getDataSetMetadata(uuid);
        if (metadata != null) {
            listener.callback(metadata);
        } else if (this.dataSetLookupServices != null) {
            if (this.remoteMetadataMap.containsKey(uuid)) {
                listener.callback(this.remoteMetadataMap.get(uuid));
            } else {
                ((DataSetLookupServices)this.dataSetLookupServices.call(result -> {
                    if (result == null) {
                        listener.notFound();
                    } else {
                        this.remoteMetadataMap.put(uuid, (DataSetMetadata)result);
                        listener.callback((DataSetMetadata)result);
                    }
                }, (message, throwable) -> listener.onError(new ClientRuntimeError(throwable)))).lookupDataSetMetadata(uuid);
            }
        } else {
            listener.notFound();
        }
    }

    Map<String, DataSetMetadata> getRemoteMetadataMap() {
        return this.remoteMetadataMap;
    }

    public DataSetMetadata getMetadata(String uuid) {
        DataSetMetadata metadata = this.clientDataSetManager.getDataSetMetadata(uuid);
        if (metadata != null) {
            return metadata;
        }
        return this.remoteMetadataMap.get(uuid);
    }

    public void exportDataSetCSV(DataSetLookup request, final DataSetExportReadyCallback listener) throws Exception {
        if (this.dataSetLookupServices != null) {
            if (this.clientDataSetManager.getDataSet(request.getDataSetUUID()) != null) {
                DataSet dataSet = this.clientDataSetManager.lookupDataSet(request);
                ((DataSetExportServices)this.dataSetExportServices.call((RemoteCallback)new RemoteCallback<Path>(){

                    public void callback(Path csvFilePath) {
                        listener.exportReady(csvFilePath);
                    }
                }, (ErrorCallback)new ErrorCallback<Message>(){

                    public boolean error(Message message, Throwable throwable) {
                        listener.onError(new ClientRuntimeError(throwable));
                        return true;
                    }
                })).exportDataSetCSV(dataSet);
            } else {
                try {
                    ((DataSetExportServices)this.dataSetExportServices.call((RemoteCallback)new RemoteCallback<Path>(){

                        public void callback(Path csvFilePath) {
                            listener.exportReady(csvFilePath);
                        }
                    }, (ErrorCallback)new ErrorCallback<Message>(){

                        public boolean error(Message message, Throwable throwable) {
                            listener.onError(new ClientRuntimeError(throwable));
                            return true;
                        }
                    })).exportDataSetCSV(request);
                }
                catch (Exception e) {
                    listener.onError(new ClientRuntimeError((Throwable)e));
                }
            }
        } else {
            listener.onError(new ClientRuntimeError(CommonConstants.INSTANCE.exc_no_client_side_data_export()));
        }
    }

    public void exportDataSetExcel(DataSetLookup request, final DataSetExportReadyCallback listener) throws Exception {
        if (this.dataSetLookupServices != null) {
            if (this.clientDataSetManager.getDataSet(request.getDataSetUUID()) != null) {
                DataSet dataSet = this.clientDataSetManager.lookupDataSet(request);
                try {
                    ((DataSetExportServices)this.dataSetExportServices.call((RemoteCallback)new RemoteCallback<Path>(){

                        public void callback(Path excelFilePath) {
                            listener.exportReady(excelFilePath);
                        }
                    })).exportDataSetExcel(dataSet);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                try {
                    ((DataSetExportServices)this.dataSetExportServices.call((RemoteCallback)new RemoteCallback<Path>(){

                        public void callback(Path excelFilePath) {
                            listener.exportReady(excelFilePath);
                        }
                    }, (ErrorCallback)new ErrorCallback<Message>(){

                        public boolean error(Message message, Throwable throwable) {
                            listener.onError(new ClientRuntimeError(throwable));
                            return true;
                        }
                    })).exportDataSetExcel(request);
                }
                catch (Exception e) {
                    listener.onError(new ClientRuntimeError((Throwable)e));
                }
            }
        } else {
            listener.onError(new ClientRuntimeError(CommonConstants.INSTANCE.exc_no_client_side_data_export()));
        }
    }

    public void newDataSet(DataSetProviderType type, RemoteCallback<DataSetDef> callback) throws Exception {
        ((DataSetDefServices)this.dataSetDefServices.call(callback)).createDataSetDef(type);
    }

    public void lookupDataSet(DataSetDef def, DataSetLookup request, final DataSetReadyCallback listener) throws Exception {
        if (this.dataSetLookupServices != null) {
            try {
                ((DataSetLookupServices)this.dataSetLookupServices.call((RemoteCallback)new RemoteCallback<DataSet>(){

                    public void callback(DataSet result) {
                        if (result == null) {
                            listener.notFound();
                        } else {
                            listener.callback(result);
                        }
                    }
                }, (ErrorCallback)new ErrorCallback<Message>(){

                    public boolean error(Message message, Throwable throwable) {
                        return listener.onError(new ClientRuntimeError(throwable));
                    }
                })).lookupDataSet(def, request);
            }
            catch (Exception e) {
                listener.onError(new ClientRuntimeError((Throwable)e));
            }
        } else {
            listener.notFound();
        }
    }

    public void lookupDataSet(final DataSetLookup request, final DataSetReadyCallback listener) throws Exception {
        if (this.clientDataSetManager.getDataSet(request.getDataSetUUID()) != null) {
            DataSet dataSet = this.clientDataSetManager.lookupDataSet(request);
            listener.callback(dataSet);
        } else if (this.dataSetLookupServices != null) {
            this.fetchMetadata(request.getDataSetUUID(), new DataSetMetadataCallback(){

                @Override
                public void callback(DataSetMetadata metatada) {
                    boolean isPushable;
                    DataSetDef dsetDef = metatada.getDefinition();
                    int estimatedSize = metatada.getEstimatedSize() / 1000;
                    boolean bl = isPushable = dsetDef != null && dsetDef.isPushEnabled() && estimatedSize < dsetDef.getPushMaxSize();
                    if (DataSetClientServices.this.pushRemoteDataSetEnabled && isPushable) {
                        DataSetPushHandler pushHandler = (DataSetPushHandler)DataSetClientServices.this.pushRequestMap.get(request.getDataSetUUID());
                        if (pushHandler == null) {
                            pushHandler = new DataSetPushHandler(metatada);
                            DataSetLookup lookupSourceDataSet = new DataSetLookup(request.getDataSetUUID(), new DataSetOp[0]);
                            DataSetClientServices.this._lookupDataSet(lookupSourceDataSet, pushHandler);
                        }
                        pushHandler.registerLookup(request, listener);
                    } else {
                        DataSetClientServices.this._lookupDataSet(request, listener);
                    }
                }

                @Override
                public void notFound() {
                    listener.notFound();
                }

                @Override
                public boolean onError(ClientRuntimeError error) {
                    return listener.onError(error);
                }
            });
        } else {
            listener.notFound();
        }
    }

    private void _lookupDataSet(DataSetLookup request, final DataSetReadyCallback listener) {
        try {
            ((DataSetLookupServices)this.dataSetLookupServices.call((RemoteCallback)new RemoteCallback<DataSet>(){

                public void callback(DataSet result) {
                    if (result == null) {
                        listener.notFound();
                    } else {
                        listener.callback(result);
                    }
                }
            }, (ErrorCallback)new ErrorCallback<Message>(){

                public boolean error(Message message, Throwable throwable) {
                    return listener.onError(new ClientRuntimeError(throwable));
                }
            })).lookupDataSet(request);
        }
        catch (Exception e) {
            listener.onError(new ClientRuntimeError((Throwable)e));
        }
    }

    public void getRemoteSharedDataSetDefs(RemoteCallback<List<DataSetDef>> callback) {
        this.getPublicDataSetDefs(callback);
    }

    public void getPublicDataSetDefs(RemoteCallback<List<DataSetDef>> callback) {
        try {
            ((DataSetDefServices)this.dataSetDefServices.call(callback)).getPublicDataSetDefs();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public AggregateFunctionManager getAggregateFunctionManager() {
        return this.aggregateFunctionManager;
    }

    public IntervalBuilderLocator getIntervalBuilderLocator() {
        return this.intervalBuilderLocator;
    }

    private void onDataSetStaleEvent(@Observes DataSetStaleEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        String uuid = event.getDataSetDef().getUUID();
        this.clientDataSetManager.removeDataSet(uuid);
        this.remoteMetadataMap.remove(uuid);
        this.dataSetModifiedEvent.fire((Object)new DataSetModifiedEvent(event.getDataSetDef()));
    }

    private void onDataSetRemovedEvent(@Observes DataSetDefRemovedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        String uuid = event.getDataSetDef().getUUID();
        this.clientDataSetManager.removeDataSet(uuid);
        this.remoteMetadataMap.remove(uuid);
        this.dataSetModifiedEvent.fire((Object)new DataSetModifiedEvent(event.getDataSetDef()));
    }

    public String getDownloadFileUrl(Path path) {
        return this.pathUrlFactory.getDownloadFileUrl(path);
    }

    public String getUploadFileUrl(String path) {
        return this.pathUrlFactory.getUploadFileUrl(path);
    }

    private class DataSetLookupListenerPair {
        DataSetLookup lookup;
        DataSetReadyCallback listener;

        private DataSetLookupListenerPair(DataSetLookup lookup, DataSetReadyCallback listener) {
            this.lookup = lookup;
            this.listener = listener;
        }
    }

    private class DataSetPushHandler
    implements DataSetReadyCallback {
        private DataSetMetadata dataSetMetadata = null;
        private List<DataSetLookupListenerPair> listenerList = new ArrayList<DataSetLookupListenerPair>();

        private DataSetPushHandler(DataSetMetadata metadata) {
            this.dataSetMetadata = metadata;
            DataSetClientServices.this.pushRequestMap.put(this.dataSetMetadata.getUUID(), this);
            DataSetClientServices.this.dataSetPushingEvent.fire((Object)new DataSetPushingEvent(this.dataSetMetadata));
        }

        public void registerLookup(DataSetLookup lookup, DataSetReadyCallback listener) {
            this.listenerList.add(new DataSetLookupListenerPair(lookup, listener));
        }

        @Override
        public void callback(DataSet dataSet) {
            DataSetClientServices.this.pushRequestMap.remove(this.dataSetMetadata.getUUID());
            DataSetClientServices.this.clientDataSetManager.registerDataSet(dataSet);
            DataSetClientServices.this.dataSetPushOkEvent.fire((Object)new DataSetPushOkEvent(this.dataSetMetadata));
            for (DataSetLookupListenerPair pair : this.listenerList) {
                DataSet result = DataSetClientServices.this.clientDataSetManager.lookupDataSet(pair.lookup);
                pair.listener.callback(result);
            }
        }

        @Override
        public void notFound() {
            DataSetClientServices.this.pushRequestMap.remove(this.dataSetMetadata.getUUID());
            for (DataSetLookupListenerPair pair : this.listenerList) {
                pair.listener.notFound();
            }
        }

        @Override
        public boolean onError(ClientRuntimeError error) {
            boolean t = false;
            for (DataSetLookupListenerPair pair : this.listenerList) {
                if (!pair.listener.onError(error)) continue;
                t = true;
            }
            return t;
        }
    }
}

