/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.client;

import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.common.client.StringUtils;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetManager;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.engine.SharedDataSetOpEngine;
import org.dashbuilder.dataset.engine.index.DataSetIndex;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.IOCBeanDef;

@ApplicationScoped
public class ClientDataSetManager
implements DataSetManager {
    @Inject
    SharedDataSetOpEngine dataSetOpEngine;

    public static ClientDataSetManager get() {
        Collection beans = IOC.getBeanManager().lookupBeans(ClientDataSetManager.class);
        IOCBeanDef beanDef = (IOCBeanDef)beans.iterator().next();
        return (ClientDataSetManager)beanDef.getInstance();
    }

    public DataSet createDataSet(String uuid) {
        DataSet dataSet = DataSetFactory.newEmptyDataSet();
        dataSet.setUUID(uuid);
        return dataSet;
    }

    public DataSet getDataSet(String uuid) {
        DataSetIndex index = this.dataSetOpEngine.getIndexRegistry().get(uuid);
        if (index == null) {
            return null;
        }
        return index.getDataSet();
    }

    public void registerDataSet(DataSet dataSet) {
        if (dataSet != null) {
            this.dataSetOpEngine.getIndexRegistry().put(dataSet);
        }
    }

    public DataSet removeDataSet(String uuid) {
        DataSetIndex index = this.dataSetOpEngine.getIndexRegistry().remove(uuid);
        if (index == null) {
            return null;
        }
        return index.getDataSet();
    }

    public DataSet lookupDataSet(DataSetLookup lookup) {
        String uuid = lookup.getDataSetUUID();
        if (StringUtils.isEmpty((String)uuid)) {
            return null;
        }
        DataSetIndex dataSetIndex = this.dataSetOpEngine.getIndexRegistry().get(uuid);
        if (dataSetIndex == null) {
            return null;
        }
        DataSet dataSet = dataSetIndex.getDataSet();
        if (!lookup.getOperationList().isEmpty()) {
            dataSet = this.dataSetOpEngine.execute(uuid, lookup.getOperationList());
        }
        dataSet = dataSet.trim(lookup.getRowOffset(), lookup.getNumberOfRows());
        return dataSet;
    }

    public DataSet[] lookupDataSets(DataSetLookup[] lookup) {
        DataSet[] result = new DataSet[lookup.length];
        for (int i = 0; i < lookup.length; ++i) {
            result[i] = this.lookupDataSet(lookup[i]);
        }
        return result;
    }

    public DataSetMetadata getDataSetMetadata(String uuid) {
        DataSetLookup lookup = new DataSetLookup(uuid, new DataSetOp[0]);
        DataSet dataSet = this.lookupDataSet(lookup);
        if (dataSet == null) {
            return null;
        }
        return dataSet.getMetadata();
    }
}

