/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.client.engine;

import com.google.gwt.i18n.client.DateTimeFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.date.Quarter;
import org.dashbuilder.dataset.engine.DataSetHandler;
import org.dashbuilder.dataset.engine.group.IntervalBuilder;
import org.dashbuilder.dataset.engine.group.IntervalList;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.dataset.sort.ColumnSort;
import org.dashbuilder.dataset.sort.DataSetSort;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.dataset.sort.SortedList;

@ApplicationScoped
public class ClientIntervalBuilderDynamicDate
implements IntervalBuilder {
    public IntervalList build(DataSetHandler handler, ColumnGroup columnGroup) {
        int i;
        IntervalDateRangeList results = new IntervalDateRangeList(columnGroup);
        DataSet dataSet = handler.getDataSet();
        List values = dataSet.getColumnById(columnGroup.getSourceId()).getValues();
        if (values.isEmpty()) {
            return results;
        }
        DataSetSort sortOp = new DataSetSort();
        sortOp.addSortColumn(new ColumnSort[]{new ColumnSort(columnGroup.getSourceId(), SortOrder.ASCENDING)});
        DataSetHandler sortResults = handler.sort(sortOp);
        List sortedRows = sortResults.getRows();
        if (sortedRows == null || sortedRows.isEmpty()) {
            return results;
        }
        SortedList sortedValues = new SortedList(values, sortedRows);
        Date minDate = null;
        Date maxDate = null;
        for (i = 0; minDate == null && i < sortedValues.size(); ++i) {
            minDate = (Date)sortedValues.get(i);
        }
        for (i = sortedValues.size() - 1; maxDate == null && i >= 0; --i) {
            maxDate = (Date)sortedValues.get(i);
        }
        DateIntervalType intervalType = this.calculateIntervalSize(minDate, maxDate, columnGroup);
        if (minDate == null || minDate.compareTo(maxDate) == 0) {
            IntervalDateRange interval = new IntervalDateRange(0, intervalType, minDate, maxDate);
            for (int row = 0; row < sortedValues.size(); ++row) {
                interval.getRows().add(row);
            }
            results.add((Object)interval);
            results.setIntervalType(columnGroup.getIntervalSize());
            results.setMinValue(minDate);
            results.setMaxValue(maxDate);
            return results;
        }
        Date intervalMinDate = this.firstIntervalDate(intervalType, minDate, columnGroup);
        int index = 0;
        int counter = 0;
        while (intervalMinDate.compareTo(maxDate) <= 0) {
            Date intervalMaxDate = this.nextIntervalDate(intervalMinDate, intervalType, 1);
            IntervalDateRange interval = new IntervalDateRange(counter++, intervalType, intervalMinDate, intervalMaxDate);
            results.add((Object)interval);
            boolean stop = false;
            while (!stop) {
                if (index >= sortedValues.size()) {
                    stop = true;
                    continue;
                }
                Date dateValue = (Date)sortedValues.get(index);
                Integer row = (Integer)sortedRows.get(index);
                if (dateValue.before(intervalMaxDate)) {
                    interval.getRows().add(row);
                    ++index;
                    continue;
                }
                stop = true;
            }
            intervalMinDate = intervalMaxDate;
        }
        boolean asc = columnGroup.isAscendingOrder();
        if (!asc) {
            Collections.reverse(results);
        }
        results.setIntervalType(intervalType.toString());
        results.setMinValue(minDate);
        results.setMaxValue(maxDate);
        return results;
    }

    public IntervalList build(DataColumn dataColumn) {
        ColumnGroup columnGroup = dataColumn.getColumnGroup();
        Date minDate = (Date)dataColumn.getMinValue();
        Date maxDate = (Date)dataColumn.getMaxValue();
        DateIntervalType intervalType = DateIntervalType.getByName((String)dataColumn.getIntervalType());
        IntervalDateRangeList results = new IntervalDateRangeList(columnGroup);
        Date intervalMinDate = this.firstIntervalDate(intervalType, minDate, columnGroup);
        int counter = 0;
        while (intervalMinDate.compareTo(maxDate) <= 0) {
            Date intervalMaxDate = this.nextIntervalDate(intervalMinDate, intervalType, 1);
            IntervalDateRange interval = new IntervalDateRange(counter++, intervalType, intervalMinDate, intervalMaxDate);
            results.add((Object)interval);
            intervalMinDate = intervalMaxDate;
        }
        boolean asc = columnGroup.isAscendingOrder();
        if (!asc) {
            Collections.reverse(results);
        }
        results.setIntervalType(intervalType.toString());
        results.setMinValue(minDate);
        results.setMaxValue(maxDate);
        return results;
    }

    public Interval locate(DataColumn column, Integer intervalIndex) {
        ColumnGroup columnGroup = column.getColumnGroup();
        Date columnMinDate = (Date)column.getMinValue();
        String type = column.getIntervalType();
        if (columnGroup == null) {
            return null;
        }
        if (columnMinDate == null) {
            return null;
        }
        if (type == null) {
            return null;
        }
        DateIntervalType intervalType = DateIntervalType.getByName((String)type);
        Date startDate = this.firstIntervalDate(intervalType, columnMinDate, columnGroup);
        Date intervalMinDate = this.nextIntervalDate(startDate, intervalType, intervalIndex);
        Date intervalMaxDate = this.nextIntervalDate(intervalMinDate, intervalType, 1);
        return new IntervalDateRange(intervalIndex, intervalType, intervalMinDate, intervalMaxDate);
    }

    public DateIntervalType calculateIntervalSize(Date minDate, Date maxDate, ColumnGroup columnGroup) {
        int maxIntervals = columnGroup.getMaxIntervals();
        if (maxIntervals < 1) {
            maxIntervals = 15;
        }
        DateIntervalType intervalType = DateIntervalType.YEAR;
        long millis = maxDate.getTime() - minDate.getTime();
        for (DateIntervalType type : DateIntervalType.values()) {
            long nintervals = millis / DateIntervalType.getDurationInMillis((DateIntervalType)type);
            if (nintervals >= (long)maxIntervals) continue;
            intervalType = type;
            break;
        }
        DateIntervalType intervalSize = null;
        String preferredSize = columnGroup.getIntervalSize();
        if (preferredSize != null && preferredSize.trim().length() > 0) {
            intervalSize = DateIntervalType.getByName((String)columnGroup.getIntervalSize());
        }
        if (intervalSize != null && DateIntervalType.compare((DateIntervalType)intervalType, intervalSize) == -1) {
            intervalType = intervalSize;
        }
        return intervalType;
    }

    protected Date firstIntervalDate(DateIntervalType intervalType, Date minDate, ColumnGroup columnGroup) {
        Date intervalMinDate = new Date(minDate.getTime());
        if (DateIntervalType.YEAR.equals((Object)intervalType)) {
            intervalMinDate.setMonth(0);
            intervalMinDate.setDate(1);
            intervalMinDate.setHours(0);
            intervalMinDate.setMinutes(0);
            intervalMinDate.setSeconds(0);
        }
        if (DateIntervalType.QUARTER.equals((Object)intervalType)) {
            int currentMonth = intervalMinDate.getMonth();
            int firstMonthYear = columnGroup.getFirstMonthOfYear().getIndex();
            int rest = Quarter.getPositionInQuarter((int)firstMonthYear, (int)(currentMonth + 1));
            intervalMinDate.setMonth(currentMonth - rest);
            intervalMinDate.setDate(1);
            intervalMinDate.setHours(0);
            intervalMinDate.setMinutes(0);
            intervalMinDate.setSeconds(0);
        }
        if (DateIntervalType.MONTH.equals((Object)intervalType)) {
            intervalMinDate.setDate(1);
            intervalMinDate.setHours(0);
            intervalMinDate.setMinutes(0);
            intervalMinDate.setSeconds(0);
        }
        if (DateIntervalType.DAY.equals((Object)intervalType) || DateIntervalType.DAY_OF_WEEK.equals((Object)intervalType) || DateIntervalType.WEEK.equals((Object)intervalType)) {
            intervalMinDate.setHours(0);
            intervalMinDate.setMinutes(0);
            intervalMinDate.setSeconds(0);
        }
        if (DateIntervalType.HOUR.equals((Object)intervalType)) {
            intervalMinDate.setMinutes(0);
            intervalMinDate.setSeconds(0);
        }
        if (DateIntervalType.MINUTE.equals((Object)intervalType)) {
            intervalMinDate.setSeconds(0);
        }
        return intervalMinDate;
    }

    protected Date nextIntervalDate(Date intervalMinDate, DateIntervalType intervalType, int intervals) {
        Date intervalMaxDate = new Date(intervalMinDate.getTime());
        if (DateIntervalType.MILLENIUM.equals((Object)intervalType)) {
            intervalMaxDate.setYear(intervalMinDate.getYear() + 1000 * intervals);
        }
        if (DateIntervalType.CENTURY.equals((Object)intervalType)) {
            intervalMaxDate.setYear(intervalMinDate.getYear() + 100 * intervals);
        }
        if (DateIntervalType.DECADE.equals((Object)intervalType)) {
            intervalMaxDate.setYear(intervalMinDate.getYear() + 10 * intervals);
        }
        if (DateIntervalType.YEAR.equals((Object)intervalType)) {
            intervalMaxDate.setYear(intervalMinDate.getYear() + intervals);
        }
        if (DateIntervalType.QUARTER.equals((Object)intervalType)) {
            intervalMaxDate.setMonth(intervalMinDate.getMonth() + 3 * intervals);
        }
        if (DateIntervalType.MONTH.equals((Object)intervalType)) {
            intervalMaxDate.setMonth(intervalMinDate.getMonth() + intervals);
        }
        if (DateIntervalType.WEEK.equals((Object)intervalType)) {
            intervalMaxDate.setDate(intervalMinDate.getDate() + 7 * intervals);
        }
        if (DateIntervalType.DAY.equals((Object)intervalType) || DateIntervalType.DAY_OF_WEEK.equals((Object)intervalType)) {
            intervalMaxDate.setDate(intervalMinDate.getDate() + intervals);
        }
        if (DateIntervalType.HOUR.equals((Object)intervalType)) {
            intervalMaxDate.setHours(intervalMinDate.getHours() + intervals);
        }
        if (DateIntervalType.MINUTE.equals((Object)intervalType)) {
            intervalMaxDate.setMinutes(intervalMinDate.getMinutes() + intervals);
        }
        if (DateIntervalType.SECOND.equals((Object)intervalType)) {
            intervalMaxDate.setSeconds(intervalMinDate.getSeconds() + intervals);
        }
        return intervalMaxDate;
    }

    public static String calculateName(DateIntervalType intervalType, Date d) {
        if (DateIntervalType.MILLENIUM.equals((Object)intervalType) || DateIntervalType.CENTURY.equals((Object)intervalType) || DateIntervalType.DECADE.equals((Object)intervalType) || DateIntervalType.YEAR.equals((Object)intervalType)) {
            DateTimeFormat format = DateTimeFormat.getFormat((String)"yyyy");
            return format.format(d);
        }
        if (DateIntervalType.QUARTER.equals((Object)intervalType) || DateIntervalType.MONTH.equals((Object)intervalType)) {
            DateTimeFormat format = DateTimeFormat.getFormat((String)"yyyy-MM");
            return format.format(d);
        }
        if (DateIntervalType.WEEK.equals((Object)intervalType) || DateIntervalType.DAY.equals((Object)intervalType) || DateIntervalType.DAY_OF_WEEK.equals((Object)intervalType)) {
            DateTimeFormat format = DateTimeFormat.getFormat((String)"yyyy-MM-dd");
            return format.format(d);
        }
        if (DateIntervalType.HOUR.equals((Object)intervalType)) {
            DateTimeFormat format = DateTimeFormat.getFormat((String)"yyyy-MM-dd HH");
            return format.format(d);
        }
        if (DateIntervalType.MINUTE.equals((Object)intervalType)) {
            DateTimeFormat format = DateTimeFormat.getFormat((String)"yyyy-MM-dd HH:mm");
            return format.format(d);
        }
        if (DateIntervalType.SECOND.equals((Object)intervalType)) {
            DateTimeFormat format = DateTimeFormat.getFormat((String)"yyyy-MM-dd HH:mm:ss");
            return format.format(d);
        }
        return null;
    }

    public class IntervalDateRange
    extends Interval {
        public IntervalDateRange(int index, DateIntervalType intervalType, Date minDate, Date maxDate) {
            super(ClientIntervalBuilderDynamicDate.calculateName(intervalType, minDate));
            super.setMinValue((Object)minDate);
            super.setMaxValue((Object)maxDate);
            super.setIndex(index);
            super.setType(intervalType.toString());
        }

        public Date getMinDate() {
            return (Date)this.minValue;
        }

        public Date getMaxDate() {
            return (Date)this.maxValue;
        }
    }

    public class IntervalDateRangeList
    extends IntervalList {
        public IntervalDateRangeList(ColumnGroup columnGroup) {
            super(columnGroup);
        }

        public Interval locateInterval(Object value) {
            Date d = (Date)value;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                Interval interval = (Interval)i$.next();
                IntervalDateRange dateRange = (IntervalDateRange)interval;
                if (!d.equals(dateRange.getMinDate()) && (!d.after(dateRange.getMinDate()) || !d.before(dateRange.getMaxDate()))) continue;
                return interval;
            }
            return null;
        }
    }
}

