/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetBackendServices;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.backend.EditDataSetDef;
import org.dashbuilder.dataset.client.ClientDataSetManager;
import org.dashbuilder.dataset.client.DataSetClientServiceError;
import org.dashbuilder.dataset.client.DataSetDefPersistCallback;
import org.dashbuilder.dataset.client.DataSetDefRegisterCallback;
import org.dashbuilder.dataset.client.DataSetDefRemoveCallback;
import org.dashbuilder.dataset.client.DataSetEditCallback;
import org.dashbuilder.dataset.client.DataSetExportReadyCallback;
import org.dashbuilder.dataset.client.DataSetMetadataCallback;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.client.resources.i18n.CommonConstants;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.engine.group.IntervalBuilderLocator;
import org.dashbuilder.dataset.events.DataSetDefRemovedEvent;
import org.dashbuilder.dataset.events.DataSetModifiedEvent;
import org.dashbuilder.dataset.events.DataSetPushOkEvent;
import org.dashbuilder.dataset.events.DataSetPushingEvent;
import org.dashbuilder.dataset.events.DataSetStaleEvent;
import org.dashbuilder.dataset.group.AggregateFunctionManager;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.uberfire.commons.validation.PortablePreconditions;

@ApplicationScoped
public class DataSetClientServices {
    private static final String UPLOAD_SERVLET_URL = "upload";
    private static final String EXPORT_SERVLER_URL = "dataset/export";
    private static final String TEMP_PATH = "/tmp/";
    @Inject
    private ClientDataSetManager clientDataSetManager;
    @Inject
    private AggregateFunctionManager aggregateFunctionManager;
    @Inject
    private IntervalBuilderLocator intervalBuilderLocator;
    @Inject
    private Event<DataSetPushingEvent> dataSetPushingEvent;
    @Inject
    private Event<DataSetPushOkEvent> dataSetPushOkEvent;
    @Inject
    private Event<DataSetModifiedEvent> dataSetModifiedEvent;
    @Inject
    private Caller<DataSetBackendServices> dataSetBackendServices;
    private Map<String, DataSetMetadata> remoteMetadataMap = new HashMap<String, DataSetMetadata>();
    private boolean pushRemoteDataSetEnabled = true;
    private Map<String, DataSetPushHandler> pushRequestMap = new HashMap<String, DataSetPushHandler>();

    public static DataSetClientServices get() {
        Collection beans = IOC.getBeanManager().lookupBeans(DataSetClientServices.class);
        IOCBeanDef beanDef = (IOCBeanDef)beans.iterator().next();
        return (DataSetClientServices)beanDef.getInstance();
    }

    public boolean isPushRemoteDataSetEnabled() {
        return this.pushRemoteDataSetEnabled;
    }

    public void setPushRemoteDataSetEnabled(boolean pushRemoteDataSetEnabled) {
        this.pushRemoteDataSetEnabled = pushRemoteDataSetEnabled;
    }

    public void fetchMetadata(final String uuid, final DataSetMetadataCallback listener) throws Exception {
        DataSetMetadata metadata = this.clientDataSetManager.getDataSetMetadata(uuid);
        if (metadata != null) {
            listener.callback(metadata);
        } else if (this.dataSetBackendServices != null) {
            if (this.remoteMetadataMap.containsKey(uuid)) {
                listener.callback(this.remoteMetadataMap.get(uuid));
            } else {
                ((DataSetBackendServices)this.dataSetBackendServices.call((RemoteCallback)new RemoteCallback<DataSetMetadata>(){

                    public void callback(DataSetMetadata result) {
                        if (result == null) {
                            listener.notFound();
                        } else {
                            DataSetClientServices.this.remoteMetadataMap.put(uuid, result);
                            listener.callback(result);
                        }
                    }
                }, (ErrorCallback)new ErrorCallback<Message>(){

                    public boolean error(Message message, Throwable throwable) {
                        listener.onError(new DataSetClientServiceError(message, throwable));
                        return true;
                    }
                })).lookupDataSetMetadata(uuid);
            }
        } else {
            listener.notFound();
        }
    }

    public void prepareEdit(String uuid, final DataSetEditCallback listener) throws Exception {
        if (this.dataSetBackendServices != null) {
            ((DataSetBackendServices)this.dataSetBackendServices.call((RemoteCallback)new RemoteCallback<EditDataSetDef>(){

                public void callback(EditDataSetDef result) {
                    if (result == null) {
                        listener.notFound();
                    } else {
                        listener.callback(result);
                    }
                }
            }, (ErrorCallback)new ErrorCallback<Message>(){

                public boolean error(Message message, Throwable throwable) {
                    listener.onError(new DataSetClientServiceError(message, throwable));
                    return true;
                }
            })).prepareEdit(uuid);
        } else {
            listener.notFound();
        }
    }

    public DataSetMetadata getMetadata(String uuid) {
        DataSetMetadata metadata = this.clientDataSetManager.getDataSetMetadata(uuid);
        if (metadata != null) {
            return metadata;
        }
        return this.remoteMetadataMap.get(uuid);
    }

    public void exportDataSetCSV(DataSetLookup request, final DataSetExportReadyCallback listener) throws Exception {
        if (this.dataSetBackendServices != null) {
            if (this.clientDataSetManager.getDataSet(request.getDataSetUUID()) != null) {
                DataSet dataSet = this.clientDataSetManager.lookupDataSet(request);
                try {
                    ((DataSetBackendServices)this.dataSetBackendServices.call((RemoteCallback)new RemoteCallback<String>(){

                        public void callback(String csvFilePath) {
                            listener.exportReady(csvFilePath);
                        }
                    })).exportDataSetCSV(dataSet);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                try {
                    ((DataSetBackendServices)this.dataSetBackendServices.call((RemoteCallback)new RemoteCallback<String>(){

                        public void callback(String csvFilePath) {
                            listener.exportReady(csvFilePath);
                        }
                    })).exportDataSetCSV(request);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            throw new RuntimeException(CommonConstants.INSTANCE.exc_no_client_side_data_export());
        }
    }

    public void exportDataSetExcel(DataSetLookup request, final DataSetExportReadyCallback listener) throws Exception {
        if (this.dataSetBackendServices != null) {
            if (this.clientDataSetManager.getDataSet(request.getDataSetUUID()) != null) {
                DataSet dataSet = this.clientDataSetManager.lookupDataSet(request);
                try {
                    ((DataSetBackendServices)this.dataSetBackendServices.call((RemoteCallback)new RemoteCallback<String>(){

                        public void callback(String excelFilePath) {
                            listener.exportReady(excelFilePath);
                        }
                    })).exportDataSetExcel(dataSet);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                try {
                    ((DataSetBackendServices)this.dataSetBackendServices.call((RemoteCallback)new RemoteCallback<String>(){

                        public void callback(String excelFilePath) {
                            listener.exportReady(excelFilePath);
                        }
                    })).exportDataSetExcel(request);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            throw new RuntimeException(CommonConstants.INSTANCE.exc_no_client_side_data_export());
        }
    }

    public void lookupDataSet(DataSetDef def, DataSetLookup request, final DataSetReadyCallback listener) throws Exception {
        if (this.dataSetBackendServices != null) {
            try {
                ((DataSetBackendServices)this.dataSetBackendServices.call((RemoteCallback)new RemoteCallback<DataSet>(){

                    public void callback(DataSet result) {
                        if (result == null) {
                            listener.notFound();
                        } else {
                            listener.callback(result);
                        }
                    }
                }, (ErrorCallback)new ErrorCallback<Message>(){

                    public boolean error(Message message, Throwable throwable) {
                        return listener.onError(new DataSetClientServiceError(message, throwable));
                    }
                })).lookupDataSet(def, request);
            }
            catch (Exception e) {
                listener.onError(new DataSetClientServiceError(null, e));
            }
        } else {
            listener.notFound();
        }
    }

    public void lookupDataSet(final DataSetLookup request, final DataSetReadyCallback listener) throws Exception {
        if (this.clientDataSetManager.getDataSet(request.getDataSetUUID()) != null) {
            DataSet dataSet = this.clientDataSetManager.lookupDataSet(request);
            listener.callback(dataSet);
        } else if (this.dataSetBackendServices != null) {
            this.fetchMetadata(request.getDataSetUUID(), new DataSetMetadataCallback(){

                @Override
                public void callback(DataSetMetadata metatada) {
                    boolean isPushable;
                    DataSetDef dsetDef = metatada.getDefinition();
                    boolean bl = isPushable = dsetDef != null && dsetDef.isPushEnabled() && metatada.getEstimatedSize() < dsetDef.getPushMaxSize();
                    if (DataSetClientServices.this.pushRemoteDataSetEnabled && isPushable) {
                        DataSetPushHandler pushHandler = (DataSetPushHandler)DataSetClientServices.this.pushRequestMap.get(request.getDataSetUUID());
                        if (pushHandler == null) {
                            pushHandler = new DataSetPushHandler(metatada);
                            DataSetLookup lookupSourceDataSet = new DataSetLookup(request.getDataSetUUID(), new DataSetOp[0]);
                            DataSetClientServices.this._lookupDataSet(lookupSourceDataSet, pushHandler);
                        }
                        pushHandler.registerLookup(request, listener);
                    } else {
                        DataSetClientServices.this._lookupDataSet(request, listener);
                    }
                }

                @Override
                public void notFound() {
                    listener.notFound();
                }

                @Override
                public boolean onError(DataSetClientServiceError error) {
                    return listener.onError(error);
                }
            });
        } else {
            listener.notFound();
        }
    }

    private void _lookupDataSet(DataSetLookup request, final DataSetReadyCallback listener) {
        try {
            ((DataSetBackendServices)this.dataSetBackendServices.call((RemoteCallback)new RemoteCallback<DataSet>(){

                public void callback(DataSet result) {
                    if (result == null) {
                        listener.notFound();
                    } else {
                        listener.callback(result);
                    }
                }
            }, (ErrorCallback)new ErrorCallback<Message>(){

                public boolean error(Message message, Throwable throwable) {
                    return listener.onError(new DataSetClientServiceError(message, throwable));
                }
            })).lookupDataSet(request);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void getRemoteSharedDataSetDefs(RemoteCallback<List<DataSetDef>> callback) {
        try {
            ((DataSetBackendServices)this.dataSetBackendServices.call(callback)).getPublicDataSetDefs();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public AggregateFunctionManager getAggregateFunctionManager() {
        return this.aggregateFunctionManager;
    }

    public IntervalBuilderLocator getIntervalBuilderLocator() {
        return this.intervalBuilderLocator;
    }

    public void registerDataSetDef(DataSetDef dataSetDef, final DataSetDefRegisterCallback registerCallback) {
        ((DataSetBackendServices)this.dataSetBackendServices.call((RemoteCallback)new RemoteCallback<String>(){

            public void callback(String o) {
                registerCallback.success(o);
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message o, Throwable throwable) {
                return registerCallback.onError(new DataSetClientServiceError(o, throwable));
            }
        })).registerDataSetDef(dataSetDef);
    }

    public void updateDataSetDef(String originalUUID, DataSetDef dataSetDef, final DataSetDefRegisterCallback registerCallback) {
        ((DataSetBackendServices)this.dataSetBackendServices.call((RemoteCallback)new RemoteCallback<String>(){

            public void callback(String o) {
                registerCallback.success(o);
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message o, Throwable throwable) {
                return registerCallback.onError(new DataSetClientServiceError(o, throwable));
            }
        })).updateDataSetDef(originalUUID, dataSetDef);
    }

    public void persistDataSetDef(DataSetDef dataSetDef, final DataSetDefPersistCallback persistCallback) throws Exception {
        ((DataSetBackendServices)this.dataSetBackendServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void o) {
                persistCallback.success();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                return persistCallback.onError(new DataSetClientServiceError(message, throwable));
            }
        })).persistDataSetDef(dataSetDef);
    }

    public void removeDataSetDef(String uuid, final DataSetDefRemoveCallback removeCallback) {
        if (uuid != null) {
            ((DataSetBackendServices)this.dataSetBackendServices.call((RemoteCallback)new RemoteCallback<Void>(){

                public void callback(Void aVoid) {
                    removeCallback.success();
                }
            }, (ErrorCallback)new ErrorCallback<Message>(){

                public boolean error(Message message, Throwable throwable) {
                    return removeCallback.onError(new DataSetClientServiceError(message, throwable));
                }
            })).removeDataSetDef(uuid);
            this.removeDataSet(uuid);
        }
    }

    public void deleteDataSetDef(String uuid, final DataSetDefRemoveCallback removeCallback) {
        if (uuid != null) {
            ((DataSetBackendServices)this.dataSetBackendServices.call((RemoteCallback)new RemoteCallback<Void>(){

                public void callback(Void aVoid) {
                    removeCallback.success();
                }
            }, (ErrorCallback)new ErrorCallback<Message>(){

                public boolean error(Message message, Throwable throwable) {
                    return removeCallback.onError(new DataSetClientServiceError(message, throwable));
                }
            })).deleteDataSetDef(uuid);
            this.removeDataSet(uuid);
        }
    }

    public void removeDataSet(String uuid) {
        if (uuid != null) {
            this.clientDataSetManager.removeDataSet(uuid);
        }
    }

    private void onDataSetStaleEvent(@Observes DataSetStaleEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        String uuid = event.getDataSetDef().getUUID();
        this.clientDataSetManager.removeDataSet(uuid);
        this.remoteMetadataMap.remove(uuid);
        this.dataSetModifiedEvent.fire((Object)new DataSetModifiedEvent(event.getDataSetDef()));
    }

    private void onDataSetRemovedEvent(@Observes DataSetDefRemovedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        String uuid = event.getDataSetDef().getUUID();
        this.clientDataSetManager.removeDataSet(uuid);
        this.remoteMetadataMap.remove(uuid);
        this.dataSetModifiedEvent.fire((Object)new DataSetModifiedEvent(event.getDataSetDef()));
    }

    public String getUploadServletUrl() {
        return GWT.getModuleBaseURL() + UPLOAD_SERVLET_URL;
    }

    public String getExportServletUrl() {
        return GWT.getModuleBaseURL() + EXPORT_SERVLER_URL;
    }

    public String getDownloadFileUrl(String servletUrl, String path) {
        StringBuilder sb = new StringBuilder(servletUrl);
        sb.append("?").append("path").append("=").append("file://").append(URL.encode((String)path));
        return sb.toString();
    }

    public String getUploadFileUrl(String filename) {
        StringBuilder sb = new StringBuilder(this.getUploadServletUrl());
        sb.append("?").append("path").append("=file://").append(URL.encode((String)(TEMP_PATH + filename)));
        return sb.toString();
    }

    public String getTempFilePath(String filename) {
        return URL.encode((String)(TEMP_PATH + filename));
    }

    private class DataSetLookupListenerPair {
        DataSetLookup lookup;
        DataSetReadyCallback listener;

        private DataSetLookupListenerPair(DataSetLookup lookup, DataSetReadyCallback listener) {
            this.lookup = lookup;
            this.listener = listener;
        }
    }

    private class DataSetPushHandler
    implements DataSetReadyCallback {
        private DataSetMetadata dataSetMetadata = null;
        private List<DataSetLookupListenerPair> listenerList = new ArrayList<DataSetLookupListenerPair>();

        private DataSetPushHandler(DataSetMetadata metadata) {
            this.dataSetMetadata = metadata;
            DataSetClientServices.this.pushRequestMap.put(this.dataSetMetadata.getUUID(), this);
            DataSetClientServices.this.dataSetPushingEvent.fire((Object)new DataSetPushingEvent(this.dataSetMetadata));
        }

        public void registerLookup(DataSetLookup lookup, DataSetReadyCallback listener) {
            this.listenerList.add(new DataSetLookupListenerPair(lookup, listener));
        }

        @Override
        public void callback(DataSet dataSet) {
            DataSetClientServices.this.pushRequestMap.remove(this.dataSetMetadata.getUUID());
            DataSetClientServices.this.clientDataSetManager.registerDataSet(dataSet);
            DataSetClientServices.this.dataSetPushOkEvent.fire((Object)new DataSetPushOkEvent(this.dataSetMetadata));
            for (DataSetLookupListenerPair pair : this.listenerList) {
                DataSet result = DataSetClientServices.this.clientDataSetManager.lookupDataSet(pair.lookup);
                pair.listener.callback(result);
            }
        }

        @Override
        public void notFound() {
            DataSetClientServices.this.pushRequestMap.remove(this.dataSetMetadata.getUUID());
            for (DataSetLookupListenerPair pair : this.listenerList) {
                pair.listener.notFound();
            }
        }

        @Override
        public boolean onError(DataSetClientServiceError error) {
            boolean t = false;
            for (DataSetLookupListenerPair pair : this.listenerList) {
                if (!pair.listener.onError(error)) continue;
                t = true;
            }
            return t;
        }
    }
}

