/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.DataSetCore;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataprovider.SQLDataSourceLocatorCDI;
import org.dashbuilder.dataprovider.StaticDataSetProvider;
import org.dashbuilder.dataprovider.StaticDataSetProviderCDI;
import org.dashbuilder.dataprovider.sql.SQLDataSetProvider;
import org.dashbuilder.dataprovider.sql.SQLDataSourceLocator;
import org.dashbuilder.dataset.DataSetOpEngine;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.events.DataSetDefModifiedEvent;
import org.dashbuilder.dataset.events.DataSetDefRemovedEvent;
import org.dashbuilder.dataset.events.DataSetStaleEvent;

@ApplicationScoped
public class SQLDataSetProviderCDI
extends SQLDataSetProvider {
    public SQLDataSetProviderCDI() {
    }

    @Inject
    public SQLDataSetProviderCDI(StaticDataSetProviderCDI staticDataSetProvider, SQLDataSourceLocatorCDI sqlDataSourceLocator) {
        super((StaticDataSetProvider)staticDataSetProvider, (SQLDataSourceLocator)sqlDataSourceLocator, DataSetCore.get().getIntervalBuilderLocator(), DataSetCore.get().getIntervalBuilderDynamicDate(), (DataSetOpEngine)DataSetCore.get().getSharedDataSetOpEngine());
    }

    protected void onDataSetStaleEvent(@Observes DataSetStaleEvent event) {
        DataSetDef def = event.getDataSetDef();
        if (DataSetProviderType.SQL.equals((Object)def.getProvider())) {
            String uuid = def.getUUID();
            this.staticDataSetProvider.removeDataSet(uuid);
        }
    }

    protected void onDataSetDefRemovedEvent(@Observes DataSetDefRemovedEvent event) {
        DataSetDef def = event.getDataSetDef();
        if (DataSetProviderType.SQL.equals((Object)def.getProvider())) {
            String uuid = def.getUUID();
            this._metadataMap.remove(uuid);
            this.staticDataSetProvider.removeDataSet(uuid);
        }
    }

    protected void onDataSetDefModifiedEvent(@Observes DataSetDefModifiedEvent event) {
        DataSetDef def = event.getOldDataSetDef();
        if (DataSetProviderType.SQL.equals((Object)def.getProvider())) {
            String uuid = def.getUUID();
            this._metadataMap.remove(uuid);
            this.staticDataSetProvider.removeDataSet(uuid);
        }
    }
}

