/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset;

import java.io.File;
import java.net.URL;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.dashbuilder.config.Config;
import org.dashbuilder.dataset.DataSetDefDeployer;
import org.dashbuilder.dataset.DataSetDefRegistryCDI;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.uberfire.commons.services.cdi.Startup;

@Startup
@ApplicationScoped
public class DataSetDefDeployerCDI
extends DataSetDefDeployer {
    public DataSetDefDeployerCDI() {
    }

    @Inject
    public DataSetDefDeployerCDI(@Config(value="") String directory, @Config(value="3000") int scanIntervalInMillis, DataSetDefRegistryCDI dataSetDefRegistry) {
        super((DataSetDefRegistry)dataSetDefRegistry);
        super.setScanIntervalInMillis(scanIntervalInMillis);
    }

    @PostConstruct
    public void init() {
        if (!StringUtils.isBlank((CharSequence)this.directory)) {
            this.deploy(this.directory);
        } else {
            File webInf = this.getWebInfDir();
            if (webInf != null) {
                File datasets = new File(webInf, "datasets");
                this.deploy(datasets.getPath());
            }
        }
    }

    public File getWebInfDir() {
        String[] paths;
        for (String path : paths = new String[]{"app.html.template", "security-management.properties"}) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL pathURL = classLoader.getResource(path);
            if (pathURL == null) {
                pathURL = classLoader.getResource("WEB-INF/classes/" + path);
            }
            if (pathURL == null) continue;
            return new File(pathURL.getPath()).getParentFile().getParentFile();
        }
        return null;
    }

    @PreDestroy
    public synchronized void stop() {
        super.stop();
    }
}

