/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetConstraints;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetLookupBuilder;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.ValidationError;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;

public class DataSetLookupConstraints
extends DataSetConstraints<DataSetLookupConstraints> {
    public static final int ERROR_GROUP_NUMBER = 200;
    public static final int ERROR_GROUP_NOT_ALLOWED = 201;
    public static final int ERROR_GROUP_REQUIRED = 203;
    public static final int ERROR_DUPLICATED_COLUMN_ID = 204;
    protected boolean uniqueColumnIds = false;
    protected boolean groupAllowed = true;
    protected boolean groupRequired = false;
    protected int maxGroups = -1;
    protected String groupsTitle = "Rows";
    protected String columnsTitle = "Columns";
    protected boolean groupColumn = false;
    protected boolean functionRequired = false;
    protected Map<Integer, String> columnTitleMap = new HashMap<Integer, String>();

    public boolean isUniqueColumnIds() {
        return this.uniqueColumnIds;
    }

    public DataSetLookupConstraints setUniqueColumnIds(boolean uniqueColumnIds) {
        this.uniqueColumnIds = uniqueColumnIds;
        return this;
    }

    public boolean isGroupAllowed() {
        return this.groupAllowed;
    }

    public DataSetLookupConstraints setGroupAllowed(boolean groupAllowed) {
        this.groupAllowed = groupAllowed;
        return this;
    }

    public boolean isGroupRequired() {
        return this.groupRequired;
    }

    public DataSetLookupConstraints setGroupRequired(boolean groupRequired) {
        this.groupRequired = groupRequired;
        return this;
    }

    public int getMaxGroups() {
        return this.maxGroups;
    }

    public DataSetLookupConstraints setMaxGroups(int maxGroups) {
        this.maxGroups = maxGroups;
        return this;
    }

    public String getGroupsTitle() {
        return this.groupsTitle;
    }

    public DataSetLookupConstraints setGroupsTitle(String groupsTitle) {
        this.groupsTitle = groupsTitle;
        return this;
    }

    public String getColumnsTitle() {
        return this.columnsTitle;
    }

    public DataSetLookupConstraints setColumnsTitle(String columnsTitle) {
        this.columnsTitle = columnsTitle;
        return this;
    }

    public DataSetLookupConstraints setColumnTitle(Integer index, String title) {
        this.columnTitleMap.put(index, title);
        return this;
    }

    public String getColumnTitle(Integer index) {
        return this.columnTitleMap.get(index);
    }

    public boolean isGroupColumn() {
        return this.groupColumn;
    }

    public DataSetLookupConstraints setGroupColumn(boolean groupColumn) {
        this.groupColumn = groupColumn;
        return this;
    }

    public boolean isFunctionRequired() {
        return this.functionRequired;
    }

    public DataSetLookupConstraints setFunctionRequired(boolean functionRequired) {
        this.functionRequired = functionRequired;
        return this;
    }

    public ValidationError check(DataSetLookup lookup) {
        return this.check(lookup, null);
    }

    public ValidationError check(DataSetLookup lookup, DataSetMetadata metadata) {
        DataSetGroup groupOp;
        List<DataSetGroup> grOps = lookup.getOperationList(DataSetGroup.class);
        int lastGop = lookup.getLastGroupOpIndex(0);
        if (!this.groupAllowed && lastGop != -1 && (groupOp = (DataSetGroup)lookup.getOperation(lastGop)).getColumnGroup() != null) {
            return this.createValidationError(201, new Object[0]);
        }
        if (this.groupRequired && lastGop == -1) {
            return this.createValidationError(203, new Object[0]);
        }
        if (this.maxGroups != -1 && grOps.size() > this.maxGroups) {
            return this.createValidationError(200, new Object[0]);
        }
        if (lastGop != -1) {
            groupOp = (DataSetGroup)lookup.getOperation(lastGop);
            if (this.groupRequired && groupOp.getColumnGroup() == null) {
                return this.createValidationError(203, new Object[0]);
            }
            List<GroupFunction> groupFunctions = groupOp.getGroupFunctions();
            if (this.minColumns != -1 && groupFunctions.size() < this.minColumns) {
                return this.createValidationError(101, new Object[0]);
            }
            if (this.maxColumns != -1 && groupFunctions.size() > this.maxColumns) {
                return this.createValidationError(101, new Object[0]);
            }
            if (this.uniqueColumnIds) {
                HashSet<String> columnIds = new HashSet<String>();
                for (GroupFunction groupFunction : groupFunctions) {
                    String columnId = groupFunction.getColumnId();
                    if (columnId == null) continue;
                    if (columnIds.contains(columnId)) {
                        return this.createValidationError(204, columnId);
                    }
                    columnIds.add(columnId);
                }
            }
            if (metadata != null) {
                int currentColumns = -1;
                boolean ok = false;
                ValidationError error = null;
                for (ColumnType[] types : this.columnTypeList) {
                    if (currentColumns < 0 || currentColumns < types.length) {
                        currentColumns = types.length;
                    }
                    error = this.checkTypes(metadata, groupOp, types);
                    if (ok || error != null) continue;
                    ok = true;
                }
                if (!ok) {
                    return error;
                }
                if (currentColumns > 0 && this.extraColumnsAllowed && this.extraColumnsType != null && groupFunctions.size() > currentColumns) {
                    for (int i = currentColumns; i < groupFunctions.size(); ++i) {
                        GroupFunction gf = groupFunctions.get(i);
                        ColumnType columnType = metadata.getColumnType(gf.getSourceId());
                        if (columnType.equals((Object)this.extraColumnsType)) continue;
                        return this.createValidationError(100, new Object[]{i, this.extraColumnsType, columnType});
                    }
                }
                return null;
            }
        }
        return null;
    }

    private ValidationError checkTypes(DataSetMetadata metadata, DataSetGroup groupOp, ColumnType[] types) {
        ColumnGroup columnGroup = groupOp.getColumnGroup();
        List<GroupFunction> groupFunctions = groupOp.getGroupFunctions();
        for (int i = 0; i < groupFunctions.size(); ++i) {
            boolean isFunctionColumn;
            GroupFunction gf = groupFunctions.get(i);
            ColumnType columnType = metadata.getColumnType(gf.getSourceId());
            if (i >= types.length || columnType.equals((Object)types[i])) continue;
            boolean isGroupColumn = columnGroup != null && columnGroup.getSourceId().equals(gf.getSourceId());
            boolean isGroupLabel = isGroupColumn && types[i].equals((Object)ColumnType.LABEL);
            boolean bl = isFunctionColumn = gf.getFunction() != null && !columnType.equals((Object)ColumnType.NUMBER);
            if (isGroupLabel || isFunctionColumn) continue;
            return this.createValidationError(100, new Object[]{i, types[i], columnType});
        }
        return null;
    }

    @Override
    protected ValidationError createValidationError(int error, Object ... params) {
        switch (error) {
            case 201: {
                return new ValidationError(error, "Group not allowed");
            }
            case 203: {
                String groupColumn = this.groupsTitle != null ? this.groupsTitle : "Group";
                return new ValidationError(error, groupColumn + " column required");
            }
            case 200: {
                return new ValidationError(error, "Max. groups allowed exceeded " + this.maxGroups);
            }
            case 204: {
                String columnId = (String)params[0];
                return new ValidationError(error, "Column id '" + columnId + "' is duplicated");
            }
        }
        return super.createValidationError(error, params);
    }

    public DataSetLookup newDataSetLookup(DataSetMetadata metatada) {
        int i;
        ColumnType[] types;
        DataSetLookupBuilder<DataSetLookupBuilderImpl> builder = DataSetFactory.newDataSetLookupBuilder();
        builder.dataset(metatada.getUUID());
        HashSet<Integer> exclude = new HashSet<Integer>();
        int startIndex = 0;
        if (this.groupRequired) {
            int groupIdx = this.getGroupColumn(metatada);
            if (groupIdx == -1) {
                throw new IllegalStateException("The data set does not contains group-able columns (label or date)");
            }
            exclude.add(groupIdx);
            builder.group(metatada.getColumnId(groupIdx));
            builder.column(metatada.getColumnId(groupIdx));
            startIndex = 1;
        }
        if ((types = this.getColumnTypes()) == null || types.length == 0) {
            types = this.maxColumns > 0 && this.maxColumns < metatada.getNumberOfColumns() ? new ColumnType[this.maxColumns] : new ColumnType[metatada.getNumberOfColumns()];
            for (i = 0; i < types.length; ++i) {
                types[i] = metatada.getColumnType(i);
            }
        }
        for (i = startIndex; i < types.length; ++i) {
            ColumnType targetType = types[i];
            int idx = this.getTargetColumn(metatada, targetType, exclude);
            if (idx == -1) {
                idx = this.getTargetColumn(metatada, exclude);
            }
            String columnId = metatada.getColumnId(idx);
            ColumnType columnType = metatada.getColumnType(idx);
            exclude.add(idx);
            DataSetLookup currentLookup = builder.buildLookup();
            String uniqueColumnId = this.buildUniqueColumnId(currentLookup, columnId);
            String uniqueCountId = this.buildUniqueColumnId(currentLookup, "#items");
            if (ColumnType.NUMBER.equals((Object)targetType)) {
                if (this.groupRequired || this.functionRequired) {
                    if (ColumnType.NUMBER.equals((Object)columnType)) {
                        builder.column(columnId, AggregateFunctionType.SUM, uniqueColumnId);
                        continue;
                    }
                    builder.column(AggregateFunctionType.COUNT, uniqueCountId);
                    continue;
                }
                builder.column(columnId, uniqueColumnId);
                continue;
            }
            if (this.functionRequired) {
                builder.column(AggregateFunctionType.COUNT, uniqueCountId);
                continue;
            }
            builder.column(columnId, uniqueColumnId);
        }
        return builder.buildLookup();
    }

    public String buildUniqueColumnId(DataSetLookup lookup, String targetId) {
        return this.buildUniqueColumnId(lookup, new GroupFunction(targetId, targetId, null));
    }

    public String buildUniqueColumnId(DataSetLookup lookup, GroupFunction column) {
        String targetId = column.getSourceId();
        int lastGop = lookup.getLastGroupOpIndex(0);
        if (lastGop != -1) {
            boolean unique;
            DataSetGroup groupOp = (DataSetGroup)lookup.getOperation(lastGop);
            List<GroupFunction> columnList = groupOp.getGroupFunctions();
            String newColumnId = targetId;
            int counter = 1;
            do {
                unique = true;
                for (int i = 0; i < columnList.size() && unique; ++i) {
                    GroupFunction gf = columnList.get(i);
                    if (gf == column || !newColumnId.equals(gf.getColumnId())) continue;
                    newColumnId = targetId + "_" + ++counter;
                    unique = false;
                }
            } while (!unique);
            return newColumnId;
        }
        return targetId;
    }

    private int getGroupColumn(DataSetMetadata metatada) {
        ColumnType type;
        int i;
        for (i = 0; i < metatada.getNumberOfColumns(); ++i) {
            type = metatada.getColumnType(i);
            if (!type.equals((Object)ColumnType.LABEL)) continue;
            return i;
        }
        for (i = 0; i < metatada.getNumberOfColumns(); ++i) {
            type = metatada.getColumnType(i);
            if (!type.equals((Object)ColumnType.DATE)) continue;
            return i;
        }
        return -1;
    }

    private int getTargetColumn(DataSetMetadata metatada, ColumnType type, Set<Integer> exclude) {
        int target = -1;
        for (int i = 0; i < metatada.getNumberOfColumns(); ++i) {
            if (!type.equals((Object)metatada.getColumnType(i))) continue;
            if (target == -1) {
                target = i;
            }
            if (exclude.contains(i)) continue;
            return i;
        }
        return target;
    }

    private int getTargetColumn(DataSetMetadata metatada, Set<Integer> exclude) {
        for (int i = 0; i < metatada.getNumberOfColumns(); ++i) {
            if (exclude.contains(i)) continue;
            return i;
        }
        return 0;
    }
}

