/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.filter;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.date.TimeFrame;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.CustomFunctionFilter;
import org.dashbuilder.dataset.filter.FilterFunction;
import org.dashbuilder.dataset.filter.LogicalExprFilter;
import org.dashbuilder.dataset.filter.LogicalExprType;

public class FilterFactory {
    public static ColumnFilter isNull() {
        return FilterFactory.isNull(null);
    }

    public static ColumnFilter isNull(String columnId) {
        return new CoreFunctionFilter(columnId, CoreFunctionType.IS_NULL, new Comparable[0]);
    }

    public static ColumnFilter notNull() {
        return FilterFactory.notNull(null);
    }

    public static ColumnFilter notNull(String columnId) {
        return new CoreFunctionFilter(columnId, CoreFunctionType.NOT_NULL, new Comparable[0]);
    }

    public static ColumnFilter equalsTo(Comparable allowedValue) {
        return FilterFactory.equalsTo(null, allowedValue);
    }

    public static ColumnFilter equalsTo(String columnId, Comparable allowedValue) {
        return new CoreFunctionFilter(columnId, CoreFunctionType.EQUALS_TO, allowedValue);
    }

    public static ColumnFilter equalsTo(String columnId, List<Comparable> allowedValues) {
        return new CoreFunctionFilter(columnId, CoreFunctionType.EQUALS_TO, allowedValues);
    }

    public static ColumnFilter likeTo(String columnId, String searchPattern) {
        return FilterFactory.likeTo(columnId, searchPattern, true);
    }

    public static ColumnFilter likeTo(String columnId, String searchPattern, boolean caseSensitive) {
        return new CoreFunctionFilter(columnId, CoreFunctionType.LIKE_TO, new Comparable[]{searchPattern, Boolean.valueOf(caseSensitive)});
    }

    public static ColumnFilter notEqualsTo(Comparable allowedValue) {
        return FilterFactory.notEqualsTo(null, allowedValue);
    }

    public static ColumnFilter notEqualsTo(String columnId, Comparable allowedValue) {
        return new CoreFunctionFilter(columnId, CoreFunctionType.NOT_EQUALS_TO, allowedValue);
    }

    public static ColumnFilter lowerThan(Comparable ref) {
        return FilterFactory.lowerThan(null, ref);
    }

    public static ColumnFilter lowerThan(String columnId, Comparable ref) {
        if (ref instanceof Number) {
            ref = Double.valueOf(((Number)((Object)ref)).doubleValue());
        }
        return new CoreFunctionFilter(columnId, CoreFunctionType.LOWER_THAN, ref);
    }

    public static ColumnFilter lowerOrEqualsTo(Comparable ref) {
        return FilterFactory.lowerOrEqualsTo(null, ref);
    }

    public static ColumnFilter lowerOrEqualsTo(String columnId, Comparable ref) {
        if (ref instanceof Number) {
            ref = Double.valueOf(((Number)((Object)ref)).doubleValue());
        }
        return new CoreFunctionFilter(columnId, CoreFunctionType.LOWER_OR_EQUALS_TO, ref);
    }

    public static ColumnFilter greaterThan(Comparable ref) {
        return FilterFactory.greaterThan(null, ref);
    }

    public static ColumnFilter greaterThan(String columnId, Comparable ref) {
        if (ref instanceof Number) {
            ref = Double.valueOf(((Number)((Object)ref)).doubleValue());
        }
        return new CoreFunctionFilter(columnId, CoreFunctionType.GREATER_THAN, ref);
    }

    public static ColumnFilter greaterOrEqualsTo(Comparable ref) {
        return FilterFactory.greaterOrEqualsTo(null, ref);
    }

    public static ColumnFilter greaterOrEqualsTo(String columnId, Comparable ref) {
        if (ref instanceof Number) {
            ref = Double.valueOf(((Number)((Object)ref)).doubleValue());
        }
        return new CoreFunctionFilter(columnId, CoreFunctionType.GREATER_OR_EQUALS_TO, ref);
    }

    public static ColumnFilter between(Comparable low, Comparable high) {
        return FilterFactory.between(null, low, high);
    }

    public static ColumnFilter between(String columnId, Comparable low, Comparable high) {
        if (low instanceof Number) {
            low = Double.valueOf(((Number)((Object)low)).doubleValue());
        }
        if (high instanceof Number) {
            high = Double.valueOf(((Number)((Object)high)).doubleValue());
        }
        return new CoreFunctionFilter(columnId, CoreFunctionType.BETWEEN, low, high);
    }

    public static ColumnFilter timeFrame(String timeFrame) {
        return FilterFactory.timeFrame(null, timeFrame);
    }

    public static ColumnFilter timeFrame(String columnId, String timeFrame) {
        TimeFrame tf = TimeFrame.parse(timeFrame);
        if (tf == null) {
            throw new IllegalArgumentException("Invalid time frame: " + timeFrame);
        }
        return new CoreFunctionFilter(columnId, CoreFunctionType.TIME_FRAME, new Comparable[]{timeFrame});
    }

    public static ColumnFilter AND(List<ColumnFilter> filters) {
        return FilterFactory.AND(null, filters);
    }

    public static ColumnFilter AND(ColumnFilter ... filters) {
        return FilterFactory.AND(null, filters);
    }

    public static ColumnFilter AND(String columnId, List<ColumnFilter> filters) {
        return new LogicalExprFilter(columnId, LogicalExprType.AND, filters);
    }

    public static ColumnFilter AND(String columnId, ColumnFilter ... filters) {
        return new LogicalExprFilter(columnId, LogicalExprType.AND, filters);
    }

    public static ColumnFilter OR(List<ColumnFilter> filters) {
        return FilterFactory.OR(null, filters);
    }

    public static ColumnFilter OR(ColumnFilter ... filters) {
        return FilterFactory.OR(null, filters);
    }

    public static ColumnFilter OR(String columnId, List<ColumnFilter> filters) {
        return new LogicalExprFilter(columnId, LogicalExprType.OR, filters);
    }

    public static ColumnFilter OR(String columnId, ColumnFilter ... filters) {
        return new LogicalExprFilter(columnId, LogicalExprType.OR, filters);
    }

    public static ColumnFilter NOT(List<ColumnFilter> filters) {
        return FilterFactory.NOT(null, filters);
    }

    public static ColumnFilter NOT(ColumnFilter ... filters) {
        return FilterFactory.NOT(null, filters);
    }

    public static ColumnFilter NOT(String columnId, List<ColumnFilter> filters) {
        return new LogicalExprFilter(columnId, LogicalExprType.NOT, filters);
    }

    public static ColumnFilter NOT(String columnId, ColumnFilter ... filters) {
        return new LogicalExprFilter(columnId, LogicalExprType.NOT, filters);
    }

    public static CoreFunctionFilter createCoreFunctionFilter(String columnId, ColumnType columnType, CoreFunctionType functionType) {
        List params = FilterFactory.createParameters(columnType, functionType);
        CoreFunctionFilter columnFilter = new CoreFunctionFilter();
        columnFilter.setColumnId(columnId);
        columnFilter.setType(functionType);
        columnFilter.setParameters(params);
        return columnFilter;
    }

    public static List createParameters(ColumnType columnType, CoreFunctionType functionType) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (CoreFunctionType.LIKE_TO.equals((Object)functionType)) {
            result.add("%Text%");
            result.add(true);
            return result;
        }
        int n = functionType.getParametersCount();
        for (int i = 0; i < n; ++i) {
            if (ColumnType.NUMBER.equals((Object)columnType)) {
                result.add(100000.0 * (double)i);
                continue;
            }
            if (ColumnType.DATE.equals((Object)columnType)) {
                if (CoreFunctionType.TIME_FRAME.equals((Object)functionType)) {
                    result.add("begin[year] till end[year]");
                    continue;
                }
                Date d = new Date();
                d.setYear(d.getYear() - n + i + 1);
                result.add(d);
                continue;
            }
            result.add("value" + (i + 1));
        }
        return result;
    }

    public static ColumnFilter function(String columnId, FilterFunction function) {
        return new CustomFunctionFilter(columnId, function);
    }
}

