/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.group;

import java.util.ArrayList;
import java.util.List;
import org.dashbuilder.dataset.DataSetOpType;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.dataset.impl.AbstractDataSetOp;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class DataSetGroup
extends AbstractDataSetOp {
    protected boolean join = false;
    protected ColumnGroup columnGroup = null;
    protected List<GroupFunction> groupFunctionList = new ArrayList<GroupFunction>();
    protected List<Interval> selectedIntervalList = new ArrayList<Interval>();

    @Override
    public DataSetOpType getType() {
        return DataSetOpType.GROUP;
    }

    public void setColumnGroup(ColumnGroup columnGroup) {
        this.columnGroup = columnGroup;
    }

    public void addGroupFunction(GroupFunction ... groupFunctions) {
        for (GroupFunction groupFunction : groupFunctions) {
            this.groupFunctionList.add(groupFunction);
        }
    }

    public ColumnGroup getColumnGroup() {
        return this.columnGroup;
    }

    public List<GroupFunction> getGroupFunctions() {
        return this.groupFunctionList;
    }

    public GroupFunction getGroupFunction(String columnId) {
        for (GroupFunction gf : this.groupFunctionList) {
            if (columnId == null || !columnId.equals(gf.getColumnId())) continue;
            return gf;
        }
        for (GroupFunction gf : this.groupFunctionList) {
            if (columnId == null || !columnId.equals(gf.getSourceId())) continue;
            return gf;
        }
        return null;
    }

    public void addSelectedIntervalNames(String ... names) {
        for (String name : names) {
            Interval interval = new Interval(name);
            this.selectedIntervalList.add(interval);
        }
    }

    public void setSelectedIntervalList(List<Interval> intervalList) {
        if (intervalList == null) {
            this.selectedIntervalList.clear();
        } else {
            this.selectedIntervalList = intervalList;
        }
    }

    public List<Interval> getSelectedIntervalList() {
        return this.selectedIntervalList;
    }

    public boolean isSelect() {
        return !this.selectedIntervalList.isEmpty();
    }

    public boolean isJoin() {
        return this.join;
    }

    public void setJoin(boolean join) {
        this.join = join;
    }

    public List<GroupFunction> getAggregationFunctions() {
        ArrayList<GroupFunction> result = new ArrayList<GroupFunction>();
        for (GroupFunction groupFunction : this.groupFunctionList) {
            if (groupFunction.getFunction() == null) continue;
            result.add(groupFunction);
        }
        return result;
    }

    @Override
    public DataSetGroup cloneInstance() {
        DataSetGroup clone = new DataSetGroup();
        clone.dataSetUUID = this.dataSetUUID;
        if (this.columnGroup != null) {
            clone.columnGroup = this.columnGroup.cloneInstance();
        }
        clone.join = this.join;
        clone.selectedIntervalList = new ArrayList<Interval>();
        for (Interval interval : this.selectedIntervalList) {
            clone.selectedIntervalList.add(interval.cloneInstance());
        }
        clone.groupFunctionList = new ArrayList<GroupFunction>();
        for (GroupFunction groupFunction : this.groupFunctionList) {
            clone.groupFunctionList.add(groupFunction.cloneInstance());
        }
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        try {
            Object el;
            int i;
            DataSetGroup other = (DataSetGroup)obj;
            if (this.join != other.join) {
                return false;
            }
            if (this.columnGroup != null && other.columnGroup == null) {
                return false;
            }
            if (this.columnGroup == null && other.columnGroup != null) {
                return false;
            }
            if (this.columnGroup != null && !this.columnGroup.equals(other.columnGroup)) {
                return false;
            }
            if (this.groupFunctionList.size() != other.groupFunctionList.size()) {
                return false;
            }
            if (this.selectedIntervalList.size() != other.selectedIntervalList.size()) {
                return false;
            }
            for (i = 0; i < this.groupFunctionList.size(); ++i) {
                el = this.groupFunctionList.get(i);
                if (other.groupFunctionList.contains(el)) continue;
                return false;
            }
            for (i = 0; i < this.selectedIntervalList.size(); ++i) {
                el = this.selectedIntervalList.get(i);
                if (other.selectedIntervalList.contains(el)) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        if (this.columnGroup != null) {
            out.append("group(").append(this.columnGroup).append(") ");
            if (this.join) {
                out.append(".join()");
            }
        }
        if (!this.selectedIntervalList.isEmpty()) {
            out.append("select(");
            for (Interval interval : this.selectedIntervalList) {
                out.append(interval.getName()).append(" ");
            }
            out.append(")");
        }
        return out.toString();
    }
}

