/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.filter;

import java.util.ArrayList;
import java.util.List;
import org.dashbuilder.dataset.ColumnType;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public enum CoreFunctionType {
    IS_NULL(0),
    NOT_NULL(0),
    EQUALS_TO(1),
    NOT_EQUALS_TO(1),
    GREATER_THAN(1),
    GREATER_OR_EQUALS_TO(1),
    LOWER_THAN(1),
    LOWER_OR_EQUALS_TO(1),
    BETWEEN(2),
    TIME_FRAME(1);

    private final int parametersCount;
    private static final CoreFunctionType[] coreFunctionTypes;

    private CoreFunctionType(int parametersCount) {
        this.parametersCount = parametersCount;
    }

    public int getIndex() {
        return this.ordinal();
    }

    public int getParametersCount() {
        return this.parametersCount;
    }

    public boolean supportsType(ColumnType type) {
        if (TIME_FRAME.equals((Object)this)) {
            return ColumnType.DATE.equals((Object)type);
        }
        return true;
    }

    public static CoreFunctionType getByIndex(int index) {
        return coreFunctionTypes[index];
    }

    public static CoreFunctionType getByName(String type) {
        try {
            return CoreFunctionType.valueOf(type.toUpperCase());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getNumberOfParameters(String type) {
        CoreFunctionType ft = CoreFunctionType.getByName(type);
        return ft.getParametersCount();
    }

    public static List<CoreFunctionType> getSupportedTypes(ColumnType columnType) {
        ArrayList<CoreFunctionType> result = new ArrayList<CoreFunctionType>();
        for (CoreFunctionType funType : coreFunctionTypes) {
            if (!funType.supportsType(columnType)) continue;
            result.add(funType);
        }
        return result;
    }

    static {
        coreFunctionTypes = CoreFunctionType.values();
    }
}

