/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.vsphere;

import com.vmware.vim25.InvalidLogin;
import com.vmware.vim25.mo.Datacenter;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.ServiceInstance;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.AbstractCloud;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.storage.BlobStoreSupport;
import org.dasein.cloud.storage.StorageServices;
import org.dasein.cloud.vsphere.Dc;
import org.dasein.cloud.vsphere.compute.VMwareComputeServices;
import org.dasein.cloud.vsphere.network.VMwareNetworkServices;

public class PrivateCloud
extends AbstractCloud {
    private int holdCount = 0;
    private Thread closingThread = null;

    @Nonnull
    private static String getLastItem(@Nonnull String name) {
        int idx = name.lastIndexOf(46);
        if (idx < 0) {
            return name;
        }
        if (idx == name.length() - 1) {
            return "";
        }
        return name.substring(idx + 1);
    }

    @Nonnull
    public static Logger getLogger(@Nonnull Class<?> cls, @Nonnull String type) {
        String pkg = PrivateCloud.getLastItem(cls.getPackage().getName());
        pkg = pkg.equals("vsphere") ? "" : pkg + ".";
        return Logger.getLogger((String)("dasein.cloud.vsphere." + type + "." + pkg + PrivateCloud.getLastItem(cls.getName())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hold() {
        super.hold();
        PrivateCloud privateCloud = this;
        synchronized (privateCloud) {
            ++this.holdCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        PrivateCloud privateCloud = this;
        synchronized (privateCloud) {
            if (this.holdCount > 0) {
                --this.holdCount;
            }
        }
        super.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        PrivateCloud privateCloud = this;
        synchronized (privateCloud) {
            if (this.closingThread != null) {
                return;
            }
            if (this.holdCount < 1) {
                this.cleanUp();
            } else {
                this.closingThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        long timeout = System.currentTimeMillis() + 1200000L;
                        PrivateCloud privateCloud = PrivateCloud.this;
                        synchronized (privateCloud) {
                            while (PrivateCloud.this.holdCount > 0 && System.currentTimeMillis() < timeout) {
                                try {
                                    ((Object)((Object)PrivateCloud.this)).wait(5000L);
                                }
                                catch (InterruptedException ignore) {}
                            }
                            PrivateCloud.this.cleanUp();
                            PrivateCloud.this.closingThread = null;
                        }
                    }
                };
                this.closingThread.setDaemon(true);
                this.closingThread.start();
            }
        }
    }

    private void cleanUp() {
        super.close();
        try {
            this.getServiceInstance().getServerConnection().logout();
        }
        catch (CloudException ignore) {
        }
        catch (InternalException ignore) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Nonnull
    public String getCloudName() {
        ProviderContext ctx = this.getContext();
        String name = null;
        if (ctx != null) {
            name = ctx.getCloudName();
        }
        return name == null ? "vSphere" : name;
    }

    @Nonnull
    public VMwareNetworkServices getNetworkServices() {
        return new VMwareNetworkServices(this);
    }

    @Nonnull
    public String getProviderName() {
        ProviderContext ctx = this.getContext();
        String name = null;
        if (ctx != null) {
            name = ctx.getProviderName();
        }
        return name == null ? "VMware" : name;
    }

    @Nonnull
    public VMwareComputeServices getComputeServices() {
        return new VMwareComputeServices(this);
    }

    @Nonnull
    public Dc getDataCenterServices() {
        return new Dc(this);
    }

    @Nullable
    public ServiceInstance getServiceInstance() throws CloudException, InternalException {
        ProviderContext ctx = this.getContext();
        if (ctx == null) {
            throw new CloudException("No context exists for this request");
        }
        try {
            String endpoint = ctx.getEndpoint();
            return new ServiceInstance(new URL(endpoint), new String(ctx.getAccessPublic(), "utf-8"), new String(ctx.getAccessPrivate(), "utf-8"), this.isInsecure());
        }
        catch (InvalidLogin e) {
            return null;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw new CloudException("Error creating service instance: " + e.getMessage());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new InternalException("Failed to generate endpoint URL for " + ctx.getEndpoint() + ": " + e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new InternalException("Encoding UTF-8 not supported: " + e.getMessage());
        }
    }

    @Nullable
    public Folder getVmFolder(ServiceInstance instance) throws InternalException, CloudException {
        if (this.isClusterBased()) {
            String regionId = this.getContext().getRegionId();
            if (regionId == null) {
                throw new CloudException("No region has been defined for this request");
            }
            Datacenter dc = this.getDataCenterServices().getVmwareDatacenterFromVDCId(instance, regionId);
            if (dc == null) {
                return null;
            }
            try {
                return dc.getVmFolder();
            }
            catch (RemoteException e) {
                throw new CloudException("Error in cluster processing request: " + e.getMessage());
            }
        }
        return instance.getRootFolder();
    }

    public boolean isClusterBased() throws CloudException {
        ProviderContext ctx = this.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        Properties p = ctx.getCustomProperties();
        boolean cluster = true;
        if (p != null) {
            String b = p.getProperty("clusterBased", "true");
            cluster = b.equalsIgnoreCase("true");
        }
        return cluster;
    }

    public boolean isInsecure() {
        Properties p;
        ProviderContext ctx = this.getContext();
        String value = ctx == null ? null : ((p = ctx.getCustomProperties()) == null ? null : p.getProperty("insecure"));
        if (value == null) {
            value = System.getProperty("insecure");
        }
        return value != null && value.equalsIgnoreCase("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String testContext() {
        String string;
        Logger logger = PrivateCloud.getLogger(PrivateCloud.class, "std");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("enter - " + PrivateCloud.class.getName() + ".testContext()"));
        }
        try {
            BlobStoreSupport support;
            StorageServices services;
            ProviderContext ctx = this.getContext();
            if (ctx == null) {
                String string2 = null;
                return string2;
            }
            if (!this.getComputeServices().getVirtualMachineSupport().isSubscribed()) {
                String string3 = null;
                return string3;
            }
            if (this.hasStorageServices() && (services = this.getStorageServices()) != null && services.hasBlobStoreSupport() && (support = services.getBlobStoreSupport()) != null && !support.isSubscribed()) {
                String string4 = null;
                return string4;
            }
            string = ctx.getAccountNumber();
            return string;
        }
        catch (Throwable t) {
            logger.warn((Object)("testContext(): Failed to test vSphere context: " + t.getMessage()));
            if (logger.isTraceEnabled()) {
                t.printStackTrace();
            }
            string = null;
            return string;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("exit - " + PrivateCloud.class.getName() + ".testContext()"));
            }
        }
    }
}

