/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.vsphere.compute;

import com.vmware.vim25.GuestInfo;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.ManagedEntityStatus;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.TaskInProgress;
import com.vmware.vim25.VirtualHardware;
import com.vmware.vim25.VirtualMachineCloneSpec;
import com.vmware.vim25.VirtualMachineConfigInfo;
import com.vmware.vim25.VirtualMachineConfigSpec;
import com.vmware.vim25.VirtualMachineGuestOsIdentifier;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualMachineRelocateSpec;
import com.vmware.vim25.VirtualMachineRuntimeInfo;
import com.vmware.vim25.mo.ComputeResource;
import com.vmware.vim25.mo.Datacenter;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ResourcePool;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.Task;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.Tag;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.MachineImage;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VMLaunchOptions;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VirtualMachineProduct;
import org.dasein.cloud.compute.VirtualMachineSupport;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.compute.VmStatistics;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.vsphere.PrivateCloud;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;

public class Vm
implements VirtualMachineSupport {
    private PrivateCloud provider;
    private Random random = new Random();
    private static Collection<Architecture> architectures;

    Vm(@Nonnull PrivateCloud provider) {
        this.provider = provider;
    }

    @Nonnull
    private ProviderContext getContext() throws CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        return ctx;
    }

    @Nonnull
    private ServiceInstance getServiceInstance() throws CloudException, InternalException {
        ServiceInstance instance = this.provider.getServiceInstance();
        if (instance == null) {
            throw new CloudException(CloudErrorType.AUTHENTICATION, 401, null, "Unauthorized");
        }
        return instance;
    }

    public void start(@Nonnull String serverId) throws InternalException, CloudException {
        ServiceInstance instance = this.getServiceInstance();
        com.vmware.vim25.mo.VirtualMachine vm = this.getVirtualMachine(instance, serverId);
        if (vm != null) {
            try {
                Datacenter dc = this.getVmwareDatacenter(vm);
                if (dc == null) {
                    throw new CloudException("Could not identify a deployment data center.");
                }
                vm.powerOnVM_Task(this.getBestHost(dc));
            }
            catch (TaskInProgress e) {
                throw new CloudException((Throwable)e);
            }
            catch (InvalidState e) {
                throw new CloudException((Throwable)e);
            }
            catch (RuntimeFault e) {
                throw new InternalException((Throwable)e);
            }
            catch (RemoteException e) {
                throw new CloudException((Throwable)e);
            }
        }
    }

    @Nonnull
    com.vmware.vim25.mo.VirtualMachine clone(@Nonnull ServiceInstance service, @Nonnull com.vmware.vim25.mo.VirtualMachine vm, @Nonnull String name, boolean asTemplate) throws InternalException, CloudException {
        try {
            String dcId = this.getDataCenter(vm);
            if (dcId == null) {
                throw new CloudException("Virtual machine " + vm + " has no data center parent");
            }
            name = this.validateName(name);
            Datacenter dc = this.provider.getDataCenterServices().getVmwareDatacenterFromVDCId(service, dcId);
            ResourcePool pool = vm.getResourcePool();
            if (dc == null) {
                throw new CloudException("Invalid DC for cloning operation: " + dcId);
            }
            Folder vmFolder = dc.getVmFolder();
            VirtualMachineConfigSpec config = new VirtualMachineConfigSpec();
            VirtualMachineProduct product = this.getProduct(vm.getConfig().getHardware());
            String[] sizeInfo = product.getProviderProductId().split(":");
            int cpuCount = Integer.parseInt(sizeInfo[0]);
            long memory = Long.parseLong(sizeInfo[1]);
            config.setName(name);
            config.setAnnotation(vm.getConfig().getAnnotation());
            config.setMemoryMB(Long.valueOf(memory));
            config.setNumCPUs(Integer.valueOf(cpuCount));
            VirtualMachineCloneSpec spec = new VirtualMachineCloneSpec();
            VirtualMachineRelocateSpec location = new VirtualMachineRelocateSpec();
            location.setHost(this.getBestHost(dc).getConfig().getHost());
            location.setPool(pool.getConfig().getEntity());
            spec.setLocation(location);
            spec.setPowerOn(false);
            spec.setTemplate(asTemplate);
            spec.setConfig(config);
            Task task = vm.cloneVM_Task(vmFolder, name, spec);
            String status = task.waitForTask();
            if (status.equals("success")) {
                return (com.vmware.vim25.mo.VirtualMachine)new InventoryNavigator((ManagedEntity)vmFolder).searchManagedEntity("VirtualMachine", name);
            }
            throw new CloudException("Failed to create VM: " + task.getTaskInfo().getError().getLocalizedMessage());
        }
        catch (InvalidProperty e) {
            throw new CloudException((Throwable)e);
        }
        catch (RuntimeFault e) {
            throw new InternalException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new CloudException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Nonnull
    public VirtualMachine clone(@Nonnull String serverId, @Nullable String intoDcId, @Nonnull String name, @Nonnull String description, boolean powerOn, String ... firewallIds) throws InternalException, CloudException {
        ServiceInstance service = this.getServiceInstance();
        com.vmware.vim25.mo.VirtualMachine vm = this.getVirtualMachine(service, serverId);
        if (vm != null) {
            VirtualMachine target = this.toServer(this.clone(service, vm, name, false), description);
            if (target == null) {
                throw new CloudException("Request appeared to succeed, but no VM was created");
            }
            if (powerOn) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                String id = target.getProviderVirtualMachineId();
                if (id == null) {
                    throw new CloudException("Got a VM without an ID");
                }
                this.start(id);
            }
            return target;
        }
        throw new CloudException("No virtual machine " + serverId + ".");
    }

    private ManagedEntity[] randomize(ManagedEntity[] source) {
        return source;
    }

    @Nonnull
    private VirtualMachine define(@Nonnull VMLaunchOptions options) throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new InternalException("No context was set for this request");
        }
        ServiceInstance service = this.getServiceInstance();
        try {
            String rid;
            com.vmware.vim25.mo.VirtualMachine template = this.getTemplate(service, options.getMachineImageId());
            if (template == null) {
                throw new CloudException("No such template: " + options.getMachineImageId());
            }
            String hostName = this.validateName(options.getHostName());
            String dataCenterId = options.getDataCenterId();
            if (dataCenterId == null && (rid = ctx.getRegionId()) != null) {
                for (DataCenter dsdc : this.provider.getDataCenterServices().listDataCenters(rid)) {
                    dataCenterId = dsdc.getProviderDataCenterId();
                    if (this.random.nextInt() % 3 != 0) continue;
                    break;
                }
            }
            ManagedEntity[] pools = null;
            Datacenter vdc = null;
            if (dataCenterId != null) {
                if (this.provider.isClusterBased()) {
                    DataCenter dc = this.provider.getDataCenterServices().getDataCenter(dataCenterId);
                    if (dc == null) {
                        throw new CloudException("No such data center: " + dataCenterId);
                    }
                    vdc = this.provider.getDataCenterServices().getVmwareDatacenterFromVDCId(service, dc.getRegionId());
                    if (vdc == null) {
                        throw new CloudException("Unable to identify VDC " + dc.getRegionId());
                    }
                    ResourcePool pool = this.provider.getDataCenterServices().getResourcePoolFromClusterId(service, dataCenterId);
                    if (pool != null) {
                        pools = new ManagedEntity[]{pool};
                    }
                } else {
                    vdc = this.provider.getDataCenterServices().getVmwareDatacenterFromVDCId(service, dataCenterId);
                    pools = new InventoryNavigator((ManagedEntity)vdc).searchManagedEntities("ResourcePool");
                }
            }
            if (vdc == null) {
                if (this.provider.isClusterBased()) {
                    vdc = this.getVmwareDatacenter(template);
                    pools = this.randomize(new InventoryNavigator((ManagedEntity)vdc).searchManagedEntities("ResourcePool"));
                }
                if (vdc == null) {
                    throw new CloudException("Could not identify a valid data center (" + dataCenterId + " attempted)");
                }
            }
            CloudException lastError = null;
            for (void var13_17 : pools) {
                ResourcePool pool = (ResourcePool)var13_17;
                Folder vmFolder = vdc.getVmFolder();
                VirtualMachineConfigSpec config = new VirtualMachineConfigSpec();
                String[] vmInfo = options.getStandardProductId().split(":");
                int cpuCount = Integer.parseInt(vmInfo[0]);
                long memory = Long.parseLong(vmInfo[1]);
                config.setName(hostName);
                config.setAnnotation(options.getMachineImageId());
                config.setMemoryMB(Long.valueOf(memory));
                config.setNumCPUs(Integer.valueOf(cpuCount));
                VirtualMachineCloneSpec spec = new VirtualMachineCloneSpec();
                VirtualMachineRelocateSpec location = new VirtualMachineRelocateSpec();
                location.setPool(pool.getConfig().getEntity());
                spec.setLocation(location);
                spec.setPowerOn(false);
                spec.setTemplate(false);
                spec.setConfig(config);
                Task task = template.cloneVM_Task(vmFolder, hostName, spec);
                String status = task.waitForTask();
                if (status.equals("success")) {
                    long timeout = System.currentTimeMillis() + 1200000L;
                    while (System.currentTimeMillis() < timeout) {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                        for (VirtualMachine s : this.listVirtualMachines()) {
                            if (!s.getName().equals(hostName)) continue;
                            return s;
                        }
                    }
                    lastError = new CloudException("Unable to identify newly created server.");
                    continue;
                }
                lastError = new CloudException("Failed to create VM: " + task.getTaskInfo().getError().getLocalizedMessage());
            }
            if (lastError != null) {
                throw lastError;
            }
            throw new CloudException("No server and no error");
        }
        catch (InvalidProperty e) {
            throw new CloudException((Throwable)e);
        }
        catch (RuntimeFault e) {
            throw new InternalException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new CloudException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Nonnull
    Architecture getArchitecture(@Nonnull VirtualMachineGuestOsIdentifier os) {
        if (os.name().contains("64")) {
            return Architecture.I64;
        }
        return Architecture.I32;
    }

    @Nonnull
    HostSystem getBestHost(@Nonnull Datacenter forDatacenter) throws CloudException, RemoteException {
        Collection<HostSystem> possibles = this.getPossibleHosts(forDatacenter);
        if (possibles.isEmpty()) {
            HostSystem ohWell = null;
            for (ManagedEntity me : forDatacenter.getHostFolder().getChildEntity()) {
                ComputeResource cluster = (ComputeResource)me;
                for (HostSystem host : cluster.getHosts()) {
                    if (host.getConfigStatus().equals((Object)ManagedEntityStatus.green)) {
                        return host;
                    }
                    if (ohWell != null && !host.getConfigStatus().equals((Object)ManagedEntityStatus.yellow)) continue;
                    ohWell = host;
                }
            }
            if (ohWell == null) {
                throw new CloudException("Insufficient capacity for this operation");
            }
            return ohWell;
        }
        return possibles.iterator().next();
    }

    @Nonnull
    Collection<HostSystem> getPossibleHosts(@Nonnull Datacenter dc) throws CloudException, RemoteException {
        ArrayList<HostSystem> possibles = new ArrayList<HostSystem>();
        for (ManagedEntity me : dc.getHostFolder().getChildEntity()) {
            ComputeResource cluster = (ComputeResource)me;
            for (HostSystem host : cluster.getHosts()) {
                if (!host.getConfigStatus().equals((Object)ManagedEntityStatus.green)) continue;
                possibles.add(host);
            }
        }
        return possibles;
    }

    @Nonnull
    public String getConsoleOutput(@Nonnull String serverId) throws InternalException, CloudException {
        return "";
    }

    public int getMaximumVirtualMachineCount() throws CloudException, InternalException {
        return -1;
    }

    @Nullable
    private String getDataCenter(@Nonnull com.vmware.vim25.mo.VirtualMachine vm) throws InternalException, CloudException {
        if (this.provider.isClusterBased()) {
            try {
                return vm.getResourcePool().getOwner().getName();
            }
            catch (RemoteException e) {
                throw new CloudException((Throwable)e);
            }
        }
        ManagedEntity parent = vm.getParent();
        if (parent == null) {
            parent = vm.getParentVApp();
        }
        while (parent != null) {
            if (parent instanceof Datacenter) {
                return parent.getName();
            }
            parent = parent.getParent();
        }
        return null;
    }

    @Nonnull
    public Collection<String> listFirewalls(@Nonnull String serverId) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Nullable
    private HostSystem getHost(@Nonnull com.vmware.vim25.mo.VirtualMachine vm) throws InternalException, CloudException {
        for (ManagedEntity parent = vm.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof HostSystem)) continue;
            return (HostSystem)parent;
        }
        return null;
    }

    @Nullable
    private com.vmware.vim25.mo.VirtualMachine getTemplate(@Nonnull ServiceInstance service, @Nonnull String templateId) throws CloudException, RemoteException, InternalException {
        Folder folder = this.provider.getVmFolder(service);
        ManagedEntity[] mes = new InventoryNavigator((ManagedEntity)folder).searchManagedEntities("VirtualMachine");
        if (mes != null && mes.length > 0) {
            for (ManagedEntity entity : mes) {
                VirtualMachineConfigInfo vminfo;
                com.vmware.vim25.mo.VirtualMachine template = (com.vmware.vim25.mo.VirtualMachine)entity;
                if (template == null || (vminfo = template.getConfig()) == null || !vminfo.isTemplate() || !vminfo.getUuid().equals(templateId)) continue;
                return template;
            }
        }
        return null;
    }

    @Nullable
    public VirtualMachineProduct getProduct(@Nonnull String productId) throws InternalException, CloudException {
        for (VirtualMachineProduct product : this.listProducts(Architecture.I64)) {
            if (!product.getProviderProductId().equals(productId)) continue;
            return product;
        }
        for (VirtualMachineProduct product : this.listProducts(Architecture.I32)) {
            if (!product.getProviderProductId().equals(productId)) continue;
            return product;
        }
        return null;
    }

    @Nonnull
    public String getProviderTermForServer(@Nonnull Locale locale) {
        return "server";
    }

    @Nullable
    public VirtualMachine getVirtualMachine(@Nonnull String serverId) throws InternalException, CloudException {
        ServiceInstance instance = this.getServiceInstance();
        com.vmware.vim25.mo.VirtualMachine vm = this.getVirtualMachine(instance, serverId);
        if (vm == null) {
            return null;
        }
        return this.toServer(vm, null);
    }

    @Nullable
    public VmStatistics getVMStatistics(@Nonnull String serverId, long start, long end) throws InternalException, CloudException {
        return null;
    }

    @Nonnull
    public Collection<VmStatistics> getVMStatisticsForPeriod(@Nonnull String serverId, long start, long end) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Nonnull
    public Requirement identifyPasswordRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyRootVolumeRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyShellKeyRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyVlanRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    public boolean isAPITerminationPreventable() throws CloudException, InternalException {
        return false;
    }

    public boolean isBasicAnalyticsSupported() throws CloudException, InternalException {
        return false;
    }

    public boolean isExtendedAnalyticsSupported() throws CloudException, InternalException {
        return false;
    }

    @Nonnull
    private VirtualMachineProduct getProduct(@Nonnull VirtualHardware hardware) throws InternalException, CloudException {
        VirtualMachineProduct product = this.getProduct(hardware.getNumCPU() + ":" + hardware.getMemoryMB());
        if (product == null) {
            int cpu = hardware.getNumCPU();
            int ram = hardware.getMemoryMB();
            int disk = 1;
            product = new VirtualMachineProduct();
            product.setCpuCount(cpu);
            product.setDescription("Custom product " + cpu + " CPU, " + ram + " RAM");
            product.setName(cpu + " CPU/" + ram + " MB RAM");
            product.setRootVolumeSize(new Storage((Number)disk, (StorageUnit)Storage.GIGABYTE));
            product.setProviderProductId(cpu + ":" + ram);
        }
        return product;
    }

    @Nonnull
    public Collection<VirtualMachineProduct> listProducts(@Nonnull Architecture architecture) throws InternalException, CloudException {
        ArrayList<VirtualMachineProduct> sizes = new ArrayList<VirtualMachineProduct>();
        for (Architecture a : this.listSupportedArchitectures()) {
            if (!a.equals((Object)architecture)) continue;
            if (a.equals((Object)Architecture.I32)) {
                for (int cpu : new int[]{1, 2}) {
                    for (int ram : new int[]{512, 1024, 2048}) {
                        VirtualMachineProduct product = new VirtualMachineProduct();
                        product.setCpuCount(cpu);
                        product.setDescription("Custom product " + architecture + " - " + cpu + " CPU, " + ram + "GB RAM");
                        product.setName(cpu + " CPU/" + ram + " GB RAM");
                        product.setRootVolumeSize(new Storage((Number)1, (StorageUnit)Storage.GIGABYTE));
                        product.setProviderProductId(cpu + ":" + ram);
                        product.setRamSize(new Storage((Number)ram, (StorageUnit)Storage.MEGABYTE));
                        sizes.add(product);
                    }
                }
            } else {
                for (int cpu : new int[]{1, 2, 4, 8}) {
                    for (int ram : new int[]{1024, 2048, 4096, 10240, 20480}) {
                        VirtualMachineProduct product = new VirtualMachineProduct();
                        product.setCpuCount(cpu);
                        product.setDescription("Custom product " + architecture + " - " + cpu + " CPU, " + ram + "GB RAM");
                        product.setName(cpu + " CPU/" + ram + " GB RAM");
                        product.setRootVolumeSize(new Storage((Number)1, (StorageUnit)Storage.GIGABYTE));
                        product.setProviderProductId(cpu + ":" + ram);
                        product.setRamSize(new Storage((Number)ram, (StorageUnit)Storage.MEGABYTE));
                        sizes.add(product);
                    }
                }
            }
            return sizes;
        }
        return Collections.emptyList();
    }

    public Iterable<Architecture> listSupportedArchitectures() throws InternalException, CloudException {
        if (architectures == null) {
            ArrayList<Architecture> list = new ArrayList<Architecture>();
            list.add(Architecture.I32);
            list.add(Architecture.I64);
            architectures = Collections.unmodifiableCollection(list);
        }
        return architectures;
    }

    @Nullable
    com.vmware.vim25.mo.VirtualMachine getVirtualMachine(@Nonnull ServiceInstance instance, @Nonnull String vmId) throws CloudException, InternalException {
        ManagedEntity[] mes;
        Folder folder = this.provider.getVmFolder(instance);
        try {
            mes = new InventoryNavigator((ManagedEntity)folder).searchManagedEntities("VirtualMachine");
        }
        catch (InvalidProperty e) {
            throw new CloudException("No virtual machine support in cluster: " + e.getMessage());
        }
        catch (RuntimeFault e) {
            throw new CloudException("Error in processing request to cluster: " + e.getMessage());
        }
        catch (RemoteException e) {
            throw new CloudException("Error in cluster processing request: " + e.getMessage());
        }
        if (mes != null && mes.length > 0) {
            for (ManagedEntity entity : mes) {
                VirtualMachineConfigInfo cfg;
                com.vmware.vim25.mo.VirtualMachine vm = (com.vmware.vim25.mo.VirtualMachine)entity;
                VirtualMachineConfigInfo virtualMachineConfigInfo = cfg = vm == null ? null : vm.getConfig();
                if (cfg == null || !cfg.getInstanceUuid().equals(vmId)) continue;
                return vm;
            }
        }
        return null;
    }

    @Nullable
    private Datacenter getVmwareDatacenter(@Nonnull com.vmware.vim25.mo.VirtualMachine vm) throws CloudException {
        ManagedEntity parent = vm.getParent();
        if (parent == null) {
            parent = vm.getParentVApp();
        }
        while (parent != null) {
            if (parent instanceof Datacenter) {
                return (Datacenter)parent;
            }
            parent = parent.getParent();
        }
        System.out.println("Failed to find VMware DC for " + vm + " in " + vm.getParent() + " / " + vm.getParentVApp());
        return null;
    }

    @Nonnull
    public VirtualMachine launch(@Nonnull String templateId, @Nonnull VirtualMachineProduct product, @Nullable String dataCenterId, @Nonnull String serverName, @Nonnull String description, @Nullable String withKey, @Nullable String inVlanId, boolean withMonitoring, boolean forImaging, String ... firewalls) throws InternalException, CloudException {
        return this.launch(templateId, product, dataCenterId, serverName, description, withKey, inVlanId, withMonitoring, forImaging, firewalls, new Tag[0]);
    }

    @Nonnull
    public VirtualMachine launch(@Nonnull String templateId, @Nonnull VirtualMachineProduct product, @Nullable String dataCenterId, @Nonnull String serverName, @Nonnull String description, String withKeypairId, String inVlanId, boolean withMonitoring, boolean asSandbox, @Nullable String[] firewalls, Tag ... tags) throws InternalException, CloudException {
        VMLaunchOptions options = VMLaunchOptions.getInstance((String)product.getProviderProductId(), (String)templateId, (String)serverName, (String)description);
        if (inVlanId != null) {
            if (dataCenterId == null) {
                throw new CloudException("No data center specified for VLAN " + inVlanId);
            }
            options.inVlan(null, dataCenterId, inVlanId);
        } else if (dataCenterId != null) {
            options = options.inDataCenter(dataCenterId);
        }
        if (withKeypairId != null) {
            options = options.withBoostrapKey(withKeypairId);
        }
        if (withMonitoring) {
            options = options.withExtendedAnalytics();
        }
        if (firewalls != null) {
            options = options.behindFirewalls(firewalls);
        }
        if (tags != null) {
            for (Tag t : tags) {
                options = options.withMetaData(t.getKey(), (Object)t.getValue());
            }
        }
        VirtualMachine server = this.define(options);
        this.start(server.getProviderVirtualMachineId());
        return server;
    }

    @Nonnull
    public VirtualMachine launch(VMLaunchOptions withLaunchOptions) throws CloudException, InternalException {
        VirtualMachine server = this.define(withLaunchOptions);
        this.start(server.getProviderVirtualMachineId());
        return server;
    }

    @Nonnull
    public Collection<VirtualMachine> listVirtualMachines() throws InternalException, CloudException {
        ManagedEntity[] mes;
        ServiceInstance instance = this.getServiceInstance();
        Folder folder = this.provider.getVmFolder(instance);
        ArrayList<VirtualMachine> servers = new ArrayList<VirtualMachine>();
        try {
            mes = new InventoryNavigator((ManagedEntity)folder).searchManagedEntities("VirtualMachine");
        }
        catch (InvalidProperty e) {
            throw new CloudException("No virtual machine support in cluster: " + e.getMessage());
        }
        catch (RuntimeFault e) {
            throw new CloudException("Error in processing request to cluster: " + e.getMessage());
        }
        catch (RemoteException e) {
            throw new CloudException("Error in cluster processing request: " + e.getMessage());
        }
        if (mes != null && mes.length > 0) {
            for (ManagedEntity entity : mes) {
                VirtualMachine server = this.toServer((com.vmware.vim25.mo.VirtualMachine)entity, null);
                if (server == null) continue;
                servers.add(server);
            }
        }
        return servers;
    }

    public void pause(@Nonnull String vmId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Pause/unpause is not supported with vSphere systems");
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    public void enableAnalytics(@Nonnull String serverId) throws InternalException, CloudException {
    }

    public void resume(@Nonnull String serverId) throws InternalException, CloudException {
        ServiceInstance instance = this.getServiceInstance();
        com.vmware.vim25.mo.VirtualMachine vm = this.getVirtualMachine(instance, serverId);
        if (vm != null) {
            try {
                vm.powerOnVM_Task(null);
            }
            catch (TaskInProgress e) {
                throw new CloudException((Throwable)e);
            }
            catch (InvalidState e) {
                throw new CloudException((Throwable)e);
            }
            catch (RuntimeFault e) {
                throw new InternalException((Throwable)e);
            }
            catch (RemoteException e) {
                throw new CloudException((Throwable)e);
            }
        }
    }

    public void stop(@Nonnull String serverId) throws InternalException, CloudException {
        ServiceInstance instance = this.getServiceInstance();
        com.vmware.vim25.mo.VirtualMachine vm = this.getVirtualMachine(instance, serverId);
        if (vm != null) {
            try {
                vm.powerOffVM_Task();
            }
            catch (TaskInProgress e) {
                throw new CloudException((Throwable)e);
            }
            catch (InvalidState e) {
                throw new CloudException((Throwable)e);
            }
            catch (RuntimeFault e) {
                throw new InternalException((Throwable)e);
            }
            catch (RemoteException e) {
                throw new CloudException((Throwable)e);
            }
        }
    }

    public void suspend(@Nonnull String serverId) throws InternalException, CloudException {
        ServiceInstance instance = this.getServiceInstance();
        com.vmware.vim25.mo.VirtualMachine vm = this.getVirtualMachine(instance, serverId);
        if (vm != null) {
            try {
                vm.suspendVM_Task();
            }
            catch (TaskInProgress e) {
                throw new CloudException((Throwable)e);
            }
            catch (InvalidState e) {
                throw new CloudException((Throwable)e);
            }
            catch (RuntimeFault e) {
                throw new InternalException((Throwable)e);
            }
            catch (RemoteException e) {
                throw new CloudException((Throwable)e);
            }
        }
    }

    public void reboot(@Nonnull String serverId) throws CloudException, InternalException {
        final String id = serverId;
        this.provider.hold();
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Vm.this.powerOnAndOff(id);
                }
                finally {
                    Vm.this.provider.release();
                }
            }
        };
        t.setName("Reboot " + serverId);
        t.setDaemon(true);
        t.start();
    }

    private void powerOnAndOff(@Nonnull String serverId) {
        block5: {
            try {
                ServiceInstance service = this.provider.getServiceInstance();
                com.vmware.vim25.mo.VirtualMachine vm = this.getVirtualMachine(service, serverId);
                HostSystem host = this.getHost(vm);
                if (vm == null) break block5;
                Task task = vm.powerOffVM_Task();
                String status = task.waitForTask();
                if (!status.equals("success")) {
                    System.err.println("Reboot failed: " + status);
                    break block5;
                }
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                vm = this.getVirtualMachine(service, serverId);
                vm.powerOnVM_Task(host);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void terminate(@Nonnull String serverId) throws InternalException, CloudException {
        final String id = serverId;
        this.provider.hold();
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Vm.this.terminateVm(id);
                }
                finally {
                    Vm.this.provider.release();
                }
            }
        };
        t.setName("Terminate " + serverId);
        t.setDaemon(true);
        t.start();
    }

    public void unpause(@Nonnull String vmId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Pause/unpause is not supported with vSphere systems");
    }

    private void terminateVm(@Nonnull String serverId) {
        block6: {
            try {
                ServiceInstance service = this.getServiceInstance();
                com.vmware.vim25.mo.VirtualMachine vm = this.getVirtualMachine(service, serverId);
                if (vm == null) break block6;
                Task task = vm.powerOffVM_Task();
                String status = task.waitForTask();
                if (!status.equals("success")) {
                    System.err.println("Termination failed: " + status);
                    break block6;
                }
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                vm = this.getVirtualMachine(service, serverId);
                if (vm != null) {
                    vm.destroy_Task();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private boolean isPublicIpAddress(@Nonnull String ipv4Address) {
        if (ipv4Address.startsWith("10.") || ipv4Address.startsWith("192.168") || ipv4Address.startsWith("169.254")) {
            return false;
        }
        if (ipv4Address.startsWith("172.")) {
            String[] parts = ipv4Address.split("\\.");
            if (parts.length != 4) {
                return true;
            }
            int x = Integer.parseInt(parts[1]);
            if (x >= 16 && x <= 31) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private VirtualMachine toServer(@Nullable com.vmware.vim25.mo.VirtualMachine vm, @Nullable String description) throws InternalException, CloudException {
        if (vm != null) {
            VirtualMachineRuntimeInfo runtime;
            String ipAddress;
            VirtualMachineConfigInfo vminfo;
            try {
                vminfo = vm.getConfig();
            }
            catch (RuntimeException e) {
                return null;
            }
            if (vminfo == null || vminfo.isTemplate()) {
                return null;
            }
            VirtualMachineGuestOsIdentifier os = VirtualMachineGuestOsIdentifier.valueOf((String)vminfo.getGuestId());
            VirtualMachine server = new VirtualMachine();
            GuestInfo guest = vm.getGuest();
            String addr = guest.getIpAddress();
            server.setPrivateIpAddresses(new String[0]);
            server.setPublicIpAddresses(new String[0]);
            if (addr != null) {
                if (this.isPublicIpAddress(addr)) {
                    server.setPublicIpAddresses(new String[]{addr});
                } else {
                    server.setPrivateIpAddresses(new String[]{addr});
                }
            }
            if (guest.getHostName() != null) {
                server.setPrivateDnsAddress(guest.getHostName());
            }
            server.setName(vm.getName());
            server.setPlatform(Platform.guess((String)vminfo.getGuestFullName()));
            server.setProviderVirtualMachineId(vm.getConfig().getInstanceUuid());
            server.setPersistent(true);
            server.setArchitecture(this.getArchitecture(os));
            if (description == null) {
                description = vm.getName();
            }
            server.setDescription(description);
            server.setProductId(this.getProduct(vminfo.getHardware()).getProviderProductId());
            String imageId = vminfo.getAnnotation();
            MachineImage img = null;
            if (imageId != null) {
                img = this.provider.getComputeServices().getImageSupport().getMachineImage(imageId);
            }
            if (img != null) {
                server.setProviderMachineImageId(vminfo.getAnnotation());
            } else {
                server.setProviderMachineImageId(this.getContext().getAccountNumber() + "-unknown");
            }
            server.setProviderRegionId(this.getContext().getRegionId());
            String dc = this.getDataCenter(vm);
            if (dc == null) {
                return null;
            }
            server.setProviderDataCenterId(dc);
            GuestInfo guestInfo = vm.getGuest();
            if (guestInfo != null && (ipAddress = guestInfo.getIpAddress()) != null) {
                server.setPrivateIpAddresses(new String[]{guestInfo.getIpAddress()});
                server.setPrivateDnsAddress(guestInfo.getIpAddress());
            }
            if ((runtime = vm.getRuntime()) != null) {
                VirtualMachinePowerState state = runtime.getPowerState();
                if (server.getCurrentState() == null) {
                    switch (state) {
                        case suspended: {
                            server.setCurrentState(VmState.SUSPENDED);
                        }
                        case poweredOff: {
                            server.setCurrentState(VmState.STOPPED);
                            break;
                        }
                        case poweredOn: {
                            server.setCurrentState(VmState.RUNNING);
                        }
                    }
                }
                Calendar suspend = runtime.getSuspendTime();
                Calendar time = runtime.getBootTime();
                if (suspend == null || suspend.getTimeInMillis() < 1L) {
                    server.setLastPauseTimestamp(-1L);
                } else {
                    server.setLastPauseTimestamp(suspend.getTimeInMillis());
                    server.setCreationTimestamp(server.getLastPauseTimestamp());
                }
                if (time == null || time.getTimeInMillis() < 1L) {
                    server.setLastBootTimestamp(0L);
                } else {
                    server.setLastBootTimestamp(time.getTimeInMillis());
                    server.setCreationTimestamp(server.getLastBootTimestamp());
                }
            }
            server.setProviderOwnerId(this.getContext().getAccountNumber());
            return server;
        }
        return null;
    }

    public void disableAnalytics(String serverId) throws InternalException, CloudException {
    }

    private String validateName(String name) {
        if ((name = name.toLowerCase().replaceAll("_", "-")).length() <= 30) {
            return name;
        }
        return name.substring(0, 30);
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return this.provider.getServiceInstance() != null;
    }

    public boolean isUserDataSupported() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsAnalytics() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsPauseUnpause(@Nonnull VirtualMachine vm) {
        return false;
    }

    public boolean supportsStartStop(@Nonnull VirtualMachine vm) {
        return true;
    }

    public boolean supportsSuspendResume(@Nonnull VirtualMachine vm) {
        return true;
    }
}

