/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.vsphere.compute;

import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.VirtualMachineConfigInfo;
import com.vmware.vim25.VirtualMachineGuestOsIdentifier;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualMachineRuntimeInfo;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualMachine;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AsynchronousTask;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.MachineImage;
import org.dasein.cloud.compute.MachineImageFormat;
import org.dasein.cloud.compute.MachineImageState;
import org.dasein.cloud.compute.MachineImageSupport;
import org.dasein.cloud.compute.MachineImageType;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.vsphere.PrivateCloud;

public class Template
implements MachineImageSupport {
    private PrivateCloud provider;

    Template(@Nonnull PrivateCloud cloud) {
        this.provider = cloud;
    }

    @Nonnull
    private ProviderContext getContext() throws CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        return ctx;
    }

    @Nonnull
    private ServiceInstance getServiceInstance() throws CloudException, InternalException {
        ServiceInstance instance = this.provider.getServiceInstance();
        if (instance == null) {
            throw new CloudException(CloudErrorType.AUTHENTICATION, 401, null, "Unauthorized");
        }
        return instance;
    }

    public void remove(@Nonnull String templateId) throws InternalException, CloudException {
        ServiceInstance service = this.getServiceInstance();
        VirtualMachine vm = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(service, templateId);
        if (vm == null) {
            throw new CloudException("No such template: " + templateId);
        }
        try {
            vm.destroy_Task();
        }
        catch (RemoteException e) {
            throw new CloudException((Throwable)e);
        }
    }

    @Nullable
    public MachineImage getMachineImage(@Nonnull String templateId) throws InternalException, CloudException {
        for (MachineImage image : this.listMachineImages()) {
            if (!image.getProviderMachineImageId().equals(templateId)) continue;
            return image;
        }
        return null;
    }

    @Nonnull
    public String getProviderTermForImage(@Nonnull Locale locale) {
        return "template";
    }

    @Nonnull
    public Collection<String> listShares(@Nonnull String templateId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Collection<MachineImage> listMachineImages() throws InternalException, CloudException {
        ManagedEntity[] mes;
        ArrayList<MachineImage> machineImages = new ArrayList<MachineImage>();
        ServiceInstance instance = this.getServiceInstance();
        Folder folder = this.provider.getVmFolder(instance);
        try {
            mes = new InventoryNavigator((ManagedEntity)folder).searchManagedEntities("VirtualMachine");
        }
        catch (InvalidProperty e) {
            throw new CloudException("No virtual machine support in cluster: " + e.getMessage());
        }
        catch (RuntimeFault e) {
            throw new CloudException("Error in processing request to cluster: " + e.getMessage());
        }
        catch (RemoteException e) {
            throw new CloudException("Error in cluster processing request: " + e.getMessage());
        }
        if (mes != null && mes.length > 0) {
            for (ManagedEntity entity : mes) {
                MachineImage image;
                VirtualMachine template = (VirtualMachine)entity;
                if (template == null) continue;
                VirtualMachineConfigInfo cfg = null;
                try {
                    cfg = template.getConfig();
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                if (cfg == null || !cfg.isTemplate() || (image = this.toMachineImage(template)) == null) continue;
                machineImages.add(image);
            }
        }
        return machineImages;
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    public void shareMachineImage(@Nonnull String templateId, @Nullable String withAccountId, boolean grant) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Sharing not supported.");
    }

    @Nullable
    private MachineImage toMachineImage(@Nullable VirtualMachine template) throws InternalException, CloudException {
        if (template != null) {
            Platform platform;
            VirtualMachineGuestOsIdentifier os;
            VirtualMachineConfigInfo vminfo;
            MachineImage image = new MachineImage();
            try {
                vminfo = template.getConfig();
            }
            catch (RuntimeException e) {
                return null;
            }
            try {
                os = VirtualMachineGuestOsIdentifier.valueOf((String)vminfo.getGuestId());
                platform = Platform.guess((String)vminfo.getGuestFullName());
            }
            catch (IllegalArgumentException e) {
                System.out.println("DEBUG: No such guest in enum: " + vminfo.getGuestId());
                os = null;
                platform = Platform.guess((String)vminfo.getGuestId());
            }
            if (os == null) {
                image.setArchitecture(vminfo.getGuestId().contains("64") ? Architecture.I32 : Architecture.I64);
            } else {
                image.setArchitecture(this.provider.getComputeServices().getVirtualMachineSupport().getArchitecture(os));
            }
            image.setDescription(template.getName());
            image.setName(template.getName());
            image.setProviderOwnerId(this.getContext().getAccountNumber());
            image.setPlatform(platform);
            image.setProviderMachineImageId(vminfo.getUuid());
            image.setType(MachineImageType.VOLUME);
            image.setProviderRegionId(this.getContext().getRegionId());
            image.setSoftware("");
            image.setTags(new HashMap());
            VirtualMachineRuntimeInfo runtime = template.getRuntime();
            VirtualMachinePowerState state = VirtualMachinePowerState.poweredOff;
            if (runtime != null) {
                state = runtime.getPowerState();
            }
            if (state.equals((Object)VirtualMachinePowerState.poweredOff)) {
                image.setCurrentState(MachineImageState.ACTIVE);
            } else {
                image.setCurrentState(MachineImageState.PENDING);
            }
            return image;
        }
        return null;
    }

    public void downloadImage(@Nonnull String machineImageId, @Nonnull OutputStream toOutput) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Not supported");
    }

    public boolean hasPublicLibrary() {
        return false;
    }

    @Nonnull
    public AsynchronousTask<String> imageVirtualMachine(@Nonnull String vmId, @Nonnull String name, @Nonnull String description) throws CloudException, InternalException {
        final AsynchronousTask task = new AsynchronousTask();
        final String fvmId = vmId;
        final String fname = name;
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    ServiceInstance service = Template.this.getServiceInstance();
                    VirtualMachine vm = Template.this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(service, fvmId);
                    if (vm == null) {
                        throw new CloudException("No such virtual machine for imaging: " + fvmId);
                    }
                    MachineImage img = Template.this.toMachineImage(Template.this.provider.getComputeServices().getVirtualMachineSupport().clone(service, vm, fname, true));
                    if (img == null) {
                        throw new CloudException("Failed to identify newly created template");
                    }
                    task.completeWithResult((Object)img.getProviderMachineImageId());
                }
                catch (Throwable t) {
                    task.complete(t);
                }
            }
        };
        t.setName("Image VM " + vmId);
        t.setDaemon(false);
        t.start();
        return task;
    }

    @Nonnull
    public AsynchronousTask<String> imageVirtualMachineToStorage(@Nonnull String vmId, @Nonnull String name, @Nonnull String description, @Nonnull String directory) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Not supported");
    }

    @Nonnull
    public String installImageFromUpload(@Nonnull MachineImageFormat format, @Nonnull InputStream imageStream) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Not supported");
    }

    public boolean isImageSharedWithPublic(@Nonnull String machineImageId) throws CloudException, InternalException {
        return false;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public Iterable<MachineImage> listMachineImagesOwnedBy(@Nullable String accountId) throws CloudException, InternalException {
        if (accountId == null) {
            return Collections.emptyList();
        }
        if (accountId.equals(this.getContext().getAccountNumber())) {
            return this.listMachineImages();
        }
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<MachineImageFormat> listSupportedFormats() throws CloudException, InternalException {
        return Collections.singletonList(MachineImageFormat.VMDK);
    }

    @Nonnull
    public String registerMachineImage(@Nonnull String atStorageLocation) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Not supported");
    }

    @Nonnull
    public Iterable<MachineImage> searchMachineImages(@Nullable String keyword, @Nullable Platform platform, @Nullable Architecture architecture) throws CloudException, InternalException {
        ArrayList<MachineImage> matches = new ArrayList<MachineImage>();
        for (MachineImage image : this.listMachineImages()) {
            if (architecture != null && !architecture.equals((Object)image.getArchitecture())) continue;
            if (platform != null && !platform.equals((Object)Platform.UNKNOWN)) {
                Platform mine = image.getPlatform();
                if (platform.isWindows() && !mine.isWindows() || platform.isUnix() && !mine.isUnix() || platform.isBsd() && !mine.isBsd() || platform.isLinux() && !mine.isLinux() || (!platform.equals((Object)Platform.UNIX) ? !platform.equals((Object)mine) : !mine.isUnix())) continue;
            }
            if (keyword != null && !keyword.equals("")) {
                keyword = keyword.toLowerCase();
                if (!image.getProviderMachineImageId().toLowerCase().contains(keyword) && !image.getName().toLowerCase().contains(keyword) && !image.getDescription().toLowerCase().contains(keyword)) continue;
            }
            matches.add(image);
        }
        return matches;
    }

    public boolean supportsCustomImages() {
        return true;
    }

    public boolean supportsImageSharing() {
        return false;
    }

    public boolean supportsImageSharingWithPublic() {
        return false;
    }

    @Nonnull
    public String transfer(@Nonnull CloudProvider fromCloud, @Nonnull String machineImageId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Not supported");
    }
}

