/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.danilopianini.lang.LangUtils;

public final class GUIUtilities {
    public static void alertMessage(final String title, final String content) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, content, title, 1);
            }
        });
    }

    public static void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    public static void displayInCenterOfScreen(final Component f) {
        final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                f.setLocation((int)(screenSize.getWidth() - (double)f.getWidth()) / 2, (int)(screenSize.getHeight() - (double)f.getHeight()) / 2);
                f.setVisible(true);
            }
        });
    }

    public static void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }

    public static void errorMessage(Throwable e) {
        GUIUtilities.errorMessage(e, true);
    }

    public static void errorMessage(final Throwable e, boolean stackTrace) {
        final String s = stackTrace ? LangUtils.stackTraceToString(e) : "";
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, e.getMessage() + "\n" + s, "Error! Exception: " + e.toString(), 0);
            }
        });
    }

    public static ImageIcon loadScaledImage(String path, int w, int h) {
        URL resLoaded = GUIUtilities.class.getResource(path);
        if (resLoaded == null) {
            return null;
        }
        ImageIcon loaded = new ImageIcon(resLoaded);
        Image scaled = loaded.getImage().getScaledInstance(w, h, 4);
        return new ImageIcon(scaled);
    }

    public static void packAndDisplayInCenterOfScreen(Window f) {
        f.pack();
        GUIUtilities.displayInCenterOfScreen(f);
    }

    public static void saveComponentAsImage(String path, Component target, String format) throws IOException {
        JFrame win = (JFrame)SwingUtilities.getWindowAncestor(target);
        Dimension size = win.getSize();
        BufferedImage image = (BufferedImage)win.createImage(size.width, size.height);
        Graphics g = image.getGraphics();
        win.paint(g);
        g.dispose();
        ImageIO.write((RenderedImage)image, format, new File(path));
    }

    public static void setDefaultIcon(JFrame window, String imagepath) {
        window.setIconImage(Toolkit.getDefaultToolkit().getImage(imagepath));
    }

    public static void warningMessage(final String title, final String content) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, title, content, 2);
            }
        });
    }

    public static GraphicsDevice[] getGraphicDevices() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
    }

    private GUIUtilities() {
    }
}

