/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.lang.util;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class FasterString
implements Cloneable,
Serializable,
Comparable<FasterString>,
CharSequence {
    private static final long serialVersionUID = -3490623928660729120L;
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final HashFunction HASHF = Hashing.murmur3_128();
    private static final byte ENCODING_BASE = 36;
    private String base;
    @SuppressFBWarnings(justification="This hash is recomputed if needed after de-serialization.")
    private transient HashCode hash;
    private long hash64bit;
    private int hash32bit;
    private final String s;

    public FasterString(FasterString string) {
        this.s = string.s;
        this.hash64bit = string.hash64bit;
        this.hash32bit = string.hash32bit;
    }

    public FasterString(String string) {
        Objects.requireNonNull(string);
        this.s = string;
    }

    @Override
    public char charAt(int index) {
        return this.s.charAt(index);
    }

    public FasterString clone() {
        return this;
    }

    @Override
    public int compareTo(FasterString o) {
        return this.s.compareTo(o.s);
    }

    private void computeHashes() {
        this.hash = HASHF.hashBytes(this.s.getBytes(CHARSET));
        this.hash32bit = this.hash.asInt();
        this.hash64bit = this.hash.asLong();
    }

    public boolean equals(FasterString fs) {
        return this.hashCode() == fs.hashCode() && this.s.length() == fs.s.length() && this.hash64bit == fs.hash64bit && this.hash.equals((Object)fs.hash);
    }

    public boolean equals(Object o) {
        return o instanceof FasterString && this.equals((FasterString)o);
    }

    public long hash64() {
        if (this.hash == null) {
            this.computeHashes();
        }
        return this.hash64bit;
    }

    public int hashCode() {
        if (this.hash == null) {
            this.computeHashes();
        }
        return this.hash32bit;
    }

    public String hashToString() {
        if (this.base == null) {
            int h32 = this.hashCode() > 0 ? this.hash32bit : -(this.hash32bit + 1);
            long h64 = this.hash64bit > 0L ? this.hash64bit : -(this.hash64bit + 1L);
            this.base = Integer.toString(h32, 36) + Long.toString(h64, 36);
        }
        return this.base;
    }

    @Override
    public int length() {
        return this.s.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.s.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.s;
    }
}

