/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.lang;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class QuadTree<E>
implements Serializable {
    private static final long serialVersionUID = -8765593946059102012L;
    private QuadTree<E> botLeft;
    private QuadTree<E> botRight;
    private final Rectangle2D bounds = new Rectangle2D.Double();
    private final List<QuadTreeEntry<E>> elements;
    private final int elems;
    private final double maxX;
    private final double maxY;
    private final double minX;
    private final double minY;
    private QuadTree<E> topLeft;
    private QuadTree<E> topRight;

    public QuadTree(double x, double y, double mx, double my, int elemPerQuad) {
        this.minX = x;
        this.maxX = mx;
        this.minY = y;
        this.maxY = my;
        this.bounds.setFrameFromDiagonal(this.minX, this.minY, this.maxX, this.maxY);
        this.elements = new ArrayList<QuadTreeEntry<E>>(elemPerQuad);
        this.elems = elemPerQuad;
    }

    private boolean contains(double x, double y) {
        return y >= this.minY && y <= this.maxY && x >= this.minX && x <= this.maxX;
    }

    public boolean delete(E e, double x, double y) {
        if (!this.contains(x, y)) {
            return false;
        }
        if (this.remove(e, x, y)) {
            return true;
        }
        if (this.topRight.delete(e, x, y)) {
            return true;
        }
        if (this.topLeft.delete(e, x, y)) {
            return true;
        }
        if (this.botRight.delete(e, x, y)) {
            return true;
        }
        return this.botLeft.delete(e, x, y);
    }

    private boolean hasChildren() {
        return this.topLeft != null;
    }

    public boolean insert(E e, double x, double y) {
        return this.insert(new QuadTreeEntry<E>(e, x, y));
    }

    private boolean insert(QuadTreeEntry<E> e) {
        if (!this.contains(((QuadTreeEntry)e).x, ((QuadTreeEntry)e).y)) {
            return false;
        }
        if (this.set(e)) {
            return true;
        }
        this.subdivide();
        if (super.insert(e)) {
            return true;
        }
        if (super.insert(e)) {
            return true;
        }
        if (super.insert(e)) {
            return true;
        }
        if (super.insert(e)) {
            return true;
        }
        this.elements.add(e);
        return true;
    }

    public int getMaxElementsNumber() {
        return this.elems;
    }

    public boolean move(E e, double sx, double sy, double fx, double fy) {
        if (sx == fx && sy == fy) {
            return true;
        }
        if (!this.contains(sx, sy)) {
            return false;
        }
        QuadTree<E> currentContainer = this.searchForEntry(e, sx, sy);
        int pos = super.searchAtThisLevel(e, sx, sy);
        QuadTreeEntry<E> entry = currentContainer.elements.get(pos);
        ((QuadTreeEntry)entry).x = fx;
        ((QuadTreeEntry)entry).y = fy;
        if (!super.contains(fx, fy)) {
            currentContainer.elements.remove(pos);
            this.insert(entry);
        }
        return true;
    }

    public List<E> query(Rectangle2D range) {
        ArrayList result = new ArrayList();
        this.query(range, result);
        return result;
    }

    private void query(Rectangle2D range, List<E> results) {
        if (this.bounds.intersects(range)) {
            for (QuadTreeEntry<E> entry : this.elements) {
                if (!range.contains(((QuadTreeEntry)entry).x, ((QuadTreeEntry)entry).y)) continue;
                results.add(((QuadTreeEntry)entry).element);
            }
            if (this.hasChildren()) {
                super.query(range, results);
                super.query(range, results);
                super.query(range, results);
                super.query(range, results);
            }
        }
    }

    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
    private boolean remove(E e, double x, double y) {
        for (int i = 0; i < this.elements.size(); ++i) {
            QuadTreeEntry<E> entry = this.elements.get(i);
            if (((QuadTreeEntry)entry).x != x || ((QuadTreeEntry)entry).y != y || !((QuadTreeEntry)entry).element.equals(e)) continue;
            this.elements.remove(i);
            return true;
        }
        return false;
    }

    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
    private int searchAtThisLevel(E e, double x, double y) {
        for (int i = 0; i < this.elements.size(); ++i) {
            QuadTreeEntry<E> entry = this.elements.get(i);
            if (((QuadTreeEntry)entry).x != x || ((QuadTreeEntry)entry).y != y || !((QuadTreeEntry)entry).element.equals(e)) continue;
            return i;
        }
        return -1;
    }

    private QuadTree<E> searchForEntry(E e, double sx, double sy) {
        if (!this.contains(sx, sy)) {
            return null;
        }
        int index = this.searchAtThisLevel(e, sx, sy);
        if (index >= 0) {
            return this;
        }
        if (this.hasChildren()) {
            QuadTree<E> result = super.searchForEntry(e, sx, sy);
            if (result == null && (result = super.searchForEntry(e, sx, sy)) == null && (result = super.searchForEntry(e, sx, sy)) == null) {
                result = super.searchForEntry(e, sx, sy);
            }
            return result;
        }
        return null;
    }

    private boolean set(QuadTreeEntry<E> e) {
        if (this.elements.size() >= this.elems) {
            return false;
        }
        this.elements.add(e);
        return true;
    }

    protected boolean subdivide() {
        if (this.hasChildren()) {
            return false;
        }
        double cx = this.bounds.getCenterX();
        double cy = this.bounds.getCenterY();
        this.topLeft = new QuadTree<E>(this.minX, cy, cx, this.maxY, this.getMaxElementsNumber());
        this.topRight = new QuadTree<E>(cx, cy, this.maxX, this.maxY, this.getMaxElementsNumber());
        this.botLeft = new QuadTree<E>(this.minX, this.minY, cx, cy, this.getMaxElementsNumber());
        this.botRight = new QuadTree<E>(cx, this.minY, this.maxX, cy, this.getMaxElementsNumber());
        return true;
    }

    public String toString() {
        return this.bounds.toString() + ' ' + this.elements.toString();
    }

    private static class QuadTreeEntry<E>
    implements Serializable {
        private static final long serialVersionUID = 9021533648086596986L;
        private final E element;
        private double x;
        private double y;

        QuadTreeEntry(E el, double xp, double yp) {
            this.element = el;
            this.x = xp;
            this.y = yp;
        }

        public String toString() {
            return this.element.toString();
        }
    }
}

