/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.lang;

public final class MathUtils {
    public static final double DOUBLE_EQUALITY_EPSILON = 1.0E-11;

    private MathUtils() {
    }

    public static boolean fuzzyEquals(double a, double b) {
        return Math.abs(a - b) <= 1.0E-11 * Math.max(Math.abs(a), Math.abs(b));
    }

    public static boolean fuzzyGreaterEquals(double a, double b) {
        return a >= b || MathUtils.fuzzyEquals(a, b);
    }

    public static double closestTo(double val, double v1, double v2) {
        if (Math.abs(v1 - val) < Math.abs(v2 - val)) {
            return v1;
        }
        return v2;
    }
}

