/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.lang;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public final class ArrayUtils {
    private ArrayUtils() {
    }

    public static <T> List<T> cloneList(List<T> toClone) {
        ArrayList<T> res = new ArrayList<T>(toClone.size());
        for (T element : toClone) {
            res.add(element);
        }
        return res;
    }

    public static <T> List<T> differences(List<T> a, List<T> b) {
        List<T> shorter = a.size() > b.size() ? b : a;
        List<T> longest = a.size() > b.size() ? a : b;
        List<T> clone = ArrayUtils.cloneList(shorter);
        ArrayList<T> res = new ArrayList<T>(shorter.size());
        for (T o : shorter) {
            if (b.contains(o)) {
                clone.remove(o);
                continue;
            }
            res.add(o);
        }
        for (T o : longest) {
            if (clone.contains(o)) continue;
            res.add(o);
        }
        return res;
    }

    public static String arrayToString(Object[] a, String separator) {
        StringBuilder result = new StringBuilder("[");
        if (a.length > 0) {
            result.append(a[0]);
            for (int i = 1; i < a.length; ++i) {
                result.append(separator);
                result.append(a[i]);
            }
        }
        result.append(']');
        return result.toString();
    }

    public static <T> boolean contains(T[] list, T element) {
        for (T el : list) {
            if (!element.equals(el)) continue;
            return true;
        }
        return false;
    }

    public static byte[] toByteArray(double value) {
        byte[] bytes = new byte[8];
        ByteBuffer.wrap(bytes).putDouble(value);
        return bytes;
    }
}

