/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.io;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import org.danilopianini.concurrency.AbstractService;

public abstract class AbstractFileSystemWatcher
extends AbstractService {
    private final Path path;
    private final WatchService watcher = FileSystems.getDefault().newWatchService();

    public AbstractFileSystemWatcher(String dir) throws IOException {
        this.path = FileSystems.getDefault().getPath(dir, new String[0]);
        this.path.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
    }

    protected abstract void created(Path var1);

    protected abstract void deleted(Path var1);

    public Path getPath() {
        return this.path;
    }

    protected abstract void modified(Path var1);

    public abstract void overflow();

    @Override
    public void run() {
        while (this.isAlive()) {
            try {
                WatchKey k = this.watcher.take();
                for (WatchEvent<Path> watchEvent : k.pollEvents()) {
                    WatchEvent.Kind<?> kind = watchEvent.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) {
                        this.overflow();
                    }
                    WatchEvent<Path> event = watchEvent;
                    Path filename = (Path)event.context();
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        this.created(filename);
                        continue;
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                        this.deleted(filename);
                        continue;
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                        this.modified(filename);
                        continue;
                    }
                    this.unknown(event);
                }
                if (k.reset()) continue;
                this.stopService();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void stopService() {
        this.setAlive(false);
        this.interrupt();
    }

    protected abstract void unknown(WatchEvent<Path> var1);
}

