/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.concurrency;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.danilopianini.concurrency.AbstractService;

public class ThreadManager {
    private final ExecutorService cached = Executors.newCachedThreadPool();
    private final ExecutorService fixed;

    public ThreadManager() {
        this.fixed = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    }

    public ThreadManager(int cores) {
        this.fixed = Executors.newFixedThreadPool(cores);
    }

    public Future<?> addService(AbstractService thread) {
        return this.cached.submit(thread);
    }

    public void closeAndWait(long timeout) {
        List<Runnable> services = this.cached.shutdownNow();
        for (Runnable service : services) {
            ((AbstractService)service).stopService();
        }
        this.fixed.shutdown();
        try {
            long elapsed = System.currentTimeMillis();
            this.fixed.awaitTermination(timeout, TimeUnit.MILLISECONDS);
            this.cached.awaitTermination(timeout + (elapsed -= System.currentTimeMillis()), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public <K> Future<K> execute(Callable<K> thread) {
        return this.fixed.submit(thread);
    }

    @Deprecated
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public void execute(final Object obj, String method, final Object[] args) throws NoSuchMethodException {
        Class[] classes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            classes[i] = args[i].getClass();
        }
        final Method m = obj.getClass().getMethod(method, classes);
        this.fixed.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    m.invoke(obj, args);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public Future<?> execute(Runnable thread) {
        return this.fixed.submit(thread);
    }
}

