/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.util;

import com.google.common.hash.Hashing;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.danilopianini.util.SpatialIndex;

public final class FlexibleQuadTree<E>
implements SpatialIndex<E> {
    public static final int DEFAULT_CAPACITY = 10;
    private static final long serialVersionUID = 0L;
    private final Map<Child, FlexibleQuadTree<E>> children;
    private final Deque<QuadTreeEntry<E>> elements;
    private final int maxElements;
    private Rectangle2D bounds;
    private FlexibleQuadTree<E> parent;
    private FlexibleQuadTree<E> root;

    public FlexibleQuadTree() {
        this(10);
    }

    private FlexibleQuadTree(double minx, double maxx, double miny, double maxy, int elemPerQuad, FlexibleQuadTree<E> rootNode, FlexibleQuadTree<E> parentNode) {
        this(elemPerQuad, rootNode, parentNode);
        this.bounds = new Rectangle2D(minx, miny, maxx, maxy);
    }

    private FlexibleQuadTree(int elemPerQuad, FlexibleQuadTree<E> rootNode, FlexibleQuadTree<E> parentNode) {
        if (elemPerQuad < 2) {
            throw new IllegalArgumentException("At least two elements per quadtree are required for this index to work properly");
        }
        this.elements = new ArrayDeque<QuadTreeEntry<E>>(10);
        this.children = new EnumMap<Child, FlexibleQuadTree<E>>(Child.class);
        this.maxElements = elemPerQuad;
        this.parent = parentNode;
        this.root = rootNode == null ? this : rootNode;
    }

    public FlexibleQuadTree(int elemPerQuad) {
        this(elemPerQuad, null, null);
    }

    private double centerX() {
        return this.bounds.getCenterX();
    }

    private double centerY() {
        return this.bounds.getCenterY();
    }

    private boolean contains(double x, double y) {
        return this.bounds == null || this.bounds.contains(x, y);
    }

    private FlexibleQuadTree<E> create(double minx, double maxx, double miny, double maxy, FlexibleQuadTree<E> father) {
        return new FlexibleQuadTree<E>(minx, maxx, miny, maxy, this.getMaxElementsNumber(), this.root, father);
    }

    private void createChildIfAbsent(Child c) {
        this.children.putIfAbsent(c, this.create(this.minX(c), this.maxX(c), this.minY(c), this.maxY(c), this));
    }

    private void createParent(double x, double y) {
        if (x < this.centerX()) {
            double minx = 2.0 * this.minX() - this.maxX();
            if (y < this.centerY()) {
                this.root = this.create(minx, this.maxX(), 2.0 * this.minY() - this.maxY(), this.maxY(), null);
                super.setChild(Child.TR, this);
            } else {
                this.root = this.create(minx, this.maxX(), this.minY(), 2.0 * this.maxY() - this.minY(), null);
                super.setChild(Child.BR, this);
            }
        } else {
            double maxx = 2.0 * this.maxX() - this.minX();
            if (y < this.centerY()) {
                this.root = this.create(this.minX(), maxx, 2.0 * this.minY() - this.maxY(), this.maxY(), null);
                super.setChild(Child.TL, this);
            } else {
                this.root = this.create(this.minX(), maxx, this.minY(), 2.0 * this.maxY() - this.minY(), null);
                super.setChild(Child.BL, this);
            }
        }
        this.root.root = this.root;
        super.subdivide();
    }

    @Override
    public int getDimensions() {
        return 2;
    }

    public int getMaxElementsNumber() {
        return this.maxElements;
    }

    private boolean hasSpace() {
        return this.elements.size() < this.maxElements;
    }

    @Override
    public void insert(E e, double ... pos) {
        assert (pos.length == 2);
        this.insert(e, pos[0], pos[1]);
    }

    public void insert(E e, double x, double y) {
        if (this.bounds == null) {
            if (this.hasSpace()) {
                this.insertNode(e, x, y);
                return;
            }
            double minx = Double.POSITIVE_INFINITY;
            double miny = Double.POSITIVE_INFINITY;
            double maxx = Double.NEGATIVE_INFINITY;
            double maxy = Double.NEGATIVE_INFINITY;
            for (QuadTreeEntry<E> element : this.elements) {
                minx = Math.min(minx, ((QuadTreeEntry)element).x);
                miny = Math.min(miny, ((QuadTreeEntry)element).y);
                maxx = Math.max(maxx, ((QuadTreeEntry)element).x);
                maxy = Math.max(maxy, ((QuadTreeEntry)element).y);
            }
            assert (Double.isFinite(minx));
            assert (Double.isFinite(maxx));
            assert (Double.isFinite(miny));
            assert (Double.isFinite(maxy));
            this.bounds = new Rectangle2D(Math.floor(Math.nextDown(minx)), Math.floor(Math.nextDown(miny)), Math.ceil(Math.nextUp(maxx)), Math.ceil(Math.nextUp(maxy)));
        }
        while (!super.contains(x, y)) {
            super.createParent(x, y);
            this.root = this.root.root;
        }
        super.insertHere(e, x, y);
    }

    private void insertHere(E e, double x, double y) {
        if (this.hasSpace()) {
            this.insertNode(e, x, y);
        } else {
            if (this.children.isEmpty()) {
                this.subdivide();
            }
            super.insertHere(e, x, y);
        }
    }

    private void insertNode(@Nonnull E e, double x, double y) {
        assert (this.elements.size() < this.maxElements) : "Bug in " + this.getClass() + ". Forced insertion over the container size.";
        this.elements.push(new QuadTreeEntry<E>(e, x, y));
    }

    private double maxX() {
        return this.bounds.getMaxX();
    }

    private double maxX(Child c) {
        switch (c) {
            case TR: 
            case BR: {
                return this.maxX();
            }
            case BL: 
            case TL: {
                return this.centerX();
            }
        }
        throw new IllegalStateException();
    }

    private double maxY() {
        return this.bounds.getMaxY();
    }

    private double maxY(Child c) {
        switch (c) {
            case BR: 
            case BL: {
                return this.centerY();
            }
            case TR: 
            case TL: {
                return this.maxY();
            }
        }
        throw new IllegalStateException();
    }

    private double minX() {
        return this.bounds.getMinX();
    }

    private double minX(Child c) {
        switch (c) {
            case TR: 
            case BR: {
                return this.centerX();
            }
            case BL: 
            case TL: {
                return this.minX();
            }
        }
        throw new IllegalStateException();
    }

    private double minY() {
        return this.bounds.getMinY();
    }

    private double minY(Child c) {
        switch (c) {
            case BR: 
            case BL: {
                return this.minY();
            }
            case TR: 
            case TL: {
                return this.centerY();
            }
        }
        throw new IllegalStateException();
    }

    public boolean move(E e, double sx, double sy, double fx, double fy) {
        return this.moveFromNode(this.root, e, sx, sy, fx, fy);
    }

    @Override
    public boolean move(E e, double[] start, double[] end) {
        assert (start.length == 2);
        assert (end.length == 2);
        return this.move(e, start[0], start[1], end[0], end[1]);
    }

    private boolean moveFromNode(FlexibleQuadTree<E> root, E e, double sx, double sy, double fx, double fy) {
        QuadTreeEntry<E> toRemove = new QuadTreeEntry<E>(e, sx, sy);
        FlexibleQuadTree<E> cur = root;
        while (super.contains(sx, sy)) {
            if (cur.elements.remove(toRemove)) {
                if (super.contains(fx, fy)) {
                    super.insertNode(e, fx, fy);
                } else if (cur.parent == null || !super.contains(fx, fy) || !super.swapMostStatic(e, fx, fy)) {
                    this.insert(e, fx, fy);
                }
                return true;
            }
            if (cur.children.isEmpty()) {
                return false;
            }
            cur = super.selectChild(sx, sy);
        }
        return false;
    }

    public List<E> query(double x1, double y1, double x2, double y2) {
        ArrayList result = new ArrayList();
        super.query(Math.min(x1, x2), Math.min(y1, y2), Math.max(x1, x2), Math.max(y1, y2), result);
        return result;
    }

    private void query(double sx, double sy, double fx, double fy, List<E> results) {
        assert (this.bounds != null || this.children.isEmpty());
        if (this.bounds == null || this.bounds.intersects(sx, sy, fx, fy)) {
            for (QuadTreeEntry<E> quadTreeEntry : this.elements) {
                if (!quadTreeEntry.isIn(sx, sy, fx, fy)) continue;
                results.add(((QuadTreeEntry)quadTreeEntry).element);
            }
            for (FlexibleQuadTree flexibleQuadTree : this.children.values()) {
                flexibleQuadTree.query(sx, sy, fx, fy, results);
            }
        }
    }

    @Override
    public List<E> query(double[] ... space) {
        if (space.length != 2 || space[0].length != 2 || space[1].length != 2) {
            throw new IllegalArgumentException();
        }
        return this.query(space[0][0], space[0][1], space[1][0], space[1][1]);
    }

    @Override
    public boolean remove(E e, double ... pos) {
        assert (pos.length == 2);
        return this.remove(e, pos[0], pos[1]);
    }

    public boolean remove(E e, double x, double y) {
        return super.removeHere(e, x, y);
    }

    private boolean removeHere(E e, double x, double y) {
        if (this.contains(x, y)) {
            return this.elements.remove(new QuadTreeEntry<E>(e, x, y)) || this.removeInChildren(e, x, y);
        }
        return false;
    }

    private boolean removeInChildren(E e, double x, double y) {
        return this.children.values().stream().anyMatch(c -> c.removeHere(e, x, y));
    }

    private FlexibleQuadTree<E> selectChild(double x, double y) {
        assert (!this.children.isEmpty());
        if (x < this.centerX()) {
            return y < this.centerY() ? this.children.get((Object)Child.BL) : this.children.get((Object)Child.TL);
        }
        return y < this.centerY() ? this.children.get((Object)Child.BR) : this.children.get((Object)Child.TR);
    }

    private void setChild(Child c, FlexibleQuadTree<E> child) {
        if (this.children.put(c, child) != null) {
            throw new IllegalStateException();
        }
        child.parent = this;
    }

    private void subdivide() {
        for (Child c : Child.values()) {
            this.createChildIfAbsent(c);
        }
    }

    private boolean swapMostStatic(E e, double fx, double fy) {
        assert (this.parent != null) : "Tried to swap on a null parent.";
        Iterator<QuadTreeEntry<E>> iterator = this.parent.elements.descendingIterator();
        while (iterator.hasNext()) {
            QuadTreeEntry<E> target = iterator.next();
            if (!this.contains(((QuadTreeEntry)target).x, ((QuadTreeEntry)target).y)) continue;
            iterator.remove();
            this.elements.push(target);
            super.insertNode(e, fx, fy);
            return true;
        }
        return false;
    }

    public String toString() {
        return (this.bounds == null ? "Unbounded" : this.bounds.toString()) + ":" + this.elements.toString();
    }

    private static class Rectangle2D
    implements Serializable {
        private static final long serialVersionUID = -7890062202005580979L;
        private final double minx;
        private final double miny;
        private final double maxx;
        private final double maxy;

        Rectangle2D(double sx, double sy, double fx, double fy) {
            this.minx = Math.min(sx, fx);
            this.miny = Math.min(sy, fy);
            this.maxx = Math.max(sx, fx);
            this.maxy = Math.max(sy, fy);
        }

        public boolean contains(double x, double y) {
            return x >= this.minx && y >= this.miny && x < this.maxx && y < this.maxy;
        }

        public double getCenterX() {
            return this.minx + (this.maxx - this.minx) / 2.0;
        }

        public double getCenterY() {
            return this.miny + (this.maxy - this.miny) / 2.0;
        }

        public double getMaxX() {
            return this.maxx;
        }

        public double getMaxY() {
            return this.maxy;
        }

        public double getMinX() {
            return this.minx;
        }

        public double getMinY() {
            return this.miny;
        }

        public boolean intersects(double sx, double sy, double fx, double fy) {
            return fx >= this.minx && fy >= this.miny && sx < this.maxx && sy < this.maxy;
        }

        public String toString() {
            return "[" + this.minx + "," + this.miny + " - " + this.maxx + "," + this.maxy + "]";
        }
    }

    private static class QuadTreeEntry<E>
    implements Serializable {
        private static final long serialVersionUID = 9021533648086596986L;
        private final E element;
        private final double x;
        private final double y;

        QuadTreeEntry(E el, double xp, double yp) {
            this.element = el;
            this.x = xp;
            this.y = yp;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof QuadTreeEntry) {
                QuadTreeEntry e = (QuadTreeEntry)obj;
                if (this.samePosition(e)) {
                    return Objects.equals(this.element, e.element);
                }
                return false;
            }
            return false;
        }

        public int hashCode() {
            return Hashing.murmur3_32_fixed().newHasher().putDouble(this.x).putDouble(this.y).putInt(this.element.hashCode()).hash().asInt();
        }

        public boolean isIn(double sx, double sy, double fx, double fy) {
            return this.x >= sx && this.x < fx && this.y >= sy && this.y < fy;
        }

        public boolean samePosition(QuadTreeEntry<?> target) {
            return this.x == target.x && this.y == target.y;
        }

        public String toString() {
            return this.element.toString() + "@[" + this.x + ", " + this.y + "]";
        }
    }

    private static enum Child {
        TR,
        BR,
        BL,
        TL;

    }
}

