/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.css.speech.impl;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.RuleFactory;
import cz.vutbr.web.css.Selector;
import cz.vutbr.web.css.SupportedCSS;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermFunction;
import cz.vutbr.web.css.TermIdent;
import cz.vutbr.web.css.TermList;
import cz.vutbr.web.css.TermString;
import cz.vutbr.web.css.TermURI;
import cz.vutbr.web.csskit.RuleFactoryImpl;
import cz.vutbr.web.csskit.antlr.CSSParserFactory;
import cz.vutbr.web.domassign.DeclarationTransformer;
import cz.vutbr.web.domassign.SupportedCSS21;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.transform.URIResolver;
import org.daisy.braille.css.BrailleCSSParserFactory;
import org.daisy.common.file.URLs;
import org.daisy.common.transform.XMLTransformer;
import org.daisy.pipeline.css.CssCascader;
import org.daisy.pipeline.css.CssPreProcessor;
import org.daisy.pipeline.css.CssSerializer;
import org.daisy.pipeline.css.JStyleParserCssCascader;
import org.daisy.pipeline.css.Medium;
import org.daisy.pipeline.css.XsltProcessor;
import org.daisy.pipeline.css.speech.SpeechDeclarationTransformer;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

@Component(name="SpeechCssCascader", service={CssCascader.class})
public class SpeechCssCascader
implements CssCascader {
    private static final CSSParserFactory parserFactory = new BrailleCSSParserFactory();
    private static final RuleFactory ruleFactory = RuleFactoryImpl.getInstance();
    private static final SupportedCSS speechCSS = SupportedCSS21.getInstance();
    private static final DeclarationTransformer declarationTransformer = new SpeechDeclarationTransformer();
    private static final Set<String> speechCSSProperties = new HashSet<String>(Arrays.asList("voice-family", "stress", "richness", "cue", "cue-before", "cue-after", "pause", "pause-after", "pause-before", "azimuth", "volume", "speak", "play-during", "elevation", "speech-rate", "pitch", "pitch-range", "stress", "speak-punctuation", "speak-numeral", "speak-header"));
    private static final Logger logger = LoggerFactory.getLogger(SpeechCssCascader.class);

    @Override
    public boolean supportsMedium(Medium medium) {
        switch (medium.getType()) {
            case SPEECH: {
                return true;
            }
        }
        return false;
    }

    @Override
    public XMLTransformer newInstance(Medium medium, String userAndUserAgentStylesheets, URIResolver uriResolver, CssPreProcessor preProcessor, XsltProcessor xsltProcessor, QName attributeName, boolean multipleAttrs) {
        if (!multipleAttrs) {
            throw new UnsupportedOperationException("Cascading to single attribute per element not supported");
        }
        switch (medium.getType()) {
            case SPEECH: {
                return new Transformer(uriResolver, preProcessor, xsltProcessor, userAndUserAgentStylesheets, medium, attributeName);
            }
        }
        throw new IllegalArgumentException("medium not supported: " + medium);
    }

    private static class Transformer
    extends JStyleParserCssCascader {
        private final String attributePrefix;
        private final String attributeNamespaceURI;

        private Transformer(URIResolver resolver, CssPreProcessor preProcessor, XsltProcessor xsltProcessor, String userAndUserAgentStylesheets, Medium medium, QName attributeNamespace) {
            super(resolver, preProcessor, xsltProcessor, userAndUserAgentStylesheets, medium, null, parserFactory, ruleFactory, speechCSS, declarationTransformer);
            this.attributePrefix = attributeNamespace.getPrefix();
            this.attributeNamespaceURI = attributeNamespace.getNamespaceURI();
        }

        @Override
        protected Map<QName, String> serializeStyle(NodeData mainStyle, Map<Selector.PseudoElement, NodeData> pseudoStyles, Element context) {
            HashMap<QName, String> style = null;
            if (mainStyle != null) {
                for (String property : mainStyle.getPropertyNames()) {
                    String s;
                    if (!speechCSSProperties.contains(property)) continue;
                    Term v = mainStyle.getValue(property, false);
                    if (v == null || v.getValue() == null) {
                        CSSProperty prop = mainStyle.getProperty(property, false);
                        if (prop == null) continue;
                        s = prop.toString().replace('_', '-');
                    } else {
                        s = Transformer.serializeTerm(v);
                    }
                    if (style == null) {
                        style = new HashMap<QName, String>();
                    }
                    style.put(new QName(this.attributeNamespaceURI, property, this.attributePrefix), s);
                }
            }
            block4: for (Selector.PseudoElement pseudo : pseudoStyles.keySet()) {
                NodeData nd;
                if (!"::after".equals(pseudo.toString()) && !"::before".equals(pseudo.toString()) || (nd = pseudoStyles.get(pseudo)) == null) continue;
                for (String property : nd.getPropertyNames()) {
                    if ("content".equals(property)) {
                        switch ((CSSProperty.Content)nd.getProperty(property)) {
                            case list_values: {
                                StringBuilder value = new StringBuilder();
                                for (Term t : (TermList)nd.getValue(property, false)) {
                                    TermFunction f;
                                    if (t instanceof TermString) {
                                        value.append(t.getValue());
                                        continue;
                                    }
                                    if (t instanceof TermFunction && "attr".equals((f = (TermFunction)t).getFunctionName().toLowerCase()) && f.size() == 1 && f.get(0) instanceof TermIdent) {
                                        value.append(context.getAttribute((String)((TermIdent)f.get(0)).getValue()));
                                        continue;
                                    }
                                    logger.warn("Don't know how to speak content value " + t + " within ::" + pseudo.getName() + " pseudo-element");
                                    value = null;
                                    break;
                                }
                                if (value == null || value.length() <= 0) continue block4;
                                if (style == null) {
                                    style = new HashMap();
                                }
                                style.put(new QName(this.attributeNamespaceURI, pseudo.getName(), this.attributePrefix), value.toString());
                                continue block4;
                            }
                        }
                        continue block4;
                    }
                    if (!speechCSSProperties.contains(property)) continue;
                    logger.warn("Ignoring property '" + property + "' within ::" + pseudo.getName() + " pseudo-element");
                }
            }
            return style;
        }

        private static String serializeTerm(Term<?> term) {
            if (term instanceof TermString) {
                return (String)((TermString)term).getValue();
            }
            if (term instanceof TermURI) {
                TermURI termURI = (TermURI)term;
                URI uri = URLs.asURI((String)((String)termURI.getValue()));
                if (termURI.getBase() != null) {
                    uri = URLs.resolve((URI)URLs.asURI((URL)termURI.getBase()), (URI)uri);
                }
                return uri.toASCIIString();
            }
            if (term instanceof TermIdent) {
                return CssSerializer.toString(term).replace('_', '-');
            }
            return CssSerializer.toString(term, Transformer::serializeTerm);
        }

        @Override
        protected String serializeValue(Term<?> value) {
            throw new UnsupportedOperationException();
        }
    }
}

