/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.css.speech;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermList;
import cz.vutbr.web.css.TermPercent;
import cz.vutbr.web.css.TermTime;
import cz.vutbr.web.css.TermURI;
import cz.vutbr.web.domassign.DeclarationTransformer;
import java.util.Map;

public class SpeechDeclarationTransformer
extends DeclarationTransformer {
    public boolean parseDeclaration(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        String propertyName = d.getProperty().toLowerCase();
        if ("cue-before".equals(propertyName) || "cue-after".equals(propertyName)) {
            return this.genericTerm(TermURI.class, (Term)d.get(0), d.getProperty(), (CSSProperty)CSSProperty.Cue.uri, false, properties, values);
        }
        if (propertyName.startsWith("pause")) {
            Term term = (Term)d.get(0);
            if (!(term instanceof TermTime)) {
                return super.parseDeclaration(d, properties, values);
            }
            properties.put(propertyName, null);
            values.put(propertyName, term);
            return true;
        }
        if ("voice-family".equals(propertyName)) {
            if (d.size() == 0) {
                return false;
            }
            TermList list = tf.createList();
            for (Term t : d) {
                list.add((Object)t);
            }
            properties.put(d.getProperty(), (CSSProperty)CSSProperty.VoiceFamily.list_values);
            values.put(d.getProperty(), (Term<?>)list);
            return true;
        }
        if ("speech-rate".equals(propertyName)) {
            if (d.size() == 1 && d.get(0) instanceof TermPercent) {
                TermPercent p = (TermPercent)d.get(0);
                if (((Float)p.getValue()).floatValue() <= 0.0f) {
                    return false;
                }
                properties.put(d.getProperty(), (CSSProperty)CSSProperty.SpeechRate.number);
                values.put(d.getProperty(), (Term<?>)p);
                return true;
            }
            return super.parseDeclaration(d, properties, values);
        }
        return super.parseDeclaration(d, properties, values);
    }
}

