/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.css.sass.impl;

import com.google.common.collect.Iterables;
import com.google.common.io.CharStreams;
import cz.vutbr.web.css.NetworkProcessor;
import cz.vutbr.web.csskit.DefaultNetworkProcessor;
import cz.vutbr.web.csskit.antlr.CSSSource;
import cz.vutbr.web.csskit.antlr.CSSSourceReader;
import cz.vutbr.web.csskit.antlr.DefaultCSSSourceReader;
import cz.vutbr.web.domassign.GenericTreeWalker;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.daisy.common.file.URLs;
import org.daisy.pipeline.css.Medium;
import org.daisy.pipeline.css.sass.impl.SassDocumentationLexer;
import org.daisy.pipeline.css.sass.impl.SassDocumentationParser;
import org.daisy.pipeline.css.sass.impl.SassVariable;
import org.daisy.pipeline.datatypes.DatatypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SassAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger((String)SassAnalyzer.class.getName());
    private final Collection<Medium> media;
    private final CSSSourceReader cssReader;
    final DatatypeRegistry datatypes;

    public SassAnalyzer(Collection<Medium> media, final URIResolver uriResolver, DatatypeRegistry datatypes) {
        this.media = media;
        this.datatypes = datatypes;
        DefaultNetworkProcessor network = new DefaultNetworkProcessor(){

            public Reader fetch(URL url, Charset encoding, boolean forceEncoding, boolean assertEncoding) throws IOException {
                logger.debug("Fetching style sheet: " + url);
                if (uriResolver != null) {
                    Source resolved;
                    try {
                        resolved = uriResolver.resolve(URLs.asURI((URL)url).toASCIIString(), "");
                    }
                    catch (TransformerException e) {
                        throw new IOException(e);
                    }
                    if (resolved != null) {
                        if (resolved instanceof StreamSource) {
                            InputStreamReader r = this.detectEncodingAndSkipBOM(((StreamSource)resolved).getInputStream(), null, encoding, forceEncoding);
                            if (assertEncoding) {
                                if (encoding == null) {
                                    throw new IllegalArgumentException("encoding must not be null");
                                }
                                if (!encoding.equals(1.getEncoding((InputStreamReader)r))) {
                                    throw new IOException("Failed to read URL as " + encoding + ": " + url);
                                }
                            }
                            return r;
                        }
                        url = new URL(resolved.getSystemId());
                    }
                }
                return super.fetch(url, encoding, forceEncoding, assertEncoding);
            }
        };
        this.cssReader = new DefaultCSSSourceReader((NetworkProcessor)network){

            public boolean supportsMediaType(String mediaType, URL url) {
                if ("text/css".equals(mediaType) || "text/x-scss".equals(mediaType)) {
                    return true;
                }
                return mediaType == null && (url == null || url.toString().endsWith(".css") || url.toString().endsWith(".scss"));
            }

            public CSSSourceReader.CSSInputStream read(CSSSource source) throws IOException {
                if (source.type == CSSSource.SourceType.URL) {
                    URL url = (URL)source.source;
                    if (url != null && !url.toString().endsWith(".css") && !url.toString().endsWith(".scss")) {
                        try {
                            return this.read(new CSSSource(new URL(url.toString() + ".scss"), source.encoding, source.mediaType));
                        }
                        catch (IOException e) {
                            try {
                                return this.read(new CSSSource(new URL(url.toString() + ".css"), source.encoding, source.mediaType));
                            }
                            catch (IOException iOException) {
                                try {
                                    String fileName = url.toString();
                                    fileName = fileName.substring(fileName.lastIndexOf(47) + 1, fileName.length());
                                    return this.read(new CSSSource(URLs.asURL((URI)URLs.asURI((URL)url).resolve("_" + fileName + ".scss")), source.encoding, source.mediaType));
                                }
                                catch (IOException iOException2) {
                                    try {
                                        return this.read(new CSSSource(new URL(url.toString() + "/_index.scss"), source.encoding, source.mediaType));
                                    }
                                    catch (IOException iOException3) {
                                        throw e;
                                    }
                                }
                            }
                        }
                    }
                    if (uriResolver != null) {
                        try {
                            Source resolved = uriResolver.resolve(URLs.asURI((URL)url).toASCIIString(), "");
                            if (resolved != null) {
                                source = new CSSSource(new URL(resolved.getSystemId()), source.encoding, source.mediaType);
                            }
                        }
                        catch (TransformerException e) {
                            throw new IOException(e);
                        }
                    }
                }
                return super.read(source);
            }
        };
    }

    public Collection<SassVariable> getVariableDeclarations(Iterable<Source> userAndUserAgentStylesheets, Source sourceDocument) throws IOException {
        URI baseURI;
        String systemId;
        final ArrayList<CSSSource> stylesheets = new ArrayList<CSSSource>();
        for (Source s : userAndUserAgentStylesheets) {
            Reader r;
            URL base;
            systemId = s.getSystemId();
            if (systemId == null || "".equals(systemId)) {
                base = null;
            } else {
                baseURI = URLs.asURI((String)systemId);
                if (SassAnalyzer.isOpaque(baseURI) || !baseURI.isAbsolute()) {
                    throw new IllegalArgumentException("not an absolute hierarchical base URI: " + baseURI);
                }
                base = URLs.asURL((URI)baseURI);
            }
            if (s instanceof StreamSource) {
                StreamSource ss = (StreamSource)s;
                r = ss.getReader();
                if (r == null) {
                    r = new InputStreamReader(ss.getInputStream(), StandardCharsets.UTF_8);
                }
                stylesheets.add(new CSSSource(CharStreams.toString((Readable)r), null, base, 0, 0));
                continue;
            }
            if (base == null) {
                InputSource is = SAXSource.sourceToInputSource(s);
                if (is == null) {
                    throw new IllegalArgumentException("unexpected source");
                }
                r = is.getCharacterStream();
                if (r == null) {
                    InputStream bs = is.getByteStream();
                    if (bs != null) {
                        r = new InputStreamReader(bs, StandardCharsets.UTF_8);
                    } else {
                        throw new IllegalArgumentException("unexpected source: no content and no base URI");
                    }
                }
                stylesheets.add(new CSSSource(CharStreams.toString((Readable)r), null, base, 0, 0));
                continue;
            }
            stylesheets.add(new CSSSource(base, StandardCharsets.UTF_8, null));
        }
        if (sourceDocument != null) {
            try {
                URL base;
                Document doc;
                if (sourceDocument instanceof DOMSource && ((DOMSource)sourceDocument).getNode() instanceof Document) {
                    doc = (Document)((DOMSource)sourceDocument).getNode();
                    URI baseURI2 = URLs.asURI((String)doc.getBaseURI());
                    if (SassAnalyzer.isOpaque(baseURI2) || !baseURI2.isAbsolute()) {
                        throw new IllegalArgumentException("not an absolute hierarchical base URI: " + baseURI2);
                    }
                    base = URLs.asURL((URI)baseURI2);
                } else {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setNamespaceAware(true);
                    doc = factory.newDocumentBuilder().parse(SAXSource.sourceToInputSource(sourceDocument));
                    systemId = sourceDocument.getSystemId();
                    if (systemId == null || "".equals(systemId)) {
                        base = null;
                    } else {
                        baseURI = URLs.asURI((String)systemId);
                        if (SassAnalyzer.isOpaque(baseURI) || !baseURI.isAbsolute()) {
                            throw new IllegalArgumentException("not an absolute hierarchical base URI: " + baseURI);
                        }
                        base = URLs.asURL((URI)baseURI);
                    }
                }
                new Traversal(doc){

                    @Override
                    protected void processElement(Element e) {
                        Attr href;
                        Attr rel;
                        if ("style".equalsIgnoreCase(e.getNodeName())) {
                            Attr q = e.getAttributeNode("media");
                            if (Iterables.any((Iterable)SassAnalyzer.this.media, m -> m.matches(q != null ? q.getValue() : null))) {
                                String mediaType;
                                Attr type = e.getAttributeNode("type");
                                String string = mediaType = type != null ? type.getValue().toLowerCase() : null;
                                if (SassAnalyzer.this.cssReader.supportsMediaType(mediaType, null)) {
                                    stylesheets.add(new CSSSource(SassAnalyzer.extractElementText(e), mediaType, base, -1, -1));
                                }
                            }
                        } else if ("link".equalsIgnoreCase(e.getNodeName()) && (rel = e.getAttributeNode("rel")) != null && rel.getValue().toLowerCase().contains("stylesheet") && (href = e.getAttributeNode("href")) != null) {
                            Attr q = e.getAttributeNode("media");
                            if (Iterables.any((Iterable)SassAnalyzer.this.media, m -> m.matches(q != null ? q.getValue() : null))) {
                                String mediaType;
                                URL url;
                                try {
                                    URI uri = URLs.asURI((String)href.getValue());
                                    if (base != null) {
                                        uri = URLs.resolve((URI)URLs.asURI((URL)base), (URI)uri);
                                    }
                                    url = URLs.asURL((URI)uri);
                                }
                                catch (RuntimeException ex) {
                                    throw new UncheckedIOException(new IOException(ex));
                                }
                                Attr type = e.getAttributeNode("type");
                                String string = mediaType = type != null ? type.getValue().toLowerCase() : null;
                                if (SassAnalyzer.this.cssReader.supportsMediaType(mediaType, url)) {
                                    stylesheets.add(new CSSSource(url, null, mediaType));
                                }
                            }
                        }
                    }
                }.traverse();
            }
            catch (UncheckedIOException e) {
                throw e.getCause();
            }
            catch (ParserConfigurationException | SAXException e) {
                throw new IOException(e);
            }
        }
        return this.getVariableDeclarations(stylesheets.toArray(new CSSSource[stylesheets.size()]));
    }

    Collection<SassVariable> getVariableDeclarations(CSSSource ... stylesheets) throws IOException {
        ArrayList<SassVariable> vars = new ArrayList<SassVariable>();
        try {
            for (CSSSource source : stylesheets) {
                CSSSourceReader.CSSInputStream s = this.cssReader.read(source);
                ANTLRReaderStream input = new ANTLRReaderStream(s.stream);
                SassDocumentationLexer lexer = new SassDocumentationLexer((CharStream)input);
                CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
                SassDocumentationParser parser = new SassDocumentationParser((TokenStream)tokens).init("text/x-scss".equals(source.mediaType) || s.base != null && s.base.toString().endsWith(".scss"), s.base != null ? URLs.asURI((URL)s.base) : null, this.media, this);
                vars.addAll(parser.variables());
            }
        }
        catch (RecognitionException e) {
            throw new RuntimeException("Error happened while parsing the SCSS", e);
        }
        TreeSet<SassVariable> unique = new TreeSet<SassVariable>(Comparator.comparing(SassVariable::getName));
        Iterator i = vars.iterator();
        while (i.hasNext()) {
            SassVariable v = (SassVariable)i.next();
            if (v.isDefault() || unique.add(v)) continue;
            i.remove();
        }
        i = vars.iterator();
        while (i.hasNext()) {
            SassVariable v = (SassVariable)i.next();
            if (!v.isDefault() || unique.add(v)) continue;
            i.remove();
        }
        return vars;
    }

    private static String extractElementText(Element e) {
        StringBuilder s = new StringBuilder();
        NodeList children = e.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 3 || child.getNodeType() == 4) {
                s.append(((CharacterData)child).getData());
                continue;
            }
            if (child.getNodeType() != 8) continue;
            s.append("<!--").append(((CharacterData)child).getData()).append("-->");
        }
        return s.toString();
    }

    private static boolean isOpaque(URI uri) {
        if (uri.toString().startsWith("jar:file:")) {
            return uri.isAbsolute() && !uri.getSchemeSpecificPart().substring(5).startsWith("/");
        }
        return uri.isOpaque();
    }

    private static abstract class Traversal {
        private final TreeWalker walker;

        protected Traversal(Document doc) {
            this.walker = doc instanceof DocumentTraversal ? ((DocumentTraversal)((Object)doc)).createTreeWalker(doc.getDocumentElement(), 1, null, false) : new GenericTreeWalker((Node)doc.getDocumentElement(), 1);
        }

        protected abstract void processElement(Element var1);

        public void traverse() {
            Node checkpoint = null;
            Node current = this.walker.getCurrentNode();
            while (current != null) {
                checkpoint = this.walker.getCurrentNode();
                this.processElement((Element)current);
                this.walker.setCurrentNode(checkpoint);
                current = this.walker.nextNode();
            }
        }
    }
}

