/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.css.sass.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Optional;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.commons.text.StringEscapeUtils;
import org.daisy.pipeline.css.sass.impl.Comment;
import org.daisy.pipeline.css.sass.impl.DoxygenLexer;
import org.daisy.pipeline.css.sass.impl.DoxygenParser;
import org.w3c.dom.Element;

class DoxygenComment
extends Comment {
    final Optional<String> varName;
    final Optional<String> type;
    final Optional<String> brief;
    final String body;
    final Optional<Element> typeDef;

    DoxygenComment(String varName, String type, String brief, String body, Element typeDef, Comment comment) throws IllegalArgumentException {
        super(comment.text, comment.column);
        if (type != null && typeDef != null) {
            throw new IllegalArgumentException("Can not have both a type specified in a @var command, and a <type> command");
        }
        this.varName = Optional.ofNullable(varName);
        this.type = Optional.ofNullable(type);
        this.brief = Optional.ofNullable(brief);
        this.body = DoxygenComment.processMarkdown(body);
        this.typeDef = Optional.ofNullable(typeDef);
    }

    static DoxygenComment of(Comment comment) throws IllegalArgumentException {
        try {
            if (!comment.text.startsWith("*")) {
                throw new IllegalArgumentException("Not a Doxygen comment: " + comment);
            }
            StringBuilder input = new StringBuilder();
            input.append("\n  ");
            for (int i = 0; i < comment.column; ++i) {
                input.append(" ");
            }
            input.append(comment.text);
            input.append("\n");
            DoxygenParser parser = new DoxygenParser((TokenStream)new CommonTokenStream((TokenSource)new DoxygenLexer((CharStream)new ANTLRReaderStream((Reader)new StringReader(input.toString()))))).init(comment);
            return parser.doxygen_comment();
        }
        catch (IllegalArgumentException | RecognitionException e) {
            throw new IllegalArgumentException("Not a valid Doxygen comment: " + comment, e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String processMarkdown(String markdown) {
        return StringEscapeUtils.unescapeHtml4((String)markdown);
    }
}

