/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.css.sass;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import com.google.common.io.CharStreams;
import io.bit3.jsass.CompilationException;
import io.bit3.jsass.Compiler;
import io.bit3.jsass.Options;
import io.bit3.jsass.Output;
import io.bit3.jsass.OutputStyle;
import io.bit3.jsass.importer.Import;
import io.bit3.jsass.importer.Importer;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.daisy.common.file.URLs;
import org.daisy.pipeline.css.CssPreProcessor;
import org.daisy.pipeline.css.sass.impl.SassPostProcessLexer;
import org.daisy.pipeline.css.sass.impl.SassPostProcessParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SassCompiler
implements CssPreProcessor {
    private final Importer importer;
    private final StreamSourceURIResolver resolver;
    private final Map<String, String> env;
    private static final String scssNumber = "\\d*\\.\\d+";
    private static final String scssColor = "(#[\\da-zA-Z]+|(rgb|hsl)a?\\([^)]*\\))";
    private static final String scssBadStringChars = "!\"#$'()*+,\\.\\/:<=>?@\\[\\\\\\]^`{|}~-";
    private static final String scssNumberColorString = "\\s*(\\d*\\.\\d+|(#[\\da-zA-Z]+|(rgb|hsl)a?\\([^)]*\\))|[^\\s!\"#$'()*+,\\.\\/:<=>?@\\[\\\\\\]^`{|}~-]+|\"([^\"]|\\\")*\"|'([^']|\\')*')\\s*";
    private static final Pattern charsetRule = Pattern.compile("(@charset +\"(.+)\";?).*");
    private static final Pattern sourceMappingComment = Pattern.compile("/\\*# sourceMappingURL=data:application/json;base64,(.+)=* \\*/");
    private static final Base64.Decoder base64Decoder = Base64.getDecoder();
    private static final Logger logger = LoggerFactory.getLogger(SassCompiler.class);

    @Override
    public boolean supportsMediaType(String mediaType, URL url) {
        if ("text/x-scss".equals(mediaType)) {
            return true;
        }
        return mediaType == null && url != null && url.toString().endsWith(".scss");
    }

    public SassCompiler(URIResolver resolver, Map<String, String> env) {
        this.resolver = new StreamSourceURIResolver(resolver);
        this.env = env;
        this.importer = new Importer(){

            public Collection<Import> apply(String url, Import previous) {
                URI uri = URLs.asURI((String)url);
                URI base = previous.getAbsoluteUri();
                if (!base.isAbsolute()) {
                    try {
                        base = new URI("file", base.getAuthority(), base.getPath(), base.getQuery(), base.getFragment());
                    }
                    catch (URISyntaxException e) {
                        throw new IllegalStateException("coding error");
                    }
                }
                logger.debug("Importing SASS style sheet: " + uri + " (base = " + base + ")");
                try {
                    try {
                        StreamSource resolved = SassCompiler.this.resolver.resolve(uri.toString(), base.toString());
                        URI abs = URLs.asURI((String)resolved.getSystemId());
                        logger.debug("Resolved to: " + abs);
                        try {
                            return ImmutableList.of((Object)new Import(uri, abs, SassCompiler.preProcess(SassCompiler.byteSource(resolved.getInputStream()).asCharSource(StandardCharsets.UTF_8).read())));
                        }
                        catch (RuntimeException e) {
                            throw new IOException(e);
                        }
                    }
                    catch (TransformerException e) {
                        throw new IOException(e);
                    }
                }
                catch (IOException e) {
                    if (!url.endsWith(".scss")) {
                        return this.apply(url + ".scss", previous);
                    }
                    throw new RuntimeException("Failed to import " + uri + " (base = " + base + ")", e);
                }
            }
        };
    }

    @Override
    public CssPreProcessor.PreProcessingResult compile(CssPreProcessor.PreProcessingSource source) throws IOException {
        BufferedReader stream;
        String firstLine;
        Matcher m;
        Compiler sassCompiler = new Compiler();
        Options options = new Options();
        options.setIsIndentedSyntaxSrc(false);
        options.setOutputStyle(OutputStyle.EXPANDED);
        options.setSourceMapContents(false);
        options.setSourceMapEmbed(true);
        options.setSourceComments(false);
        options.setPrecision(5);
        options.setOmitSourceMapUrl(false);
        options.getImporters().add(this.importer);
        StringBuilder scss = new StringBuilder();
        if (this.env != null) {
            for (String var : this.env.keySet()) {
                String value = this.env.get(var);
                if (!value.matches(scssNumberColorString)) {
                    logger.debug("scss variable '" + var + "' contains special characters: " + value);
                    value = "'" + value.replace("\n", "\\A").replace("'", "\\27") + "'";
                    logger.debug("scss variable '" + var + "' was quoted                 : " + value);
                } else {
                    logger.debug("scss variable '" + var + "' contains no special characters: " + value);
                }
                scss.append("$").append(var).append(": ").append(value).append(";\n");
            }
        }
        if ((m = charsetRule.matcher(firstLine = (stream = new BufferedReader(source.stream)).readLine())).matches()) {
            String charset = m.group(2);
            firstLine = firstLine.substring(m.group(1).length());
            try {
                stream = new BufferedReader(source.reread(Charset.forName(charset)));
                firstLine = stream.readLine();
                m = charsetRule.matcher(firstLine);
                if (m.matches()) {
                    firstLine = firstLine.substring(m.group(1).length());
                }
            }
            catch (UnsupportedCharsetException e) {
                logger.warn("Ignoring @charset \"" + charset + "\";");
            }
            catch (IOException e) {
                logger.warn("Ignoring @charset \"" + charset + "\";");
            }
        }
        scss.append(firstLine).append("\n");
        scss.append(CharStreams.toString((Readable)stream));
        stream.close();
        try {
            Output result = sassCompiler.compileString(SassCompiler.preProcess(scss.toString()), source.base, null, options);
            String css = result.getCss();
            String sourceMap = null;
            int lastNewlineIdx = css.lastIndexOf(10);
            String lastLine = css.substring(lastNewlineIdx + 1);
            m = sourceMappingComment.matcher(lastLine);
            if (m.matches()) {
                sourceMap = new String(base64Decoder.decode(m.group(1)));
                css = css.substring(0, lastNewlineIdx);
            }
            css = SassCompiler.postProcess(css);
            logger.debug(source.base + " compiled to:\n---\n" + css + "---\n");
            return new CssPreProcessor.PreProcessingResult(new StringReader(css), sourceMap, sourceMap != null ? URLs.asURI((File)new File("").getAbsoluteFile()) : source.base);
        }
        catch (CompilationException e) {
            throw new RuntimeException("Could not compile SASS style sheet", e);
        }
    }

    private static ByteSource byteSource(final InputStream is) {
        return new ByteSource(){

            public InputStream openStream() throws IOException {
                return is;
            }
        };
    }

    private static String preProcess(String sass) {
        return sass.replaceAll("::", ">::");
    }

    private static String postProcess(String css) {
        if (!css.contains("::")) {
            return css;
        }
        try {
            ANTLRInputStream input;
            try {
                input = new ANTLRInputStream((InputStream)new ByteArrayInputStream(css.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8.name());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            SassPostProcessLexer lexer = new SassPostProcessLexer((CharStream)input);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            SassPostProcessParser parser = new SassPostProcessParser((TokenStream)tokens);
            return parser.stylesheet();
        }
        catch (RecognitionException e) {
            throw new RuntimeException("Error happened while parsing the CSS", e);
        }
    }

    private static class StreamSourceURIResolver
    implements URIResolver {
        final URIResolver resolver;

        StreamSourceURIResolver(URIResolver resolver) {
            this.resolver = resolver;
        }

        @Override
        public StreamSource resolve(String href, String base) throws TransformerException {
            InputStream stream;
            Source source = this.resolver != null ? this.resolver.resolve(href, base) : null;
            String systemId = null;
            if (source != null) {
                systemId = source.getSystemId();
            }
            if (systemId == null || systemId.equals("")) {
                systemId = null;
            }
            if (source != null && source instanceof StreamSource && systemId != null) {
                return (StreamSource)source;
            }
            if (systemId == null) {
                systemId = URLs.resolve((URI)URLs.asURI((String)base), (URI)URLs.asURI((String)href)).toASCIIString();
            }
            if (source != null && source instanceof StreamSource) {
                stream = ((StreamSource)source).getInputStream();
            } else {
                try {
                    URLConnection conn = URLs.asURL((String)systemId).openConnection();
                    stream = conn.getInputStream();
                    if ("gzip".equalsIgnoreCase(conn.getContentEncoding())) {
                        stream = new GZIPInputStream(stream);
                    }
                }
                catch (IOException e) {
                    throw new TransformerException(e);
                }
            }
            return new StreamSource(stream, systemId);
        }
    }
}

