/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.css.impl;

import com.google.common.collect.Iterables;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.daisy.pipeline.css.sass.impl.SassMapParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unbescape.css.CssEscape;

public abstract class StylesheetParametersParser {
    private static final Logger logger = LoggerFactory.getLogger(StylesheetParametersParser.class);
    private static final Pattern regex = Pattern.compile((SassMapParser.asRegex().pattern() + "|" + Query.access$000().pattern()).replaceAll("\\(\\?<[^>]+>", "(?:"));

    private StylesheetParametersParser() {
    }

    public static Map<String, Object> parse(String expression) throws IllegalArgumentException {
        Map<String, Object> map;
        block6: {
            map = null;
            try {
                map = SassMapParser.parse(expression);
            }
            catch (IllegalArgumentException e) {
                Query query = null;
                try {
                    query = Query.parse(expression);
                    logger.warn("Query syntax is deprecated for stylesheet-parameters. Please use Sass map syntax.");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (query == null) break block6;
                map = new HashMap<String, Object>();
                for (Query.Feature f : query) {
                    map.put(f.getKey(), f.getValue().orElse("true"));
                }
            }
        }
        if (map == null) {
            throw new IllegalArgumentException("Could not parse stylesheet parameter set: " + expression);
        }
        return map;
    }

    public static Pattern asRegex() {
        return regex;
    }

    private static class Query
    extends AbstractCollection<Feature> {
        private static final String IDENT_RE = "[_a-zA-Z][_a-zA-Z0-9-]*";
        private static final String STRING_RE = "'[^']*'|\"[^\"]*\"";
        private static final String INTEGER_RE = "0|-?[1-9][0-9]*";
        private static final Pattern VALUE_RE = Pattern.compile("(?<ident>[_a-zA-Z][_a-zA-Z0-9-]*)|(?<string>'[^']*'|\"[^\"]*\")|(?<integer>0|-?[1-9][0-9]*)");
        private static final Pattern FEATURE_RE = Pattern.compile("\\(\\s*(?<key>[_a-zA-Z][_a-zA-Z0-9-]*)(?:\\s*\\:\\s*(?<value>" + VALUE_RE.pattern() + "))?\\s*\\)");
        private static final Pattern FEATURES_RE;
        private static final Pattern QUERY;
        private final List<Feature> list = new ArrayList<Feature>();

        public static Query parse(String query) throws IllegalArgumentException {
            if (FEATURES_RE.matcher(query).matches()) {
                Query q = new Query();
                Matcher m = FEATURE_RE.matcher(query);
                while (m.find()) {
                    String key = m.group("key");
                    String value = m.group("value");
                    boolean isString = false;
                    if (value != null) {
                        Matcher m2 = VALUE_RE.matcher(value);
                        if (!m2.matches()) {
                            throw new RuntimeException("Coding error");
                        }
                        String ident = m2.group("ident");
                        String string = m2.group("string");
                        String integer = m2.group("integer");
                        if (ident != null) {
                            value = ident;
                        } else if (string != null && !string.equals("")) {
                            value = CssEscape.unescapeCss((String)string.substring(1, string.length() - 1));
                            isString = true;
                        } else if (integer != null && !integer.equals("")) {
                            value = integer;
                        } else {
                            throw new RuntimeException("Coding error");
                        }
                    }
                    q.add(new Feature(key, Optional.ofNullable(value), isString));
                }
                return q;
            }
            throw new IllegalArgumentException("Could not parse query: " + query);
        }

        private Query() {
        }

        @Override
        public boolean add(Feature feature) {
            Feature f;
            int cmp;
            int index = 0;
            String key = feature.getKey();
            Iterator<Feature> iterator = this.list.iterator();
            while (iterator.hasNext() && (cmp = (f = iterator.next()).getKey().compareTo(key)) <= 0) {
                if (cmp > 0) {
                    ++index;
                    break;
                }
                ++index;
            }
            this.list.add(index, feature);
            return true;
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public Iterator<Feature> iterator() {
            return this.list.iterator();
        }

        @Override
        public String toString() {
            StringBuilder b = new StringBuilder();
            for (Feature f : this) {
                b.append(f);
            }
            return b.toString();
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Query)) {
                return false;
            }
            return Iterables.elementsEqual((Iterable)this, (Iterable)((Query)obj));
        }

        static /* synthetic */ Pattern access$000() {
            return QUERY;
        }

        static {
            QUERY = FEATURES_RE = Pattern.compile("\\s*(?:" + FEATURE_RE.pattern() + "\\s*)*");
        }

        private static class Feature {
            private final String key;
            private final Optional<String> value;
            private final Optional<String> literal;

            private Feature(String key, Optional<String> value) {
                this(key, value, false);
            }

            private Feature(String key, Optional<String> value, boolean specifiedAsString) {
                this.key = key;
                this.value = value;
                if (value.isPresent()) {
                    String v = value.get();
                    this.literal = !specifiedAsString && (v.matches(Query.IDENT_RE) || v.matches(Query.INTEGER_RE)) ? Optional.of(v) : Optional.of("\"" + v.replace("\n", "\\A ").replace("\"", "\\22 ") + "\"");
                } else {
                    this.literal = Optional.empty();
                }
            }

            public String getKey() {
                return this.key;
            }

            public boolean hasValue() {
                return this.getValue().isPresent();
            }

            public Optional<String> getValue() {
                return this.value;
            }

            public Optional<String> getLiteral() {
                return this.literal;
            }

            public String toString() {
                StringBuilder b = new StringBuilder();
                String k = this.getKey();
                if (!k.matches(Query.IDENT_RE)) {
                    throw new RuntimeException();
                }
                b.append("(" + k);
                if (this.hasValue()) {
                    b.append(":");
                    b.append(this.getLiteral().get());
                }
                b.append(")");
                return b.toString();
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
                result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Feature other = (Feature)obj;
                if (this.key == null ? other.getKey() != null : !this.key.equals(other.getKey())) {
                    return false;
                }
                return !(this.value == null ? other.getValue() != null : !this.value.equals(other.getValue()));
            }
        }
    }
}

