/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.css.impl;

import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import org.daisy.pipeline.css.impl.StylesheetParametersParser;
import org.daisy.pipeline.datatypes.DatatypeService;
import org.daisy.pipeline.datatypes.ValidationResult;
import org.osgi.service.component.annotations.Component;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Component(name="org.daisy.pipeline.css.impl.StylesheetParametersDatatypeService", service={DatatypeService.class})
public class StylesheetParametersDatatypeService
extends DatatypeService {
    private final Pattern pattern = StylesheetParametersParser.asRegex();
    private Document xmlDefinition = null;

    protected StylesheetParametersDatatypeService() {
        super("stylesheet-parameters");
    }

    public ValidationResult validate(String content) {
        if (this.pattern.matcher(content).matches()) {
            return ValidationResult.valid();
        }
        return ValidationResult.notValid((String)("'" + content + "' does not match the regular expression pattern /" + this.pattern + "/"));
    }

    public Document asDocument() throws Exception {
        if (this.xmlDefinition == null) {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation().createDocument(null, "data", null);
            Element data = doc.getDocumentElement();
            Attr type = doc.createAttribute("type");
            type.setValue("string");
            data.setAttributeNode(type);
            Element documentation = (Element)data.appendChild(doc.createElementNS("http://relaxng.org/ns/compatibility/annotations/1.0", "documentation"));
            Attr lang = doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
            lang.setValue("en");
            documentation.setAttributeNode(lang);
            Attr space = doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", "space");
            space.setValue("preserve");
            documentation.setAttributeNode(space);
            documentation.appendChild(doc.createTextNode("A Sass map\n\nA [Sass map](https://sass-lang.com/documentation/values/maps/) is a set of pairs\nof keys and values written as:\n\n    (<expression>: <expression>, <expression>: <expression>, ...)\n\nwhere the\n[expression](https://sass-lang.com/documentation/syntax/structure#expressions)\nbefore the `:` is the key, and the expression after is the value associated\nwith that key. The keys must be unique. An empty map is written `()`."));
            Element param = (Element)data.appendChild(doc.createElement("param"));
            Attr name = doc.createAttribute("name");
            name.setValue("pattern");
            param.setAttributeNode(name);
            param.appendChild(doc.createTextNode("^(" + this.pattern.pattern().replaceAll("\\(\\?<[^>]+>", "(") + ")$"));
            this.xmlDefinition = doc;
        }
        return this.xmlDefinition;
    }
}

