/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.css.impl;

import com.google.common.collect.Iterables;
import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.RuleFactory;
import cz.vutbr.web.css.Selector;
import cz.vutbr.web.css.SupportedCSS;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermFunction;
import cz.vutbr.web.css.TermIdent;
import cz.vutbr.web.css.TermList;
import cz.vutbr.web.css.TermPair;
import cz.vutbr.web.css.TermString;
import cz.vutbr.web.csskit.RuleFactoryImpl;
import cz.vutbr.web.csskit.antlr.CSSParserFactory;
import cz.vutbr.web.domassign.DeclarationTransformer;
import cz.vutbr.web.domassign.StyleMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.URIResolver;
import org.daisy.braille.css.BrailleCSSDeclarationTransformer;
import org.daisy.braille.css.BrailleCSSParserFactory;
import org.daisy.braille.css.BrailleCSSProperty;
import org.daisy.braille.css.RuleCounterStyle;
import org.daisy.braille.css.SupportedBrailleCSS;
import org.daisy.common.stax.BaseURIAwareXMLStreamWriter;
import org.daisy.common.stax.XMLStreamWriterHelper;
import org.daisy.common.transform.XMLTransformer;
import org.daisy.pipeline.css.CounterStyle;
import org.daisy.pipeline.css.CssCascader;
import org.daisy.pipeline.css.CssPreProcessor;
import org.daisy.pipeline.css.CssSerializer;
import org.daisy.pipeline.css.JStyleParserCssCascader;
import org.daisy.pipeline.css.Medium;
import org.daisy.pipeline.css.XsltProcessor;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Component(name="DefaultCssCascader", service={CssCascader.class})
public class DefaultCssCascader
implements CssCascader {
    private static final CSSParserFactory parserFactory = new BrailleCSSParserFactory();
    private static final RuleFactory ruleFactory = RuleFactoryImpl.getInstance();
    private static final SupportedCSS supportedCSS = new SupportedBrailleCSS(false, true);
    private static final DeclarationTransformer declarationTransformer = new BrailleCSSDeclarationTransformer(supportedCSS);
    private static final Logger logger = LoggerFactory.getLogger(DefaultCssCascader.class);

    @Override
    public boolean supportsMedium(Medium medium) {
        switch (medium.getType()) {
            case PRINT: 
            case SCREEN: {
                return "none".equals(medium.getCustomFeatures().get("counter-support"));
            }
        }
        return false;
    }

    @Override
    public XMLTransformer newInstance(Medium medium, String userStylesheet, URIResolver uriResolver, CssPreProcessor preProcessor, XsltProcessor xsltProcessor, QName attributeName, boolean multipleAttrs) {
        if (!this.supportsMedium(medium)) {
            throw new IllegalArgumentException("medium not supported: " + medium);
        }
        return new Transformer(uriResolver, preProcessor, xsltProcessor, userStylesheet, medium, attributeName, multipleAttrs);
    }

    private static class Transformer
    extends JStyleParserCssCascader {
        private Map<String, CounterStyle> namedCounterStyles = null;
        private LinkedList<CounterStyle> listCounterStyle = new LinkedList();
        private LinkedList<Map<String, Integer>> counterValues = new LinkedList();
        private final QName markerAttributeName;
        private final QName markerContentAttributeName;

        private Transformer(URIResolver resolver, CssPreProcessor preProcessor, XsltProcessor xsltProcessor, String userStyleSheet, Medium medium, QName attributeName, boolean multipleAttrs) {
            super(resolver, preProcessor, xsltProcessor, userStyleSheet, medium, attributeName, parserFactory, ruleFactory, supportedCSS, declarationTransformer);
            this.listCounterStyle.push(CounterStyle.DISC);
            this.counterValues.push(null);
            if (attributeName == null) {
                this.markerAttributeName = null;
                this.markerContentAttributeName = null;
            } else if (multipleAttrs) {
                this.markerAttributeName = null;
                this.markerContentAttributeName = new QName(attributeName.getNamespaceURI(), "marker-content", attributeName.getPrefix());
            } else {
                this.markerAttributeName = attributeName;
                this.markerContentAttributeName = null;
            }
        }

        @Override
        protected void processElement(Element element, StyleMap styleMap, BaseURIAwareXMLStreamWriter writer) throws XMLStreamException, IllegalArgumentException {
            XMLStreamWriterHelper.writeStartElement((XMLStreamWriter)writer, (Element)element);
            this.copyAttributes(element, writer);
            HashMap<Selector.PseudoElement, NodeData> pseudoStyles = new HashMap<Selector.PseudoElement, NodeData>();
            for (Selector.PseudoElement pseudo : styleMap.pseudoSet((Object)element)) {
                pseudoStyles.put(pseudo, (NodeData)styleMap.get((Object)element, (Object)pseudo));
            }
            NodeData mainStyle = (NodeData)styleMap.get((Object)element);
            this.updateCounterValues(mainStyle);
            CounterStyle listCounterStyle = this.getCurrentListCounterStyle(mainStyle);
            String marker = this.generateMarkerContents(mainStyle, pseudoStyles, element, listCounterStyle);
            if (marker != null) {
                if (this.markerContentAttributeName != null) {
                    XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)writer, (QName)this.markerContentAttributeName, (String)marker);
                } else if (this.markerAttributeName != null) {
                    XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)writer, (QName)this.markerAttributeName, (String)String.format("&::marker { content: '%s' }", marker.replaceAll("'", "\\\\'")));
                } else {
                    writer.writeCharacters(marker);
                }
            }
            this.listCounterStyle.push(listCounterStyle);
            this.counterValues.push(null);
            for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.traverse(child, styleMap, writer);
            }
            this.listCounterStyle.pop();
            this.counterValues.pop();
            writer.writeEndElement();
        }

        private void updateCounterValues(NodeData style) {
            Map<Object, Object> createdBySiblingOrSelf;
            boolean exists;
            String name;
            TermPair p;
            List list;
            List list2;
            if (style.getProperty("counter-reset", false) == CSSProperty.CounterReset.list_values && (list2 = (List)style.getValue(TermList.class, "counter-reset", false)) != null) {
                for (Object t : list2) {
                    if (!(t instanceof TermPair)) {
                        throw new IllegalStateException("coding error");
                    }
                    TermPair termPair = (TermPair)t;
                    String name2 = (String)termPair.getKey();
                    Map<String, Integer> createdBySiblingOrSelf2 = this.counterValues.peek();
                    if (createdBySiblingOrSelf2 == null) {
                        createdBySiblingOrSelf2 = new HashMap<String, Integer>();
                        this.counterValues.set(0, createdBySiblingOrSelf2);
                    }
                    createdBySiblingOrSelf2.put(name2, (Integer)termPair.getValue());
                }
            }
            HashSet<String> done = null;
            if (style.getProperty("counter-set", false) == CSSProperty.CounterSet.list_values && (list = (List)style.getValue(TermList.class, "counter-set", false)) != null) {
                for (Term term : list) {
                    if (!(term instanceof TermPair)) {
                        throw new IllegalStateException("coding error");
                    }
                    p = (TermPair)term;
                    name = (String)p.getKey();
                    exists = false;
                    for (Map map : this.counterValues) {
                        if (map == null) continue;
                        map.put(name, p.getValue());
                        exists = true;
                        break;
                    }
                    if (!exists) {
                        createdBySiblingOrSelf = this.counterValues.peek();
                        if (createdBySiblingOrSelf == null) {
                            createdBySiblingOrSelf = new HashMap<String, Object>();
                            this.counterValues.set(0, createdBySiblingOrSelf);
                        }
                        createdBySiblingOrSelf.put(name, p.getValue());
                    }
                    if (done == null) {
                        done = new HashSet<String>();
                    }
                    done.add(name);
                }
            }
            if (style.getProperty("counter-increment", false) == CSSProperty.CounterIncrement.list_values && (list = (List)style.getValue(TermList.class, "counter-increment", false)) != null) {
                for (Term term : list) {
                    if (!(term instanceof TermPair)) {
                        throw new IllegalStateException("coding error");
                    }
                    p = (TermPair)term;
                    name = (String)p.getKey();
                    if (done != null && done.contains(name)) continue;
                    exists = false;
                    for (Map map : this.counterValues) {
                        if (map == null) continue;
                        map.put(name, map.getOrDefault(name, 0) + (Integer)p.getValue());
                        exists = true;
                        break;
                    }
                    if (!exists) {
                        createdBySiblingOrSelf = this.counterValues.peek();
                        if (createdBySiblingOrSelf == null) {
                            createdBySiblingOrSelf = new HashMap();
                            this.counterValues.set(0, createdBySiblingOrSelf);
                        }
                        createdBySiblingOrSelf.put(name, p.getValue());
                    }
                    if (done == null) {
                        done = new HashSet();
                    }
                    done.add(name);
                }
            }
            if (!(done != null && done.contains("list-item") || style.getProperty("display", false) != BrailleCSSProperty.Display.LIST_ITEM)) {
                boolean exists2 = false;
                for (Map map : this.counterValues) {
                    if (map == null) continue;
                    map.put("list-item", map.getOrDefault("list-item", 0) + 1);
                    exists2 = true;
                    break;
                }
                if (!exists2) {
                    Map<String, Integer> createdBySiblingOrSelf3 = this.counterValues.peek();
                    if (createdBySiblingOrSelf3 == null) {
                        createdBySiblingOrSelf3 = new HashMap<String, Integer>();
                        this.counterValues.set(0, createdBySiblingOrSelf3);
                    }
                    createdBySiblingOrSelf3.put("list-item", 1);
                }
            }
        }

        private CounterStyle getCurrentListCounterStyle(NodeData style) {
            BrailleCSSProperty.ListStyleType type = (BrailleCSSProperty.ListStyleType)style.getProperty("list-style-type", false);
            if (type == null) {
                return this.listCounterStyle.peek();
            }
            switch (type) {
                case INHERIT: {
                    return this.listCounterStyle.peek();
                }
                case INITIAL: {
                    return CounterStyle.DISC;
                }
                case counter_style_name: {
                    return this.getNamedCounterStyle((String)((TermIdent)style.getValue(TermIdent.class, "list-style-type")).getValue());
                }
                case symbols_fn: {
                    return CounterStyle.fromSymbolsFunction(style.getValue(TermFunction.class, "list-style-type"));
                }
                case braille_string: {
                    return null;
                }
                case DECIMAL: {
                    return CounterStyle.DECIMAL;
                }
                case LOWER_ALPHA: {
                    return CounterStyle.LOWER_ALPHA;
                }
                case LOWER_ROMAN: {
                    return CounterStyle.LOWER_ROMAN;
                }
                case UPPER_ALPHA: {
                    return CounterStyle.UPPER_ALPHA;
                }
                case UPPER_ROMAN: {
                    return CounterStyle.UPPER_ROMAN;
                }
            }
            return null;
        }

        private CounterStyle getNamedCounterStyle(String name) {
            if (this.namedCounterStyles == null) {
                this.namedCounterStyles = CounterStyle.parseCounterStyleRules(Iterables.filter((Iterable)this.getParsedStyleSheet(), RuleCounterStyle.class));
            }
            return this.namedCounterStyles.getOrDefault(name, CounterStyle.DECIMAL);
        }

        private String evaluateCounter(String name, CounterStyle style, boolean withPrefixAndSuffix) {
            Integer value = null;
            boolean exists = false;
            for (Map map : this.counterValues) {
                if (map == null || !map.containsKey(name)) continue;
                value = (Integer)map.get(name);
                break;
            }
            if (value == null) {
                value = 0;
                Map<String, Integer> createdBySiblingOrSelf = this.counterValues.peek();
                if (createdBySiblingOrSelf == null) {
                    createdBySiblingOrSelf = new HashMap<String, Integer>();
                    this.counterValues.set(0, createdBySiblingOrSelf);
                }
                createdBySiblingOrSelf.put(name, value);
            }
            return style.format(value, withPrefixAndSuffix);
        }

        private String evaluateCounters(String name, CounterStyle style, String separator) {
            StringBuilder s = new StringBuilder();
            for (Map map : this.counterValues) {
                if (map == null || !map.containsKey(name)) continue;
                if (s.length() > 0) {
                    s.insert(0, separator);
                }
                s.insert(0, style.format((Integer)map.get(name)));
            }
            if (s.length() == 0) {
                Map<String, Integer> createdBySiblingOrSelf = this.counterValues.peek();
                if (createdBySiblingOrSelf == null) {
                    createdBySiblingOrSelf = new HashMap<String, Integer>();
                    this.counterValues.set(0, createdBySiblingOrSelf);
                }
                createdBySiblingOrSelf.put(name, 0);
                s.append(style.format(0));
            }
            return s.toString();
        }

        private String evaluateContent(List<Term<?>> content, Element element) throws IllegalArgumentException {
            StringBuilder s = new StringBuilder();
            for (Term<?> t : content) {
                if (t instanceof TermString) {
                    s.append((String)((TermString)t).getValue());
                    continue;
                }
                if (t instanceof TermFunction) {
                    String name;
                    TermFunction f = (TermFunction)t;
                    if ("counter".equalsIgnoreCase(f.getFunctionName())) {
                        name = null;
                        CounterStyle style = null;
                        for (Term arg : f) {
                            if (name == null) {
                                if (arg instanceof TermIdent) {
                                    name = (String)((TermIdent)arg).getValue();
                                    continue;
                                }
                                throw new IllegalArgumentException("invalid first argument of counter() function: should be the counter name");
                            }
                            if (style == null) {
                                if (arg instanceof TermIdent) {
                                    style = this.getNamedCounterStyle((String)((TermIdent)arg).getValue());
                                    continue;
                                }
                                if (arg instanceof TermFunction) {
                                    try {
                                        style = CounterStyle.fromSymbolsFunction((TermFunction)arg);
                                        continue;
                                    }
                                    catch (IllegalArgumentException e) {
                                        throw new IllegalArgumentException("invalid second argument of counter() function: should be a counter style", e);
                                    }
                                }
                                throw new IllegalArgumentException("invalid second argument of counter() function: should be a counter style");
                            }
                            throw new IllegalArgumentException("unexpected argument of counter() function: function takes at most two arguments");
                        }
                        if (name == null) {
                            throw new IllegalArgumentException("counter() function requires at least one argument");
                        }
                        if (style == null) {
                            style = CounterStyle.DECIMAL;
                        }
                        s.append(this.evaluateCounter(name, style, false));
                        continue;
                    }
                    if ("counters".equalsIgnoreCase(f.getFunctionName())) {
                        name = null;
                        String separator = null;
                        CounterStyle style = null;
                        for (Term arg : f) {
                            if (name == null) {
                                if (arg instanceof TermIdent) {
                                    name = (String)((TermIdent)arg).getValue();
                                    continue;
                                }
                                throw new IllegalArgumentException("invalid first argument of counters() function: should be the counter name");
                            }
                            if (separator == null) {
                                if (arg instanceof TermString) {
                                    separator = (String)((TermString)arg).getValue();
                                    continue;
                                }
                                throw new IllegalArgumentException("invalid second argument of counters() function: should be a string");
                            }
                            if (style == null) {
                                if (arg instanceof TermIdent) {
                                    style = this.getNamedCounterStyle((String)((TermIdent)arg).getValue());
                                    continue;
                                }
                                if (arg instanceof TermFunction) {
                                    try {
                                        style = CounterStyle.fromSymbolsFunction((TermFunction)arg);
                                        continue;
                                    }
                                    catch (IllegalArgumentException e) {
                                        throw new IllegalArgumentException("invalid third argument of counters() function: should be a counter style", e);
                                    }
                                }
                                throw new IllegalArgumentException("invalid third argument of counters() function: should be a counter style");
                            }
                            throw new IllegalArgumentException("unexpected argument of counters() function: function takes at most three arguments");
                        }
                        if (name == null || separator == null) {
                            throw new IllegalArgumentException("counters() function requires at least two arguments");
                        }
                        if (style == null) {
                            style = CounterStyle.DECIMAL;
                        }
                        s.append(this.evaluateCounters(name, style, separator));
                        continue;
                    }
                    throw new RuntimeException(f.getFunctionName() + "() function not supported in content list");
                }
                throw new IllegalStateException();
            }
            return s.toString();
        }

        private String generateMarkerContents(NodeData mainStyle, Map<Selector.PseudoElement, NodeData> pseudoStyles, Element element, CounterStyle listCounterStyle) throws IllegalArgumentException {
            if (mainStyle.getProperty("display", false) == BrailleCSSProperty.Display.LIST_ITEM) {
                for (Selector.PseudoElement pseudo : pseudoStyles.keySet()) {
                    List content;
                    if (!"marker".equals(pseudo.getName())) continue;
                    NodeData pseudoStyle = pseudoStyles.get(pseudo);
                    if (pseudoStyle.getProperty("content", false) == BrailleCSSProperty.Content.content_list && (content = (List)pseudoStyle.getValue(TermList.class, "content", false)) != null) {
                        return this.evaluateContent(content, element);
                    }
                    return null;
                }
                if (listCounterStyle != null) {
                    return this.evaluateCounter("list-item", listCounterStyle, true);
                }
            }
            return null;
        }

        @Override
        protected Map<QName, String> serializeStyle(NodeData mainStyle, Map<Selector.PseudoElement, NodeData> pseudoStyles, Element context) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected String serializeValue(Term<?> value) {
            return CssSerializer.toString(value);
        }
    }
}

