/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.css.calabash.impl;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.S9apiUtils;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

class InMemoryURIResolver
implements URIResolver {
    private ReadablePipe documents = null;
    private static final QName c_encoding = new QName("c", "http://www.w3.org/ns/xproc-step", "encoding");
    private static final QName _content_type = new QName("content-type");

    InMemoryURIResolver() {
    }

    void setContext(ReadablePipe documents) {
        this.documents = documents;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        if (this.documents == null) {
            return null;
        }
        try {
            URI uri = base != null ? new URI(base).resolve(new URI(href)) : new URI(href);
            uri = InMemoryURIResolver.normalizeUri(uri);
            this.documents.resetReader();
            while (this.documents.moreDocuments()) {
                XdmNode doc = this.documents.read();
                URI docUri = InMemoryURIResolver.normalizeUri(doc.getBaseURI());
                if (!docUri.equals(uri)) continue;
                XdmNode root = S9apiUtils.getDocumentElement((XdmNode)doc);
                if (XProcConstants.c_result.equals((Object)root.getNodeName()) && root.getAttributeValue(_content_type) != null && root.getAttributeValue(_content_type).startsWith("text/")) {
                    return new StreamSource(new ByteArrayInputStream(doc.getStringValue().getBytes()), uri.toASCIIString());
                }
                if ("base64".equals(root.getAttributeValue(c_encoding))) {
                    return new StreamSource(new ByteArrayInputStream(Base64.decode((String)doc.getStringValue())), uri.toASCIIString());
                }
                if (XProcConstants.c_data.equals((Object)root.getNodeName())) {
                    return new StreamSource(new ByteArrayInputStream(doc.getStringValue().getBytes()), uri.toASCIIString());
                }
                return doc.asSource();
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            throw new TransformerException(e);
        }
        catch (SaxonApiException e) {
            e.printStackTrace();
            throw new TransformerException(e);
        }
        return null;
    }

    private static URI normalizeUri(URI uri) {
        String s = uri.toASCIIString();
        if (s.startsWith("file:///")) {
            s = "file:" + s.substring(7);
        }
        if (s.startsWith("file:") && s.contains("!/")) {
            s = "zip:" + s;
        }
        if (s.startsWith("zip:file:") && !s.contains("!/")) {
            s = s.replaceFirst("!", "!/");
        }
        try {
            return new URI(s);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

