/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.css.calabash.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.runtime.XStep;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmValue;
import org.daisy.common.saxon.SaxonBuffer;
import org.daisy.common.saxon.SaxonHelper;
import org.daisy.common.saxon.SaxonInputValue;
import org.daisy.common.transform.InputValue;
import org.daisy.common.transform.OutputValue;
import org.daisy.common.transform.XMLInputValue;
import org.daisy.common.xproc.XProcMonitor;
import org.daisy.common.xproc.calabash.XMLCalabashInputValue;
import org.daisy.common.xproc.calabash.XMLCalabashOutputValue;
import org.daisy.common.xproc.calabash.XMLCalabashParameterInputValue;
import org.daisy.common.xproc.calabash.XProcStep;
import org.daisy.common.xproc.calabash.XProcStepProvider;
import org.daisy.pipeline.css.CssCascader;
import org.daisy.pipeline.css.Medium;
import org.daisy.pipeline.css.UserAgentStylesheetRegistry;
import org.daisy.pipeline.css.XsltProcessor;
import org.daisy.pipeline.css.calabash.impl.InMemoryURIResolver;
import org.daisy.pipeline.css.sass.SassCompiler;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssCascadeStep
extends DefaultStep
implements XProcStep {
    private ReadablePipe sourcePipe = null;
    private ReadablePipe contextPipe = null;
    private WritablePipe resultPipe = null;
    private final InMemoryURIResolver inMemoryResolver;
    private final URIResolver cssURIResolver;
    private final Iterable<CssCascader> inliners;
    private final UserAgentStylesheetRegistry userAgentStylesheets;
    private static final net.sf.saxon.s9api.QName _user_stylesheet = new net.sf.saxon.s9api.QName("user-stylesheet");
    private static final net.sf.saxon.s9api.QName _include_user_agent_stylesheet = new net.sf.saxon.s9api.QName("include-user-agent-stylesheet");
    private static final net.sf.saxon.s9api.QName _parameters = new net.sf.saxon.s9api.QName("parameters");
    private static final net.sf.saxon.s9api.QName _type = new net.sf.saxon.s9api.QName("type");
    private static final net.sf.saxon.s9api.QName _content_type = new net.sf.saxon.s9api.QName("content-type");
    private static final net.sf.saxon.s9api.QName _media = new net.sf.saxon.s9api.QName("media");
    private static final net.sf.saxon.s9api.QName _attribute_name = new net.sf.saxon.s9api.QName("attribute-name");
    private static final net.sf.saxon.s9api.QName _multiple_attributes = new net.sf.saxon.s9api.QName("multiple-attributes");
    private static final String DEFAULT_MEDIUM = "embossed";
    private static final String DEFAULT_TYPES = "text/css text/x-scss";
    private static final net.sf.saxon.s9api.QName DEFAULT_ATTRIBUTE_NAME = new net.sf.saxon.s9api.QName("style");
    private static final Logger logger = LoggerFactory.getLogger(CssCascadeStep.class);

    private CssCascadeStep(XProcRuntime runtime, XAtomicStep step, Iterable<CssCascader> inliners, URIResolver resolver, UserAgentStylesheetRegistry userAgentStylesheets) {
        super(runtime, step);
        this.inliners = inliners;
        this.userAgentStylesheets = userAgentStylesheets;
        this.inMemoryResolver = new InMemoryURIResolver();
        this.cssURIResolver = CssCascadeStep.fallback(this.inMemoryResolver, resolver);
    }

    public void setInput(String port, ReadablePipe pipe) {
        if ("source".equals(port)) {
            this.sourcePipe = pipe;
        } else {
            this.contextPipe = pipe;
        }
    }

    public void setOutput(String port, WritablePipe pipe) {
        this.resultPipe = pipe;
    }

    public void reset() {
        this.sourcePipe.resetReader();
        this.contextPipe.resetReader();
        this.resultPipe.resetWriter();
    }

    public void run() throws SaxonApiException {
        super.run();
        try {
            Medium medium;
            try {
                medium = Medium.parse(this.getOption(_media, DEFAULT_MEDIUM));
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Could not parse media: " + this.getOption(_media, DEFAULT_MEDIUM), e);
            }
            List<String> types = Arrays.asList(this.getOption(_type, DEFAULT_TYPES).trim().split("\\s+"));
            if (!types.contains("text/css")) {
                throw new XProcException((XStep)this.step, "'type' option must contain 'text/css'");
            }
            boolean enableSass = types.contains("text/x-scss");
            ArrayList<String> stylesheets = new ArrayList<String>();
            if (this.getOption(_include_user_agent_stylesheet, false)) {
                for (URL u : this.userAgentStylesheets.get(types, Arrays.asList(this.getOption(_content_type, "").trim().split("\\s+")), Collections.singleton(medium))) {
                    stylesheets.add(u.toString());
                }
            }
            for (String s : Arrays.asList(this.getOption(_user_stylesheet, "").trim().split("\\s+"))) {
                stylesheets.add(s);
            }
            stylesheets.add(this.getOption(_user_stylesheet, ""));
            HashMap sassVariables = new HashMap();
            RuntimeValue paramOption = this.getOption(_parameters);
            if (paramOption != null) {
                for (Map.Entry entry : SaxonHelper.mapFromMapItem((MapItem)((MapItem)SaxonHelper.getSingleItem((Sequence)paramOption.getValue().getUnderlyingValue())), Object.class).entrySet()) {
                    sassVariables.put(entry.getKey(), "" + entry.getValue());
                }
            }
            for (CssCascader cssCascader : this.inliners) {
                if (!cssCascader.supportsMedium(medium)) continue;
                RuntimeValue v = this.getOption(_attribute_name);
                Object attributeName = v == null ? DEFAULT_ATTRIBUTE_NAME : (v.getValue().size() == 0 ? null : v.getQName());
                boolean multipleAttrs = this.getOption(_multiple_attributes, false);
                if (multipleAttrs && (attributeName == null || attributeName.getNamespaceURI() == null || "".equals(attributeName.getNamespaceURI()))) {
                    throw new IllegalArgumentException("Namespace must be specified when cascading to multiple attributes per element");
                }
                this.inMemoryResolver.setContext(this.contextPipe);
                cssCascader.newInstance(medium, String.join((CharSequence)" ", stylesheets), this.cssURIResolver, enableSass ? new SassCompiler(this.cssURIResolver, Collections.unmodifiableMap(sassVariables)) : null, new XSLT(this.runtime, this.step), attributeName != null ? SaxonHelper.jaxpQName((net.sf.saxon.s9api.QName)attributeName) : null, multipleAttrs).transform((InputValue)new XMLCalabashInputValue(this.sourcePipe), (OutputValue)new XMLCalabashOutputValue(this.resultPipe, this.runtime)).run();
                return;
            }
            throw new XProcException((XStep)this.step, "No CSS inliner implementation found for medium " + medium);
        }
        catch (Throwable e) {
            throw XProcStep.raiseError((Throwable)e, (XAtomicStep)this.step);
        }
    }

    private static URIResolver fallback(final URIResolver ... resolvers) {
        return new URIResolver(){

            @Override
            public Source resolve(String href, String base) throws TransformerException {
                UnmodifiableIterator iterator = Iterators.forArray((Object[])resolvers);
                while (iterator.hasNext()) {
                    Source source = ((URIResolver)iterator.next()).resolve(href, base);
                    if (source == null) continue;
                    return source;
                }
                return null;
            }
        };
    }

    @Component(name="pxi:css-cascade", service={XProcStepProvider.class}, property={"type:String={http://www.daisy.org/ns/pipeline/xproc/internal}css-cascade"})
    public static class Provider
    implements XProcStepProvider {
        private URIResolver resolver;
        private UserAgentStylesheetRegistry userAgentStylesheets;
        private final List<CssCascader> inliners = new ArrayList<CssCascader>();

        public XProcStep newStep(XProcRuntime runtime, XAtomicStep step, XProcMonitor monitor, Map<String, String> properties) {
            return new CssCascadeStep(runtime, step, this.inliners, this.resolver, this.userAgentStylesheets);
        }

        @Reference(name="URIResolver", unbind="-", service=URIResolver.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC)
        public void setUriResolver(URIResolver resolver) {
            this.resolver = resolver;
        }

        @Reference(name="CssCascader", unbind="-", service=CssCascader.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.STATIC)
        public void bindCssCascader(CssCascader inliner) {
            this.inliners.add(inliner);
        }

        @Reference(name="UserAgentStylesheetRegistry", unbind="-", service=UserAgentStylesheetRegistry.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC)
        public void setUserAgentStylesheetRegistry(UserAgentStylesheetRegistry registry) {
            this.userAgentStylesheets = registry;
        }
    }

    private class XSLT
    extends com.xmlcalabash.library.XSLT
    implements XProcStep,
    XsltProcessor {
        public XSLT(XProcRuntime runtime, XAtomicStep step) {
            super(runtime, step);
        }

        public void setParameter(String port, net.sf.saxon.s9api.QName name, RuntimeValue value) {
            if ("parameters".equals(port)) {
                this.setParameter(name, value);
            } else {
                super.setParameter(port, name, value);
            }
        }

        @Override
        public XMLInputValue<Void> transform(URI stylesheetURI, XMLInputValue<?> source, Map<QName, InputValue<?>> parameters) {
            SaxonInputValue stylesheet = new SaxonInputValue((XdmValue)this.runtime.parse(stylesheetURI.toASCIIString(), null));
            SaxonBuffer buf = new SaxonBuffer(this.runtime.getProcessor().getUnderlyingConfiguration());
            this.transform((Map)ImmutableMap.of((Object)new QName("source"), source, (Object)new QName("stylesheet"), (Object)stylesheet, (Object)new QName("parameters"), (Object)XMLCalabashParameterInputValue.of((InputValue)new InputValue(parameters))), (Map)ImmutableMap.of((Object)new QName("result"), (Object)buf.asOutput())).run();
            buf.done();
            return buf.asInput();
        }
    }
}

