/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.css.calabash.impl;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.s9api.SaxonApiException;
import org.daisy.common.file.URLs;
import org.daisy.common.saxon.SaxonHelper;
import org.daisy.common.stax.BaseURIAwareXMLStreamWriter;
import org.daisy.common.stax.XMLStreamWriterHelper;
import org.daisy.common.xproc.XProcMonitor;
import org.daisy.common.xproc.calabash.XMLCalabashInputValue;
import org.daisy.common.xproc.calabash.XMLCalabashOutputValue;
import org.daisy.common.xproc.calabash.XProcStep;
import org.daisy.common.xproc.calabash.XProcStepProvider;
import org.daisy.pipeline.css.Medium;
import org.daisy.pipeline.css.UserAgentStylesheetRegistry;
import org.daisy.pipeline.css.calabash.impl.InMemoryURIResolver;
import org.daisy.pipeline.css.sass.SassAnalyzer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class CssAnalyzeStep
extends DefaultStep
implements XProcStep {
    private ReadablePipe sourcePipe = null;
    private ReadablePipe contextPipe = null;
    private WritablePipe resultPipe = null;
    private final InMemoryURIResolver inMemoryResolver = new InMemoryURIResolver();
    private final URIResolver cssURIResolver;
    private final UserAgentStylesheetRegistry userAgentStylesheets;
    private static final QName c_param_set = new QName("http://www.w3.org/ns/xproc-step", "param-set");
    private static final QName c_param = new QName("http://www.w3.org/ns/xproc-step", "param");
    private static final QName _name = new QName("name");
    private static final QName _value = new QName("value");
    private static final net.sf.saxon.s9api.QName _user_stylesheet = new net.sf.saxon.s9api.QName("user-stylesheet");
    private static final net.sf.saxon.s9api.QName _include_user_agent_stylesheet = new net.sf.saxon.s9api.QName("include-user-agent-stylesheet");
    private static final net.sf.saxon.s9api.QName _parameters = new net.sf.saxon.s9api.QName("parameters");
    private static final net.sf.saxon.s9api.QName _content_type = new net.sf.saxon.s9api.QName("content-type");
    private static final net.sf.saxon.s9api.QName _media = new net.sf.saxon.s9api.QName("media");
    private static final String DEFAULT_MEDIUM = "embossed";
    private static URIResolver simpleURIResolver = new URIResolver(){

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            try {
                URI uri = base != null ? new URI(base).resolve(new URI(href)) : new URI(href);
                return new SAXSource(new InputSource(uri.toASCIIString()));
            }
            catch (URISyntaxException e) {
                throw new TransformerException(e);
            }
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(CssAnalyzeStep.class);

    private CssAnalyzeStep(XProcRuntime runtime, XAtomicStep step, URIResolver resolver, UserAgentStylesheetRegistry userAgentStylesheets) {
        super(runtime, step);
        this.cssURIResolver = CssAnalyzeStep.fallback(this.inMemoryResolver, resolver, simpleURIResolver);
        this.userAgentStylesheets = userAgentStylesheets;
    }

    public void setInput(String port, ReadablePipe pipe) {
        if ("source".equals(port)) {
            this.sourcePipe = pipe;
        } else {
            this.contextPipe = pipe;
        }
    }

    public void setOutput(String port, WritablePipe pipe) {
        this.resultPipe = pipe;
    }

    public void reset() {
        this.sourcePipe.resetReader();
        this.contextPipe.resetReader();
        this.resultPipe.resetWriter();
    }

    public void run() throws SaxonApiException {
        super.run();
        try {
            Object s;
            LinkedHashMap params = new LinkedHashMap();
            RuntimeValue paramOption = this.getOption(_parameters);
            if (paramOption != null) {
                for (Map.Entry e : SaxonHelper.mapFromMapItem((MapItem)((MapItem)SaxonHelper.getSingleItem((Sequence)paramOption.getValue().getUnderlyingValue())), Object.class).entrySet()) {
                    params.put(e.getKey(), "" + e.getValue());
                }
            }
            List<Medium> media = Medium.parseMultiple(this.getOption(_media, DEFAULT_MEDIUM));
            this.inMemoryResolver.setContext(this.contextPipe);
            Node doc = (Node)new XMLCalabashInputValue(this.sourcePipe).ensureSingleItem().asNodeIterator().next();
            if (!(doc instanceof Document)) {
                throw new IllegalArgumentException();
            }
            URI baseURI = new URI(doc.getBaseURI());
            DOMSource sourceDocument = new DOMSource(doc, baseURI.toASCIIString());
            ArrayList<Source> stylesheets = new ArrayList<Source>();
            if (this.getOption(_include_user_agent_stylesheet, false)) {
                for (URL u : this.userAgentStylesheets.get(Collections.singleton("text/x-scss"), Arrays.asList(this.getOption(_content_type, "").trim().split("\\s+")), media)) {
                    stylesheets.add(new SAXSource(new InputSource(u.toString())));
                }
            }
            if ((s = this.getOption(_user_stylesheet, "")) != null) {
                StringTokenizer t = new StringTokenizer((String)s);
                while (t.hasMoreTokens()) {
                    stylesheets.add(new SAXSource(new InputSource(URLs.resolve((URI)baseURI, (URI)URLs.asURI((String)t.nextToken())).toASCIIString())));
                }
            }
            for (SassAnalyzer.SassVariable v : new SassAnalyzer(media, this.cssURIResolver, null).analyze(stylesheets, sourceDocument).getVariables()) {
                if (params.containsKey(v.getName()) && v.isDefault()) continue;
                params.put(v.getName(), v.getValue());
            }
            BaseURIAwareXMLStreamWriter writer = new XMLCalabashOutputValue(this.resultPipe, this.runtime).asXMLStreamWriter();
            writer.writeStartDocument();
            XMLStreamWriterHelper.writeStartElement((XMLStreamWriter)writer, (QName)c_param_set);
            for (String p : params.keySet()) {
                XMLStreamWriterHelper.writeStartElement((XMLStreamWriter)writer, (QName)c_param);
                XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)writer, (QName)_name, (String)p);
                XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)writer, (QName)_value, (String)((String)params.get(p)));
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
        }
        catch (Throwable e) {
            throw XProcStep.raiseError((Throwable)e, (XAtomicStep)this.step);
        }
    }

    private static URIResolver fallback(final URIResolver ... resolvers) {
        return new URIResolver(){

            @Override
            public Source resolve(String href, String base) throws TransformerException {
                UnmodifiableIterator iterator = Iterators.forArray((Object[])resolvers);
                while (iterator.hasNext()) {
                    Source source = ((URIResolver)iterator.next()).resolve(href, base);
                    if (source == null) continue;
                    return source;
                }
                return null;
            }
        };
    }

    @Component(name="pxi:css-analyze", service={XProcStepProvider.class}, property={"type:String={http://www.daisy.org/ns/pipeline/xproc/internal}css-analyze"})
    public static class Provider
    implements XProcStepProvider {
        private URIResolver resolver;
        private UserAgentStylesheetRegistry userAgentStylesheets;

        public XProcStep newStep(XProcRuntime runtime, XAtomicStep step, XProcMonitor monitor, Map<String, String> properties) {
            return new CssAnalyzeStep(runtime, step, this.resolver, this.userAgentStylesheets);
        }

        @Reference(name="URIResolver", unbind="-", service=URIResolver.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC)
        public void setUriResolver(URIResolver resolver) {
            this.resolver = resolver;
        }

        @Reference(name="UserAgentStylesheetRegistry", unbind="-", service=UserAgentStylesheetRegistry.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC)
        public void setUserAgentStylesheetRegistry(UserAgentStylesheetRegistry registry) {
            this.userAgentStylesheets = registry;
        }
    }
}

