/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.css;

import com.google.common.collect.Iterables;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.daisy.pipeline.css.Medium;
import org.daisy.pipeline.css.UserAgentStylesheet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(name="UserAgentStylesheetRegistry", service={UserAgentStylesheetRegistry.class})
public class UserAgentStylesheetRegistry {
    private Collection<UserAgentStylesheet> stylesheets = new ArrayList<UserAgentStylesheet>();

    public Collection<URL> get(Collection<String> types, Collection<String> contentTypes, Collection<Medium> media) {
        ArrayList<URL> filtered = new ArrayList<URL>();
        for (UserAgentStylesheet s : this.stylesheets) {
            if (!types.contains(s.getType())) continue;
            if (!Iterables.any(contentTypes, s::matchesContentType)) continue;
            if (!Iterables.any(media, s::matchesMedium)) continue;
            filtered.add(s.getURL());
        }
        return filtered;
    }

    @Reference(name="UserAgentStylesheet", unbind="-", service=UserAgentStylesheet.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.STATIC)
    protected void addStylesheet(UserAgentStylesheet stylesheet) {
        this.stylesheets.add(stylesheet);
    }
}

