/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.css;

import cz.vutbr.web.css.SourceLocator;
import cz.vutbr.web.csskit.antlr.SourceMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import mjson.Json;
import org.daisy.common.file.URLs;

public final class SourceMapReader {
    private SourceMapReader() {
    }

    public static SourceMap read(String json, URI base) {
        TreeMap<LineColumn, SourceLineColumn> sourceMap;
        try {
            Json jsonObject = Json.read((String)json);
            Json jsonArray = jsonObject.at("sources");
            if (jsonArray == null) {
                throw new RuntimeException("Missing 'sources'");
            }
            if (!jsonArray.isArray()) {
                throw new RuntimeException("Expected array");
            }
            ArrayList<URL> sources = new ArrayList<URL>();
            for (Json s : jsonArray.asJsonList()) {
                if (!s.isString()) {
                    throw new RuntimeException("Expected string");
                }
                if (s.asString().matches("^\\w+:.*")) {
                    sources.add(URLs.asURL((URI)URLs.resolve((URI)base, (URI)URLs.asURI((String)s.asString()))));
                    continue;
                }
                try {
                    sources.add(URLs.asURL((URI)URLs.resolve((URI)base, (URI)new URI(null, null, s.asString(), null))));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            Json jsonString = jsonObject.at("mappings");
            if (jsonString == null) {
                throw new RuntimeException("Missing 'mappings'");
            }
            if (!jsonString.isString()) {
                throw new RuntimeException("Expected string");
            }
            StringCharacterIterator mappings = new StringCharacterIterator(jsonString.asString());
            sourceMap = new TreeMap<LineColumn, SourceLineColumn>();
            int line = 0;
            int column = 0;
            int source = 0;
            int sourceLine = 0;
            int sourceColumn = 0;
            char c = mappings.first();
            while (c != '\uffff') {
                if (c != ',' && c != ';') {
                    column += Base64VlqDecoder.readInteger(mappings);
                    c = mappings.next();
                    if (c != '\uffff' && c != ',' && c != ';') {
                        if ((source += Base64VlqDecoder.readInteger(mappings)) < 0) {
                            throw new RuntimeException("Negative index");
                        }
                        if (source >= sources.size()) {
                            throw new RuntimeException("Index exceeds size of sources array");
                        }
                        c = mappings.next();
                        if (c == '\uffff' || c == ',' || c == ';') {
                            throw new RuntimeException("Segment must have of 1, 4 or 5 values");
                        }
                        sourceLine += Base64VlqDecoder.readInteger(mappings);
                        c = mappings.next();
                        if (c == '\uffff' || c == ',' || c == ';') {
                            throw new RuntimeException("Segment must have of 1, 4 or 5 values");
                        }
                        sourceColumn += Base64VlqDecoder.readInteger(mappings);
                        c = mappings.next();
                        if (c != '\uffff' && c != ',' && c != ';') {
                            c = mappings.next();
                        }
                        if (c != '\uffff' && c != ',' && c != ';') {
                            throw new RuntimeException("Segment must have of 1, 4 or 5 values");
                        }
                        LineColumn pos = new LineColumn(line, column);
                        if (!sourceMap.containsKey(pos)) {
                            sourceMap.put(pos, new SourceLineColumn((URL)sources.get(source), sourceLine, sourceColumn));
                        }
                    }
                }
                if (c == ',') {
                    c = mappings.next();
                    continue;
                }
                if (c == ';') {
                    ++line;
                    column = 0;
                    c = mappings.next();
                    continue;
                }
                break;
            }
        }
        catch (Json.MalformedJsonException e) {
            throw new IllegalArgumentException("Source map could not be parsed: " + json, e);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Source map could not be parsed: " + json, e);
        }
        return new SourceMap(){

            public SourceLocator get(int line, int column) {
                return (SourceLocator)sourceMap.get(new LineColumn(line, column));
            }

            public SourceLocator floor(int line, int column) {
                Map.Entry entry = sourceMap.floorEntry(new LineColumn(line, column));
                return entry == null ? null : (SourceLocator)entry.getValue();
            }

            public SourceLocator ceiling(int line, int column) {
                Map.Entry entry = sourceMap.ceilingEntry(new LineColumn(line, column));
                return entry == null ? null : (SourceLocator)entry.getValue();
            }

            public String toString() {
                return sourceMap.toString();
            }
        };
    }

    private static class Base64VlqDecoder {
        private static final String base64Decoder = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

        private Base64VlqDecoder() {
        }

        private static int readInteger(CharacterIterator base64String) throws IllegalArgumentException {
            int i;
            int shift;
            int result;
            block4: {
                char c = base64String.current();
                if (c == '\uffff') {
                    throw new RuntimeException("End of string");
                }
                result = 0;
                shift = 0;
                do {
                    if ((i = base64Decoder.indexOf(c)) < 0) {
                        throw new RuntimeException("Unexpected base64 character: " + c);
                    }
                    if (i < 32) break block4;
                    result += (i &= 0x1F) << shift;
                    shift += 5;
                } while ((c = base64String.next()) != '\uffff');
                throw new RuntimeException("Expected character after continuation character");
            }
            if ((result += i << shift) % 2 == 0) {
                return result >> 1;
            }
            return -(result >> 1);
        }
    }

    private static class SourceLineColumn
    implements SourceLocator {
        private final URL url;
        private final int line;
        private final int column;

        public SourceLineColumn(URL url, int line, int column) {
            this.url = url;
            this.line = line;
            this.column = column;
        }

        public URL getURL() {
            return this.url;
        }

        public int getLineNumber() {
            return this.line;
        }

        public int getColumnNumber() {
            return this.column;
        }

        public String toString() {
            return this.url + ":" + this.line + ":" + this.column;
        }
    }

    private static class LineColumn
    implements Comparable<LineColumn> {
        private final int line;
        private final int column;

        public LineColumn(int line, int column) {
            this.line = line;
            this.column = column;
        }

        @Override
        public int compareTo(LineColumn that) {
            if (this.line < that.line) {
                return -1;
            }
            if (this.line > that.line) {
                return 1;
            }
            if (this.column < that.column) {
                return -1;
            }
            if (this.column > that.column) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return this.line + ":" + this.column;
        }
    }
}

